/*
 * Decompiled with CFR 0.152.
 */
package alfio.model;

import alfio.model.AdditionalService;
import alfio.model.PriceContainer;
import alfio.util.ClockProvider;
import alfio.util.MonetaryUtil;
import ch.digitalfondue.npjt.ConstructorAnnotationRowMapper;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import org.springframework.security.crypto.codec.Hex;

public record AdditionalService(int id, int eventId, boolean fixPrice, int ordinal, int availableQuantity, int maxQtyPerOrder, ZonedDateTime utcInception, ZonedDateTime utcExpiration, BigDecimal vat, VatType vatType, Integer srcPriceCts, AdditionalServiceType type, SupplementPolicy supplementPolicy, String currencyCode, Integer availableItems, Integer minPriceCts, Integer maxPriceCts) {
    private final int id;
    private final int eventId;
    private final boolean fixPrice;
    private final int ordinal;
    private final int availableQuantity;
    private final int maxQtyPerOrder;
    private final ZonedDateTime utcInception;
    private final ZonedDateTime utcExpiration;
    private final BigDecimal vat;
    private final VatType vatType;
    private final Integer srcPriceCts;
    private final AdditionalServiceType type;
    private final SupplementPolicy supplementPolicy;
    private final String currencyCode;
    private final Integer availableItems;
    private final Integer minPriceCts;
    private final Integer maxPriceCts;

    public AdditionalService(@ConstructorAnnotationRowMapper.Column(value="id") int id, @ConstructorAnnotationRowMapper.Column(value="event_id_fk") int eventId, @ConstructorAnnotationRowMapper.Column(value="fix_price") boolean fixPrice, @ConstructorAnnotationRowMapper.Column(value="ordinal") int ordinal, @ConstructorAnnotationRowMapper.Column(value="available_qty") int availableQuantity, @ConstructorAnnotationRowMapper.Column(value="max_qty_per_order") int maxQtyPerOrder, @ConstructorAnnotationRowMapper.Column(value="inception_ts") ZonedDateTime utcInception, @ConstructorAnnotationRowMapper.Column(value="expiration_ts") ZonedDateTime utcExpiration, @ConstructorAnnotationRowMapper.Column(value="vat") BigDecimal vat, @ConstructorAnnotationRowMapper.Column(value="vat_type") VatType vatType, @ConstructorAnnotationRowMapper.Column(value="src_price_cts") Integer srcPriceCts, @ConstructorAnnotationRowMapper.Column(value="service_type") AdditionalServiceType type, @ConstructorAnnotationRowMapper.Column(value="supplement_policy") SupplementPolicy supplementPolicy, @ConstructorAnnotationRowMapper.Column(value="currency_code") String currencyCode, @ConstructorAnnotationRowMapper.Column(value="available_count") Integer availableItems, @ConstructorAnnotationRowMapper.Column(value="price_min_cts") Integer minPriceCts, @ConstructorAnnotationRowMapper.Column(value="price_max_cts") Integer maxPriceCts) {
        this.id = id;
        this.eventId = eventId;
        this.fixPrice = fixPrice;
        this.ordinal = ordinal;
        this.availableQuantity = availableQuantity;
        this.maxQtyPerOrder = maxQtyPerOrder;
        this.utcInception = utcInception;
        this.utcExpiration = utcExpiration;
        this.vat = vat;
        this.vatType = vatType;
        this.srcPriceCts = srcPriceCts;
        this.type = type;
        this.supplementPolicy = supplementPolicy;
        this.currencyCode = currencyCode;
        this.availableItems = availableItems;
        this.minPriceCts = minPriceCts;
        this.maxPriceCts = maxPriceCts;
    }

    public ZonedDateTime getInception(ZoneId zoneId) {
        return Optional.ofNullable(this.utcInception).map(i -> i.withZoneSameInstant(zoneId)).orElseGet(() -> ZonedDateTime.now(ClockProvider.clock().withZone(zoneId)).minus(1L, ChronoUnit.HOURS));
    }

    public ZonedDateTime getExpiration(ZoneId zoneId) {
        return Optional.ofNullable(this.utcExpiration).map(i -> i.withZoneSameInstant(zoneId)).orElseGet(() -> ZonedDateTime.now(ClockProvider.clock().withZone(zoneId)).plus(1L, ChronoUnit.HOURS));
    }

    public boolean getSaleable() {
        ZonedDateTime now = ZonedDateTime.now(ClockProvider.clock());
        return this.utcInception().isBefore(now) && this.utcExpiration().isAfter(now);
    }

    public BigDecimal getMinPrice() {
        if (this.minPriceCts != null) {
            return MonetaryUtil.centsToUnit((int)this.minPriceCts, (String)this.currencyCode);
        }
        return null;
    }

    public BigDecimal getMaxPrice() {
        if (this.maxPriceCts != null) {
            return MonetaryUtil.centsToUnit((int)this.maxPriceCts, (String)this.currencyCode);
        }
        return null;
    }

    public String getChecksum() {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(Boolean.toString(this.fixPrice).getBytes(StandardCharsets.UTF_8));
            digest.update(Integer.toString(this.ordinal).getBytes(StandardCharsets.UTF_8));
            digest.update(Integer.toString(this.availableQuantity).getBytes(StandardCharsets.UTF_8));
            digest.update(Integer.toString(this.maxQtyPerOrder).getBytes(StandardCharsets.UTF_8));
            digest.update(this.utcInception.toString().getBytes(StandardCharsets.UTF_8));
            digest.update(this.utcExpiration.toString().getBytes(StandardCharsets.UTF_8));
            digest.update(Optional.ofNullable(this.vat).map(BigDecimal::toString).orElse("").getBytes(StandardCharsets.UTF_8));
            digest.update(this.vatType.name().getBytes(StandardCharsets.UTF_8));
            digest.update(this.type.name().getBytes(StandardCharsets.UTF_8));
            if (this.supplementPolicy != null) {
                digest.update(this.supplementPolicy.name().getBytes(StandardCharsets.UTF_8));
            }
            return new String(Hex.encode((byte[])digest.digest()));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public static PriceContainer.VatStatus getVatStatus(VatType vatType, PriceContainer.VatStatus eventVatStatus) {
        return switch (1.$SwitchMap$alfio$model$AdditionalService$VatType[vatType.ordinal()]) {
            case 1 -> eventVatStatus;
            case 2 -> PriceContainer.VatStatus.NONE;
            case 3 -> PriceContainer.VatStatus.INCLUDED;
            default -> PriceContainer.VatStatus.NOT_INCLUDED;
        };
    }

    public int id() {
        return this.id;
    }

    public int eventId() {
        return this.eventId;
    }

    public boolean fixPrice() {
        return this.fixPrice;
    }

    public int ordinal() {
        return this.ordinal;
    }

    public int availableQuantity() {
        return this.availableQuantity;
    }

    public int maxQtyPerOrder() {
        return this.maxQtyPerOrder;
    }

    public ZonedDateTime utcInception() {
        return this.utcInception;
    }

    public ZonedDateTime utcExpiration() {
        return this.utcExpiration;
    }

    public BigDecimal vat() {
        return this.vat;
    }

    public VatType vatType() {
        return this.vatType;
    }

    public Integer srcPriceCts() {
        return this.srcPriceCts;
    }

    public AdditionalServiceType type() {
        return this.type;
    }

    public SupplementPolicy supplementPolicy() {
        return this.supplementPolicy;
    }

    public String currencyCode() {
        return this.currencyCode;
    }

    public Integer availableItems() {
        return this.availableItems;
    }

    public Integer minPriceCts() {
        return this.minPriceCts;
    }

    public Integer maxPriceCts() {
        return this.maxPriceCts;
    }
}

