/*
 * Decompiled with CFR 0.152.
 */
package alfio.model;

import alfio.util.LocaleUtil;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import lombok.Generated;

public class ContentLanguage {
    public static final int ENGLISH_IDENTIFIER = 2;
    public static final ContentLanguage ITALIAN = new ContentLanguage(Locale.ITALIAN, 1, Locale.ITALIAN);
    public static final ContentLanguage ENGLISH = new ContentLanguage(Locale.ENGLISH, 2, Locale.ENGLISH);
    public static final ContentLanguage GERMAN = new ContentLanguage(Locale.GERMAN, 4, Locale.GERMAN);
    public static final ContentLanguage DUTCH = new ContentLanguage(LocaleUtil.forLanguageTag((String)"nl"), 8, LocaleUtil.forLanguageTag((String)"nl"));
    public static final ContentLanguage FRENCH = new ContentLanguage(Locale.FRENCH, 16, Locale.FRENCH);
    public static final ContentLanguage ROMANIAN = new ContentLanguage(LocaleUtil.forLanguageTag((String)"ro"), 32, LocaleUtil.forLanguageTag((String)"ro"));
    public static final ContentLanguage PORTUGUESE = new ContentLanguage(LocaleUtil.forLanguageTag((String)"pt"), 64, LocaleUtil.forLanguageTag((String)"pt"));
    public static final ContentLanguage TURKISH = new ContentLanguage(LocaleUtil.forLanguageTag((String)"tr"), 128, LocaleUtil.forLanguageTag((String)"tr"));
    public static final ContentLanguage SPANISH = new ContentLanguage(LocaleUtil.forLanguageTag((String)"es"), 256, LocaleUtil.forLanguageTag((String)"es"));
    public static final ContentLanguage POLISH = new ContentLanguage(LocaleUtil.forLanguageTag((String)"pl"), 512, LocaleUtil.forLanguageTag((String)"pl"));
    public static final ContentLanguage DANISH = new ContentLanguage(LocaleUtil.forLanguageTag((String)"da"), 1024, LocaleUtil.forLanguageTag((String)"da"));
    public static final ContentLanguage BULGARIAN = new ContentLanguage(LocaleUtil.forLanguageTag((String)"bg"), 2048, LocaleUtil.forLanguageTag((String)"bg"));
    public static final ContentLanguage SWEDISH = new ContentLanguage(LocaleUtil.forLanguageTag((String)"sv"), 4096, LocaleUtil.forLanguageTag((String)"sv"));
    public static final ContentLanguage CZECH = new ContentLanguage(LocaleUtil.forLanguageTag((String)"cs"), 8192, LocaleUtil.forLanguageTag((String)"cs"));
    public static final List<ContentLanguage> ALL_LANGUAGES = List.of(ENGLISH, SPANISH, ITALIAN, GERMAN, DUTCH, FRENCH, ROMANIAN, PORTUGUESE, TURKISH, POLISH, DANISH, BULGARIAN, SWEDISH, CZECH);
    public static final int ALL_LANGUAGES_IDENTIFIER = ALL_LANGUAGES.stream().mapToInt(ContentLanguage::getValue).reduce(0, (a, b) -> a | b);
    private final Locale locale;
    private final int value;
    private final Locale displayLocale;

    public static List<ContentLanguage> findAllFor(int bitMask) {
        return ALL_LANGUAGES.stream().filter(cl -> (cl.getValue() & bitMask) == cl.getValue()).collect(Collectors.toList());
    }

    private ContentLanguage(Locale locale, int value, Locale displayLocale) {
        this.locale = locale;
        this.value = value;
        this.displayLocale = displayLocale;
    }

    public String getLanguage() {
        return this.locale.getLanguage();
    }

    public String getDisplayLanguage() {
        return this.locale.getDisplayLanguage(this.displayLocale);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public int getValue() {
        return this.value;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContentLanguage)) {
            return false;
        }
        ContentLanguage other = (ContentLanguage)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getValue() != other.getValue()) {
            return false;
        }
        Locale this$locale = this.getLocale();
        Locale other$locale = other.getLocale();
        if (this$locale == null ? other$locale != null : !((Object)this$locale).equals(other$locale)) {
            return false;
        }
        Locale this$displayLocale = this.displayLocale;
        Locale other$displayLocale = other.displayLocale;
        return !(this$displayLocale == null ? other$displayLocale != null : !((Object)this$displayLocale).equals(other$displayLocale));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ContentLanguage;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getValue();
        Locale $locale = this.getLocale();
        result = result * 59 + ($locale == null ? 43 : ((Object)$locale).hashCode());
        Locale $displayLocale = this.displayLocale;
        result = result * 59 + ($displayLocale == null ? 43 : ((Object)$displayLocale).hashCode());
        return result;
    }
}

