/*
 * Decompiled with CFR 0.152.
 */
package alfio.model;

import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class CustomerName {
    private final String fullName;
    private final String firstName;
    private final String lastName;
    private final boolean hasFirstAndLastName;

    public CustomerName(String fullName, String firstName, String lastName, boolean mustUseFirstAndLastName) {
        this(fullName, firstName, lastName, mustUseFirstAndLastName, true);
    }

    public CustomerName(String fullName, String firstName, String lastName, boolean mustUseFirstAndLastName, boolean validate) {
        this.firstName = StringUtils.trimToNull((String)firstName);
        this.lastName = StringUtils.trimToNull((String)lastName);
        this.hasFirstAndLastName = mustUseFirstAndLastName;
        fullName = StringUtils.trimToNull((String)fullName);
        if (this.hasFirstAndLastName) {
            if (validate) {
                Validate.isTrue((this.firstName != null ? 1 : 0) != 0, (String)"firstName must not be null", (Object[])new Object[0]);
                Validate.isTrue((this.lastName != null ? 1 : 0) != 0, (String)"lastName must not be null", (Object[])new Object[0]);
            }
            this.fullName = firstName + " " + lastName;
        } else {
            if (validate) {
                Validate.isTrue((fullName != null ? 1 : 0) != 0, (String)"fullName must not be null", (Object[])new Object[0]);
            }
            this.fullName = fullName;
        }
    }

    public String toString() {
        if (this.hasFirstAndLastName) {
            return this.firstName + " " + this.lastName;
        }
        return this.fullName;
    }

    @Generated
    public String getFullName() {
        return this.fullName;
    }

    @Generated
    public String getFirstName() {
        return this.firstName;
    }

    @Generated
    public String getLastName() {
        return this.lastName;
    }

    @Generated
    public boolean isHasFirstAndLastName() {
        return this.hasFirstAndLastName;
    }
}

