/*
 * Decompiled with CFR 0.152.
 */
package alfio.model;

import alfio.model.ContentLanguage;
import alfio.model.Event;
import alfio.model.EventAndOrganizationId;
import alfio.model.EventCheckInInfo;
import alfio.model.EventHiddenFieldContainer;
import alfio.model.PriceContainer;
import alfio.model.PurchaseContext;
import alfio.model.transaction.PaymentProxy;
import alfio.util.ClockProvider;
import alfio.util.EventUtil;
import alfio.util.MonetaryUtil;
import ch.digitalfondue.npjt.ConstructorAnnotationRowMapper;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigDecimal;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.flywaydb.core.api.MigrationVersion;

/*
 * Exception performing whole class analysis ignored.
 */
public class Event
extends EventAndOrganizationId
implements EventHiddenFieldContainer,
EventCheckInInfo,
PurchaseContext {
    private static final String VERSION_FOR_FIRST_AND_LAST_NAME = "15.1.8.8";
    private final EventFormat format;
    private final String shortName;
    private final String displayName;
    private final String websiteUrl;
    private final String externalUrl;
    private final String termsAndConditionsUrl;
    private final String privacyPolicyUrl;
    private final String imageUrl;
    private final String fileBlobId;
    private final String location;
    private final String latitude;
    private final String longitude;
    private final ZonedDateTime begin;
    private final ZonedDateTime end;
    private final String currency;
    private final boolean vatIncluded;
    private final BigDecimal vat;
    private final List<PaymentProxy> allowedPaymentProxies;
    @JsonIgnore
    private final String privateKey;
    private final ZoneId timeZone;
    private final int locales;
    private final int srcPriceCts;
    private final PriceContainer.VatStatus vatStatus;
    private final String version;
    private final Status status;

    public Event(@ConstructorAnnotationRowMapper.Column(value="id") int id, @ConstructorAnnotationRowMapper.Column(value="format") EventFormat format, @ConstructorAnnotationRowMapper.Column(value="short_name") String shortName, @ConstructorAnnotationRowMapper.Column(value="display_name") String displayName, @ConstructorAnnotationRowMapper.Column(value="location") String location, @ConstructorAnnotationRowMapper.Column(value="latitude") String latitude, @ConstructorAnnotationRowMapper.Column(value="longitude") String longitude, @ConstructorAnnotationRowMapper.Column(value="start_ts") ZonedDateTime begin, @ConstructorAnnotationRowMapper.Column(value="end_ts") ZonedDateTime end, @ConstructorAnnotationRowMapper.Column(value="time_zone") String timeZone, @ConstructorAnnotationRowMapper.Column(value="website_url") String websiteUrl, @ConstructorAnnotationRowMapper.Column(value="external_url") String externalUrl, @ConstructorAnnotationRowMapper.Column(value="file_blob_id") String fileBlobId, @ConstructorAnnotationRowMapper.Column(value="website_t_c_url") String termsAndConditionsUrl, @ConstructorAnnotationRowMapper.Column(value="website_p_p_url") String privacyPolicyUrl, @ConstructorAnnotationRowMapper.Column(value="image_url") String imageUrl, @ConstructorAnnotationRowMapper.Column(value="currency") String currency, @ConstructorAnnotationRowMapper.Column(value="vat") BigDecimal vat, @ConstructorAnnotationRowMapper.Column(value="allowed_payment_proxies") String allowedPaymentProxies, @ConstructorAnnotationRowMapper.Column(value="private_key") String privateKey, @ConstructorAnnotationRowMapper.Column(value="org_id") int organizationId, @ConstructorAnnotationRowMapper.Column(value="locales") int locales, @ConstructorAnnotationRowMapper.Column(value="src_price_cts") int srcPriceInCents, @ConstructorAnnotationRowMapper.Column(value="vat_status") PriceContainer.VatStatus vatStatus, @ConstructorAnnotationRowMapper.Column(value="version") String version, @ConstructorAnnotationRowMapper.Column(value="status") Status status) {
        super(id, organizationId);
        this.format = format;
        this.displayName = displayName;
        this.websiteUrl = websiteUrl;
        this.externalUrl = externalUrl;
        this.termsAndConditionsUrl = termsAndConditionsUrl;
        this.privacyPolicyUrl = privacyPolicyUrl;
        this.imageUrl = imageUrl;
        this.fileBlobId = fileBlobId;
        ZoneId zoneId = TimeZone.getTimeZone(timeZone).toZoneId();
        this.shortName = shortName;
        this.location = location;
        this.latitude = latitude;
        this.longitude = longitude;
        this.timeZone = zoneId;
        this.begin = begin.withZoneSameInstant(zoneId);
        this.end = end.withZoneSameInstant(zoneId);
        this.currency = currency;
        this.vatIncluded = vatStatus == PriceContainer.VatStatus.INCLUDED;
        this.vat = vat;
        this.privateKey = privateKey;
        this.locales = locales;
        this.allowedPaymentProxies = Arrays.stream(Optional.ofNullable(allowedPaymentProxies).orElse("").split(",")).filter(StringUtils::isNotBlank).map(PaymentProxy::valueOf).toList();
        this.vatStatus = vatStatus;
        this.srcPriceCts = srcPriceInCents;
        this.version = version;
        this.status = status;
    }

    public Map<String, String> getTitle() {
        return Event.buildTitle((String)this.displayName, (int)this.locales);
    }

    static Map<String, String> buildTitle(String displayName, int locales) {
        return ContentLanguage.findAllFor((int)locales).stream().collect(Collectors.toMap(cl -> cl.getLocale().getLanguage(), cl -> displayName));
    }

    public BigDecimal getRegularPrice() {
        return MonetaryUtil.centsToUnit((int)this.srcPriceCts, (String)this.currency);
    }

    public boolean getSameDay() {
        return this.begin.truncatedTo(ChronoUnit.DAYS).equals(this.end.truncatedTo(ChronoUnit.DAYS));
    }

    @JsonIgnore
    public String getPrivateKey() {
        return this.privateKey;
    }

    @JsonIgnore
    public Pair<String, String> getLatLong() {
        return Pair.of((Object)this.latitude, (Object)this.longitude);
    }

    public ZonedDateTime getBegin() {
        return this.begin;
    }

    public ZonedDateTime getEnd() {
        return this.end;
    }

    public String getTimeZone() {
        return this.timeZone.toString();
    }

    @JsonIgnore
    public ZoneId getZoneId() {
        return this.timeZone;
    }

    public boolean isFreeOfCharge() {
        return this.srcPriceCts == 0;
    }

    public boolean getFree() {
        return this.isFreeOfCharge();
    }

    public boolean getImageIsPresent() {
        return StringUtils.isNotBlank((CharSequence)this.imageUrl) || StringUtils.isNotBlank((CharSequence)this.fileBlobId);
    }

    public boolean getFileBlobIdIsPresent() {
        return StringUtils.isNotBlank((CharSequence)this.fileBlobId);
    }

    public boolean getMultiplePaymentMethods() {
        return this.allowedPaymentProxies.size() > 1;
    }

    public PaymentProxy getFirstPaymentMethod() {
        return this.allowedPaymentProxies.isEmpty() ? null : (PaymentProxy)this.allowedPaymentProxies.get(0);
    }

    public boolean supportsPaymentMethod(PaymentProxy paymentProxy) {
        return this.allowedPaymentProxies.contains(paymentProxy);
    }

    public List<ContentLanguage> getContentLanguages() {
        return ContentLanguage.findAllFor((int)this.getLocales());
    }

    public boolean isOnline() {
        return this.format == EventFormat.ONLINE;
    }

    public boolean getOnline() {
        return this.isOnline();
    }

    public boolean getUseFirstAndLastName() {
        return this.mustUseFirstAndLastName();
    }

    public boolean mustUseFirstAndLastName() {
        return Event.mustUseFirstAndLastName((Event)this);
    }

    public boolean supportsQRCodeCaseInsensitive() {
        return EventUtil.supportsCaseInsensitiveQRCode((String)this.version);
    }

    public boolean supportsAdditionalServicesOrdinal() {
        return EventUtil.supportsAdditionalItemsOrdinal((String)this.version);
    }

    public boolean supportsLinkedAdditionalServices() {
        return EventUtil.supportsLinkedAdditionalServices((String)this.version);
    }

    private static boolean mustUseFirstAndLastName(Event event) {
        return event.getVersion() != null && MigrationVersion.fromVersion((String)event.getVersion()).compareTo(MigrationVersion.fromVersion((String)"15.1.8.8")) >= 0;
    }

    public boolean expired() {
        return this.expiredSince(0);
    }

    public boolean expiredSince(int days) {
        return ZonedDateTime.now(ClockProvider.clock().withZone(this.getZoneId())).truncatedTo(ChronoUnit.DAYS).minusDays(days).isAfter(this.getEnd().truncatedTo(ChronoUnit.DAYS));
    }

    public String getPrivacyPolicyLinkOrNull() {
        return StringUtils.trimToNull((String)this.privacyPolicyUrl);
    }

    public int getBeginTimeZoneOffset() {
        return this.getBegin().getOffset().get(ChronoField.OFFSET_SECONDS);
    }

    public int getEndTimeZoneOffset() {
        return this.getEnd().getOffset().get(ChronoField.OFFSET_SECONDS);
    }

    public boolean getIsOnline() {
        return this.format == EventFormat.ONLINE;
    }

    public String getPublicIdentifier() {
        return this.getShortName();
    }

    public PurchaseContext.PurchaseContextType getType() {
        return PurchaseContext.PurchaseContextType.event;
    }

    @JsonIgnore
    public Optional<Event> event() {
        return Optional.of(this);
    }

    @Generated
    public EventFormat getFormat() {
        return this.format;
    }

    @Generated
    public String getShortName() {
        return this.shortName;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getWebsiteUrl() {
        return this.websiteUrl;
    }

    @Generated
    public String getExternalUrl() {
        return this.externalUrl;
    }

    @Generated
    public String getTermsAndConditionsUrl() {
        return this.termsAndConditionsUrl;
    }

    @Generated
    public String getPrivacyPolicyUrl() {
        return this.privacyPolicyUrl;
    }

    @Generated
    public String getImageUrl() {
        return this.imageUrl;
    }

    @Generated
    public String getFileBlobId() {
        return this.fileBlobId;
    }

    @Generated
    public String getLocation() {
        return this.location;
    }

    @Generated
    public String getLatitude() {
        return this.latitude;
    }

    @Generated
    public String getLongitude() {
        return this.longitude;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public boolean isVatIncluded() {
        return this.vatIncluded;
    }

    @Generated
    public BigDecimal getVat() {
        return this.vat;
    }

    @Generated
    public List<PaymentProxy> getAllowedPaymentProxies() {
        return this.allowedPaymentProxies;
    }

    @Generated
    public int getLocales() {
        return this.locales;
    }

    @Generated
    public int getSrcPriceCts() {
        return this.srcPriceCts;
    }

    @Generated
    public PriceContainer.VatStatus getVatStatus() {
        return this.vatStatus;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public Status getStatus() {
        return this.status;
    }
}

