/*
 * Decompiled with CFR 0.152.
 */
package alfio.model;

import alfio.model.Event;
import alfio.model.EventStatisticView;
import alfio.model.modification.StatisticsContainer;
import alfio.model.transaction.PaymentProxy;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.apache.commons.lang3.builder.CompareToBuilder;

public class EventStatistic
implements StatisticsContainer,
Comparable<EventStatistic> {
    public static final DateTimeFormatter JSON_DATE_FORMATTER = DateTimeFormatter.ofPattern("uuuu-MM-dd HH:mm");
    @JsonIgnore
    private final Event event;
    @JsonIgnore
    private final EventStatisticView eventStatisticView;
    @JsonIgnore
    private final boolean statisticsEnabled;

    public EventStatistic(Event event, EventStatisticView eventStatisticView, boolean statisticsEnabled) {
        this.event = event;
        this.eventStatisticView = eventStatisticView;
        this.statisticsEnabled = statisticsEnabled;
    }

    public List<PaymentProxy> getAllowedPaymentProxies() {
        return this.event.getAllowedPaymentProxies();
    }

    public boolean isWarningNeeded() {
        return !this.isExpired() && (this.eventStatisticView.isContainsOrphanTickets() || this.eventStatisticView.isContainsStuckReservations());
    }

    public int getAvailableSeats() {
        return this.eventStatisticView.getAvailableSeats();
    }

    public String getFormattedBegin() {
        return this.event.getBegin().format(JSON_DATE_FORMATTER);
    }

    public String getFormattedEnd() {
        return this.event.getEnd().format(JSON_DATE_FORMATTER);
    }

    public boolean isExpired() {
        return this.event.expired();
    }

    public String getShortName() {
        return this.event.getShortName();
    }

    public String getDisplayName() {
        return this.event.getDisplayName();
    }

    public int getNotSoldTickets() {
        return this.eventStatisticView.getNotSoldTickets();
    }

    public int getSoldTickets() {
        return this.eventStatisticView.getSoldTickets();
    }

    public int getCheckedInTickets() {
        return this.eventStatisticView.getCheckedInTickets();
    }

    public int getNotAllocatedTickets() {
        return this.eventStatisticView.getNotAllocatedTickets();
    }

    public int getPendingTickets() {
        return this.eventStatisticView.getPendingTickets();
    }

    public int getDynamicAllocation() {
        return this.eventStatisticView.getDynamicAllocation();
    }

    public int getReleasedTickets() {
        return this.eventStatisticView.getReleasedTickets();
    }

    public int getOrganizationId() {
        return this.event.getOrganizationId();
    }

    public int getId() {
        return this.event.getId();
    }

    public Event.Status getStatus() {
        return this.event.getStatus();
    }

    public String getFileBlobId() {
        return this.event.getFileBlobId();
    }

    public boolean isVisibleForCurrentUser() {
        return this.eventStatisticView.isLiveData();
    }

    public boolean isDisplayStatistics() {
        return this.isVisibleForCurrentUser() && this.statisticsEnabled;
    }

    @Override
    public int compareTo(EventStatistic o) {
        CompareToBuilder builder = new CompareToBuilder();
        return builder.append(this.isExpired(), o.isExpired()).append((Object)this.event.getBegin().withZoneSameInstant(ZoneId.systemDefault()), (Object)o.event.getBegin().withZoneSameInstant(ZoneId.systemDefault())).build();
    }
}

