/*
 * Decompiled with CFR 0.152.
 */
package alfio.model;

import alfio.model.ContentLanguage;
import alfio.model.Event;
import alfio.model.EventStatistic;
import alfio.model.ExtensionCapabilitySummary;
import alfio.model.PriceContainer;
import alfio.model.PurchaseContext;
import alfio.model.TicketCategoryWithAdditionalInfo;
import alfio.model.metadata.AlfioMetadata;
import alfio.model.modification.StatisticsContainer;
import alfio.model.transaction.PaymentProxy;
import alfio.util.ClockProvider;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.time.Clock;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;

public class EventWithAdditionalInfo
implements StatisticsContainer,
PriceContainer {
    @JsonIgnore
    private final Event event;
    private final List<TicketCategoryWithAdditionalInfo> ticketCategories;
    @JsonIgnore
    private final EventStatistic eventStatistic;
    private final Map<String, String> description;
    private final BigDecimal grossIncome;
    private final AlfioMetadata metadata;
    private final List<UUID> linkedSubscriptions;
    private final Set<ExtensionCapabilitySummary> supportedCapabilities;

    @JsonIgnore
    public Event getEvent() {
        return this.event;
    }

    @JsonIgnore
    public EventStatistic getEventStatistic() {
        return this.eventStatistic;
    }

    @JsonIgnore
    public int getSrcPriceCts() {
        return this.event.getSrcPriceCts();
    }

    public String getCurrencyCode() {
        return this.getCurrency();
    }

    @JsonIgnore
    public Optional<BigDecimal> getOptionalVatPercentage() {
        return this.getVatStatus() != PriceContainer.VatStatus.NONE ? Optional.ofNullable(this.event.getVat()) : Optional.empty();
    }

    public PriceContainer.VatStatus getVatStatus() {
        return this.event.getVatStatus();
    }

    public BigDecimal getVatPercentage() {
        return this.getVatPercentageOrZero();
    }

    public BigDecimal getVat() {
        return this.getVAT();
    }

    public boolean isAddCategoryEnabled() {
        return this.ticketCategories.stream().mapToInt(TicketCategoryWithAdditionalInfo::getMaxTickets).sum() < this.getAvailableSeats();
    }

    public boolean isContainingUnboundedCategories() {
        return this.getTicketCategories().stream().anyMatch(t -> !t.isBounded());
    }

    public boolean isSupportsAdditionalItemsQuantity() {
        return this.event.supportsLinkedAdditionalServices();
    }

    public boolean isSupportsAdditionalServicesOrdinal() {
        return this.event.supportsAdditionalServicesOrdinal();
    }

    @ConstructorProperties(value={"event", "ticketCategories", "eventStatistic", "description", "grossIncome", "metadata", "linkedSubscriptions", "supportedCapabilities"})
    @Generated
    public EventWithAdditionalInfo(Event event, List<TicketCategoryWithAdditionalInfo> ticketCategories, EventStatistic eventStatistic, Map<String, String> description, BigDecimal grossIncome, AlfioMetadata metadata, List<UUID> linkedSubscriptions, Set<ExtensionCapabilitySummary> supportedCapabilities) {
        this.event = event;
        this.ticketCategories = ticketCategories;
        this.eventStatistic = eventStatistic;
        this.description = description;
        this.grossIncome = grossIncome;
        this.metadata = metadata;
        this.linkedSubscriptions = linkedSubscriptions;
        this.supportedCapabilities = supportedCapabilities;
    }

    @Generated
    public List<TicketCategoryWithAdditionalInfo> getTicketCategories() {
        return this.ticketCategories;
    }

    @Generated
    public Map<String, String> getDescription() {
        return this.description;
    }

    @Generated
    public BigDecimal getGrossIncome() {
        return this.grossIncome;
    }

    @Generated
    public AlfioMetadata getMetadata() {
        return this.metadata;
    }

    @Generated
    public List<UUID> getLinkedSubscriptions() {
        return this.linkedSubscriptions;
    }

    @Generated
    public Set<ExtensionCapabilitySummary> getSupportedCapabilities() {
        return this.supportedCapabilities;
    }

    @Generated
    public Map<String, String> getTitle() {
        return this.event.getTitle();
    }

    @Generated
    public BigDecimal getRegularPrice() {
        return this.event.getRegularPrice();
    }

    @Generated
    public boolean getSameDay() {
        return this.event.getSameDay();
    }

    @Generated
    public ZonedDateTime getBegin() {
        return this.event.getBegin();
    }

    @Generated
    public ZonedDateTime getEnd() {
        return this.event.getEnd();
    }

    @Generated
    public String getTimeZone() {
        return this.event.getTimeZone();
    }

    @Generated
    public boolean isFreeOfCharge() {
        return this.event.isFreeOfCharge();
    }

    @Generated
    public boolean getFree() {
        return this.event.getFree();
    }

    @Generated
    public boolean getImageIsPresent() {
        return this.event.getImageIsPresent();
    }

    @Generated
    public boolean getFileBlobIdIsPresent() {
        return this.event.getFileBlobIdIsPresent();
    }

    @Generated
    public boolean getMultiplePaymentMethods() {
        return this.event.getMultiplePaymentMethods();
    }

    @Generated
    public PaymentProxy getFirstPaymentMethod() {
        return this.event.getFirstPaymentMethod();
    }

    @Generated
    public boolean supportsPaymentMethod(PaymentProxy paymentProxy) {
        return this.event.supportsPaymentMethod(paymentProxy);
    }

    @Generated
    public List<ContentLanguage> getContentLanguages() {
        return this.event.getContentLanguages();
    }

    @Generated
    public boolean isOnline() {
        return this.event.isOnline();
    }

    @Generated
    public boolean getOnline() {
        return this.event.getOnline();
    }

    @Generated
    public boolean getUseFirstAndLastName() {
        return this.event.getUseFirstAndLastName();
    }

    @Generated
    public boolean mustUseFirstAndLastName() {
        return this.event.mustUseFirstAndLastName();
    }

    @Generated
    public boolean supportsQRCodeCaseInsensitive() {
        return this.event.supportsQRCodeCaseInsensitive();
    }

    @Generated
    public boolean supportsAdditionalServicesOrdinal() {
        return this.event.supportsAdditionalServicesOrdinal();
    }

    @Generated
    public boolean supportsLinkedAdditionalServices() {
        return this.event.supportsLinkedAdditionalServices();
    }

    @Generated
    public boolean expired() {
        return this.event.expired();
    }

    @Generated
    public boolean expiredSince(int days) {
        return this.event.expiredSince(days);
    }

    @Generated
    public String getPrivacyPolicyLinkOrNull() {
        return this.event.getPrivacyPolicyLinkOrNull();
    }

    @Generated
    public int getBeginTimeZoneOffset() {
        return this.event.getBeginTimeZoneOffset();
    }

    @Generated
    public int getEndTimeZoneOffset() {
        return this.event.getEndTimeZoneOffset();
    }

    @Generated
    public boolean getIsOnline() {
        return this.event.getIsOnline();
    }

    @Generated
    public String getPublicIdentifier() {
        return this.event.getPublicIdentifier();
    }

    @Generated
    public PurchaseContext.PurchaseContextType getType() {
        return this.event.getType();
    }

    @Generated
    public Optional<Event> event() {
        return this.event.event();
    }

    @Generated
    public Event.EventFormat getFormat() {
        return this.event.getFormat();
    }

    @Generated
    public String getShortName() {
        return this.event.getShortName();
    }

    @Generated
    public String getDisplayName() {
        return this.event.getDisplayName();
    }

    @Generated
    public String getWebsiteUrl() {
        return this.event.getWebsiteUrl();
    }

    @Generated
    public String getExternalUrl() {
        return this.event.getExternalUrl();
    }

    @Generated
    public String getTermsAndConditionsUrl() {
        return this.event.getTermsAndConditionsUrl();
    }

    @Generated
    public String getPrivacyPolicyUrl() {
        return this.event.getPrivacyPolicyUrl();
    }

    @Generated
    public String getImageUrl() {
        return this.event.getImageUrl();
    }

    @Generated
    public String getFileBlobId() {
        return this.event.getFileBlobId();
    }

    @Generated
    public String getLocation() {
        return this.event.getLocation();
    }

    @Generated
    public String getLatitude() {
        return this.event.getLatitude();
    }

    @Generated
    public String getLongitude() {
        return this.event.getLongitude();
    }

    @Generated
    public String getCurrency() {
        return this.event.getCurrency();
    }

    @Generated
    public boolean isVatIncluded() {
        return this.event.isVatIncluded();
    }

    @Generated
    public List<PaymentProxy> getAllowedPaymentProxies() {
        return this.event.getAllowedPaymentProxies();
    }

    @Generated
    public int getLocales() {
        return this.event.getLocales();
    }

    @Generated
    public String getVersion() {
        return this.event.getVersion();
    }

    @Generated
    public Event.Status getStatus() {
        return this.event.getStatus();
    }

    @Generated
    public int getId() {
        return this.event.getId();
    }

    @Generated
    public int getOrganizationId() {
        return this.event.getOrganizationId();
    }

    @Generated
    public ZonedDateTime now(ClockProvider clockProvider) {
        return this.event.now(clockProvider);
    }

    @Generated
    public ZonedDateTime now(Clock clock) {
        return this.event.now(clock);
    }

    @Generated
    public boolean ofType(PurchaseContext.PurchaseContextType purchaseContextType) {
        return this.event.ofType(purchaseContextType);
    }

    @Generated
    public ContentLanguage getFirstContentLanguage() {
        return this.event.getFirstContentLanguage();
    }

    @Generated
    public boolean isWarningNeeded() {
        return this.eventStatistic.isWarningNeeded();
    }

    @Generated
    public int getAvailableSeats() {
        return this.eventStatistic.getAvailableSeats();
    }

    @Generated
    public String getFormattedBegin() {
        return this.eventStatistic.getFormattedBegin();
    }

    @Generated
    public String getFormattedEnd() {
        return this.eventStatistic.getFormattedEnd();
    }

    @Generated
    public boolean isExpired() {
        return this.eventStatistic.isExpired();
    }

    @Generated
    public int getNotSoldTickets() {
        return this.eventStatistic.getNotSoldTickets();
    }

    @Generated
    public int getSoldTickets() {
        return this.eventStatistic.getSoldTickets();
    }

    @Generated
    public int getCheckedInTickets() {
        return this.eventStatistic.getCheckedInTickets();
    }

    @Generated
    public int getNotAllocatedTickets() {
        return this.eventStatistic.getNotAllocatedTickets();
    }

    @Generated
    public int getPendingTickets() {
        return this.eventStatistic.getPendingTickets();
    }

    @Generated
    public int getDynamicAllocation() {
        return this.eventStatistic.getDynamicAllocation();
    }

    @Generated
    public int getReleasedTickets() {
        return this.eventStatistic.getReleasedTickets();
    }

    @Generated
    public boolean isVisibleForCurrentUser() {
        return this.eventStatistic.isVisibleForCurrentUser();
    }

    @Generated
    public boolean isDisplayStatistics() {
        return this.eventStatistic.isDisplayStatistics();
    }

    @Generated
    public int compareTo(EventStatistic o) {
        return this.eventStatistic.compareTo(o);
    }
}

