/*
 * Decompiled with CFR 0.152.
 */
package alfio.model;

import alfio.model.FieldConfigurationDescriptionAndValue;
import alfio.model.PurchaseContextFieldConfiguration;
import alfio.model.PurchaseContextFieldDescription;
import alfio.util.Json;
import com.fasterxml.jackson.core.type.TypeReference;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;

/*
 * Exception performing whole class analysis ignored.
 */
public class FieldConfigurationDescriptionAndValue {
    private final PurchaseContextFieldConfiguration purchaseContextFieldConfiguration;
    private final PurchaseContextFieldDescription purchaseContextFieldDescription;
    private final int count;
    private final String value;
    private static final List<String> TEXT_FIELD_TYPES = List.of("input:text", "input:tel", "textarea", "vat:eu", "dateOfBirth");
    private static final Pattern CHECKBOX_VALUES_PATTERN = Pattern.compile("\"(.*?)\",?");

    public String getTranslatedValue() {
        if (StringUtils.isBlank((CharSequence)this.value)) {
            return this.value;
        }
        if (this.isSelectField()) {
            return this.purchaseContextFieldDescription.getRestrictedValuesDescription().getOrDefault(this.value, "MISSING_DESCRIPTION");
        }
        return this.value;
    }

    public List<Triple<String, String, Boolean>> getTranslatedRestrictedValue() {
        Map description = this.purchaseContextFieldDescription.getRestrictedValuesDescription();
        return this.purchaseContextFieldConfiguration.getRestrictedValues().stream().map(val -> Triple.of((Object)val, (Object)description.getOrDefault(val, "MISSING_DESCRIPTION"), (Object)FieldConfigurationDescriptionAndValue.isFieldValueEnabled((PurchaseContextFieldConfiguration)this.purchaseContextFieldConfiguration, (String)val))).collect(Collectors.toList());
    }

    public List<TicketFieldValue> getFields() {
        if (this.count == 1) {
            return Collections.singletonList(new TicketFieldValue(0, 1, this.value, Boolean.valueOf(this.isAcceptingValues())));
        }
        List values = StringUtils.isBlank((CharSequence)this.value) ? Collections.emptyList() : (List)Json.fromJson((String)this.value, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        return IntStream.range(0, this.count).mapToObj(i -> new TicketFieldValue(i, i + 1, i < values.size() ? (String)values.get(i) : "", Boolean.valueOf(this.isAcceptingValues()))).collect(Collectors.toList());
    }

    private boolean isText() {
        return this.purchaseContextFieldConfiguration.isTextField() || TEXT_FIELD_TYPES.contains(this.purchaseContextFieldConfiguration.getType());
    }

    public String getValueDescription() {
        if (this.isText() || this.isCountryField()) {
            return this.value;
        }
        if (this.isCheckboxField()) {
            ArrayList<String> matches = new ArrayList<String>();
            Matcher matcher = CHECKBOX_VALUES_PATTERN.matcher(this.value);
            while (matcher.find()) {
                matches.add(matcher.group(1));
            }
            List restrictedValues = this.getTranslatedRestrictedValue();
            return matches.stream().map(v -> this.findValueDescription(restrictedValues, v)).filter(StringUtils::isNotBlank).collect(Collectors.joining(", "));
        }
        return this.findValueDescription(this.getTranslatedRestrictedValue(), this.value);
    }

    private String findValueDescription(List<Triple<String, String, Boolean>> translateRestrictedValues, String value) {
        return translateRestrictedValues.stream().filter(t -> StringUtils.equals((CharSequence)((CharSequence)t.getLeft()), (CharSequence)value)).map(Triple::getMiddle).findFirst().orElse("");
    }

    public String getValue() {
        return this.value;
    }

    private boolean isAcceptingValues() {
        return this.isEditable() || StringUtils.isBlank((CharSequence)this.value);
    }

    public boolean isBeforeStandardFields() {
        return FieldConfigurationDescriptionAndValue.isBeforeStandardFields((PurchaseContextFieldConfiguration)this.purchaseContextFieldConfiguration);
    }

    private static boolean isFieldValueEnabled(PurchaseContextFieldConfiguration purchaseContextFieldConfiguration, String value) {
        return !purchaseContextFieldConfiguration.isSelectField() || CollectionUtils.isEmpty((Collection)purchaseContextFieldConfiguration.getDisabledValues()) || !purchaseContextFieldConfiguration.getDisabledValues().contains(value);
    }

    public static boolean isBeforeStandardFields(PurchaseContextFieldConfiguration purchaseContextFieldConfiguration) {
        return purchaseContextFieldConfiguration.getOrder() < 0;
    }

    @ConstructorProperties(value={"purchaseContextFieldConfiguration", "purchaseContextFieldDescription", "count", "value"})
    @Generated
    public FieldConfigurationDescriptionAndValue(PurchaseContextFieldConfiguration purchaseContextFieldConfiguration, PurchaseContextFieldDescription purchaseContextFieldDescription, int count, String value) {
        this.purchaseContextFieldConfiguration = purchaseContextFieldConfiguration;
        this.purchaseContextFieldDescription = purchaseContextFieldDescription;
        this.count = count;
        this.value = value;
    }

    @Generated
    public boolean isInputField() {
        return this.purchaseContextFieldConfiguration.isInputField();
    }

    @Generated
    public boolean isTextareaField() {
        return this.purchaseContextFieldConfiguration.isTextareaField();
    }

    @Generated
    public boolean isCountryField() {
        return this.purchaseContextFieldConfiguration.isCountryField();
    }

    @Generated
    public boolean isSelectField() {
        return this.purchaseContextFieldConfiguration.isSelectField();
    }

    @Generated
    public boolean isCheckboxField() {
        return this.purchaseContextFieldConfiguration.isCheckboxField();
    }

    @Generated
    public int getCount() {
        return this.purchaseContextFieldConfiguration.getCount();
    }

    @Generated
    public boolean isEuVat() {
        return this.purchaseContextFieldConfiguration.isEuVat();
    }

    @Generated
    public boolean isDateOfBirth() {
        return this.purchaseContextFieldConfiguration.isDateOfBirth();
    }

    @Generated
    public String getInputType() {
        return this.purchaseContextFieldConfiguration.getInputType();
    }

    @Generated
    public boolean isMaxLengthDefined() {
        return this.purchaseContextFieldConfiguration.isMaxLengthDefined();
    }

    @Generated
    public boolean hasDisabledValues() {
        return this.purchaseContextFieldConfiguration.hasDisabledValues();
    }

    @Generated
    public boolean isMinLengthDefined() {
        return this.purchaseContextFieldConfiguration.isMinLengthDefined();
    }

    @Generated
    public boolean rulesApply(Integer ticketCategoryId) {
        return this.purchaseContextFieldConfiguration.rulesApply(ticketCategoryId);
    }

    @Generated
    public boolean isReadOnly() {
        return this.purchaseContextFieldConfiguration.isReadOnly();
    }

    @Generated
    public boolean isTextField() {
        return this.purchaseContextFieldConfiguration.isTextField();
    }

    @Generated
    public long getId() {
        return this.purchaseContextFieldConfiguration.getId();
    }

    @Generated
    public Integer getEventId() {
        return this.purchaseContextFieldConfiguration.getEventId();
    }

    @Generated
    public UUID getSubscriptionDescriptorId() {
        return this.purchaseContextFieldConfiguration.getSubscriptionDescriptorId();
    }

    @Generated
    public String getName() {
        return this.purchaseContextFieldConfiguration.getName();
    }

    @Generated
    public int getOrder() {
        return this.purchaseContextFieldConfiguration.getOrder();
    }

    @Generated
    public String getType() {
        return this.purchaseContextFieldConfiguration.getType();
    }

    @Generated
    public Integer getMaxLength() {
        return this.purchaseContextFieldConfiguration.getMaxLength();
    }

    @Generated
    public Integer getMinLength() {
        return this.purchaseContextFieldConfiguration.getMinLength();
    }

    @Generated
    public boolean isRequired() {
        return this.purchaseContextFieldConfiguration.isRequired();
    }

    @Generated
    public boolean isEditable() {
        return this.purchaseContextFieldConfiguration.isEditable();
    }

    @Generated
    public List<String> getRestrictedValues() {
        return this.purchaseContextFieldConfiguration.getRestrictedValues();
    }

    @Generated
    public PurchaseContextFieldConfiguration.Context getContext() {
        return this.purchaseContextFieldConfiguration.getContext();
    }

    @Generated
    public Integer getAdditionalServiceId() {
        return this.purchaseContextFieldConfiguration.getAdditionalServiceId();
    }

    @Generated
    public List<Integer> getCategoryIds() {
        return this.purchaseContextFieldConfiguration.getCategoryIds();
    }

    @Generated
    public List<String> getDisabledValues() {
        return this.purchaseContextFieldConfiguration.getDisabledValues();
    }

    @Generated
    public String getLabelDescription() {
        return this.purchaseContextFieldDescription.getLabelDescription();
    }

    @Generated
    public boolean isPlaceholderDescriptionDefined() {
        return this.purchaseContextFieldDescription.isPlaceholderDescriptionDefined();
    }

    @Generated
    public String getPlaceholderDescription() {
        return this.purchaseContextFieldDescription.getPlaceholderDescription();
    }

    @Generated
    public Map<String, String> getRestrictedValuesDescription() {
        return this.purchaseContextFieldDescription.getRestrictedValuesDescription();
    }

    @Generated
    public long getFieldConfigurationId() {
        return this.purchaseContextFieldDescription.getFieldConfigurationId();
    }

    @Generated
    public String getLocale() {
        return this.purchaseContextFieldDescription.getLocale();
    }

    @Generated
    public Map<String, Object> getDescription() {
        return this.purchaseContextFieldDescription.getDescription();
    }

    @Generated
    public String getFieldName() {
        return this.purchaseContextFieldDescription.getFieldName();
    }
}

