/*
 * Decompiled with CFR 0.152.
 */
package alfio.model;

import alfio.model.PriceContainer;
import alfio.model.SummaryRow;
import alfio.model.TotalPrice;
import alfio.util.MonetaryUtil;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public class OrderSummary {
    private final TotalPrice originalTotalPrice;
    private final List<SummaryRow> summary;
    private final boolean free;
    private final String totalPrice;
    private final String totalVAT;
    private final boolean waitingForPayment;
    private final boolean deferredPayment;
    private final boolean cashPayment;
    private final String vatPercentage;
    private final PriceContainer.VatStatus vatStatus;
    private final String refundedAmount;

    public boolean getFree() {
        return this.free;
    }

    public boolean getWaitingForPayment() {
        return this.waitingForPayment;
    }

    public boolean getCashPayment() {
        return this.cashPayment;
    }

    public boolean getNotYetPaid() {
        return this.waitingForPayment || this.cashPayment || this.deferredPayment;
    }

    public int getTicketAmount() {
        return this.summary.stream().filter(s -> SummaryRow.SummaryType.TICKET == s.getType()).mapToInt(SummaryRow::getAmount).sum();
    }

    public List<SummaryRow> getSummary() {
        return this.summary.stream().filter(s -> !s.isDiscount() || s.getAmount() != 0).collect(Collectors.toList());
    }

    public boolean getSingleTicketOrder() {
        return this.getTicketAmount() == 1;
    }

    public boolean getDisplayVat() {
        return !this.isVatExempt();
    }

    public boolean isVatExempt() {
        return PriceContainer.VatStatus.isVatExempt((PriceContainer.VatStatus)this.vatStatus);
    }

    public String getRefundedAmount() {
        return this.refundedAmount;
    }

    public String getTotalNetPrice() {
        if (this.free) {
            return null;
        }
        return MonetaryUtil.formatCents((int)(this.originalTotalPrice.getPriceWithVAT() - this.originalTotalPrice.getVAT()), (String)this.originalTotalPrice.getCurrencyCode());
    }

    public int getPriceInCents() {
        return this.originalTotalPrice.getPriceWithVAT();
    }

    public String getDescriptionForPayment() {
        return this.summary.stream().filter(r -> !r.isDiscount() && !r.getTaxDetail()).map(SummaryRow::getDescriptionForPayment).collect(Collectors.joining(", "));
    }

    public boolean getDisplaySplitPaymentNote() {
        return !this.free && (this.vatStatus == PriceContainer.VatStatus.INCLUDED_NOT_CHARGED || this.vatStatus == PriceContainer.VatStatus.NOT_INCLUDED_NOT_CHARGED);
    }

    public String getPriceBeforeTaxes() {
        String currencyCode = this.originalTotalPrice.getCurrencyCode();
        if (PriceContainer.VatStatus.isVatIncluded((PriceContainer.VatStatus)this.vatStatus)) {
            BigDecimal vat = this.vatStatus.extractVat(MonetaryUtil.centsToUnit((int)this.originalTotalPrice.getPriceWithVAT(), (String)currencyCode), new BigDecimal(this.vatPercentage));
            return MonetaryUtil.formatUnit((BigDecimal)new BigDecimal(this.getTotalPrice()).subtract(vat), (String)currencyCode);
        }
        return MonetaryUtil.formatCents((int)(this.originalTotalPrice.getPriceWithVAT() - this.originalTotalPrice.getVAT()), (String)currencyCode);
    }

    @ConstructorProperties(value={"originalTotalPrice", "summary", "free", "totalPrice", "totalVAT", "waitingForPayment", "deferredPayment", "cashPayment", "vatPercentage", "vatStatus", "refundedAmount"})
    @Generated
    public OrderSummary(TotalPrice originalTotalPrice, List<SummaryRow> summary, boolean free, String totalPrice, String totalVAT, boolean waitingForPayment, boolean deferredPayment, boolean cashPayment, String vatPercentage, PriceContainer.VatStatus vatStatus, String refundedAmount) {
        this.originalTotalPrice = originalTotalPrice;
        this.summary = summary;
        this.free = free;
        this.totalPrice = totalPrice;
        this.totalVAT = totalVAT;
        this.waitingForPayment = waitingForPayment;
        this.deferredPayment = deferredPayment;
        this.cashPayment = cashPayment;
        this.vatPercentage = vatPercentage;
        this.vatStatus = vatStatus;
        this.refundedAmount = refundedAmount;
    }

    @Generated
    public TotalPrice getOriginalTotalPrice() {
        return this.originalTotalPrice;
    }

    @Generated
    public String getTotalPrice() {
        return this.totalPrice;
    }

    @Generated
    public String getTotalVAT() {
        return this.totalVAT;
    }

    @Generated
    public boolean isDeferredPayment() {
        return this.deferredPayment;
    }

    @Generated
    public String getVatPercentage() {
        return this.vatPercentage;
    }

    @Generated
    public PriceContainer.VatStatus getVatStatus() {
        return this.vatStatus;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrderSummary)) {
            return false;
        }
        OrderSummary other = (OrderSummary)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getFree() != other.getFree()) {
            return false;
        }
        if (this.getWaitingForPayment() != other.getWaitingForPayment()) {
            return false;
        }
        if (this.isDeferredPayment() != other.isDeferredPayment()) {
            return false;
        }
        if (this.getCashPayment() != other.getCashPayment()) {
            return false;
        }
        TotalPrice this$originalTotalPrice = this.getOriginalTotalPrice();
        TotalPrice other$originalTotalPrice = other.getOriginalTotalPrice();
        if (this$originalTotalPrice == null ? other$originalTotalPrice != null : !this$originalTotalPrice.equals(other$originalTotalPrice)) {
            return false;
        }
        List this$summary = this.getSummary();
        List other$summary = other.getSummary();
        if (this$summary == null ? other$summary != null : !((Object)this$summary).equals(other$summary)) {
            return false;
        }
        String this$totalPrice = this.getTotalPrice();
        String other$totalPrice = other.getTotalPrice();
        if (this$totalPrice == null ? other$totalPrice != null : !this$totalPrice.equals(other$totalPrice)) {
            return false;
        }
        String this$totalVAT = this.getTotalVAT();
        String other$totalVAT = other.getTotalVAT();
        if (this$totalVAT == null ? other$totalVAT != null : !this$totalVAT.equals(other$totalVAT)) {
            return false;
        }
        String this$vatPercentage = this.getVatPercentage();
        String other$vatPercentage = other.getVatPercentage();
        if (this$vatPercentage == null ? other$vatPercentage != null : !this$vatPercentage.equals(other$vatPercentage)) {
            return false;
        }
        PriceContainer.VatStatus this$vatStatus = this.getVatStatus();
        PriceContainer.VatStatus other$vatStatus = other.getVatStatus();
        if (this$vatStatus == null ? other$vatStatus != null : !this$vatStatus.equals(other$vatStatus)) {
            return false;
        }
        String this$refundedAmount = this.getRefundedAmount();
        String other$refundedAmount = other.getRefundedAmount();
        return !(this$refundedAmount == null ? other$refundedAmount != null : !this$refundedAmount.equals(other$refundedAmount));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OrderSummary;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.getFree() ? 79 : 97);
        result = result * 59 + (this.getWaitingForPayment() ? 79 : 97);
        result = result * 59 + (this.isDeferredPayment() ? 79 : 97);
        result = result * 59 + (this.getCashPayment() ? 79 : 97);
        TotalPrice $originalTotalPrice = this.getOriginalTotalPrice();
        result = result * 59 + ($originalTotalPrice == null ? 43 : $originalTotalPrice.hashCode());
        List $summary = this.getSummary();
        result = result * 59 + ($summary == null ? 43 : ((Object)$summary).hashCode());
        String $totalPrice = this.getTotalPrice();
        result = result * 59 + ($totalPrice == null ? 43 : $totalPrice.hashCode());
        String $totalVAT = this.getTotalVAT();
        result = result * 59 + ($totalVAT == null ? 43 : $totalVAT.hashCode());
        String $vatPercentage = this.getVatPercentage();
        result = result * 59 + ($vatPercentage == null ? 43 : $vatPercentage.hashCode());
        PriceContainer.VatStatus $vatStatus = this.getVatStatus();
        result = result * 59 + ($vatStatus == null ? 43 : $vatStatus.hashCode());
        String $refundedAmount = this.getRefundedAmount();
        result = result * 59 + ($refundedAmount == null ? 43 : $refundedAmount.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "OrderSummary(originalTotalPrice=" + this.getOriginalTotalPrice() + ", summary=" + this.getSummary() + ", free=" + this.getFree() + ", totalPrice=" + this.getTotalPrice() + ", totalVAT=" + this.getTotalVAT() + ", waitingForPayment=" + this.getWaitingForPayment() + ", deferredPayment=" + this.isDeferredPayment() + ", cashPayment=" + this.getCashPayment() + ", vatPercentage=" + this.getVatPercentage() + ", vatStatus=" + this.getVatStatus() + ", refundedAmount=" + this.getRefundedAmount() + ")";
    }
}

