/*
 * Decompiled with CFR 0.152.
 */
package alfio.model;

import alfio.model.PriceContainer;
import alfio.model.PromoCodeDiscount;
import alfio.util.MonetaryUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Optional;
import java.util.function.BinaryOperator;

/*
 * Exception performing whole class analysis ignored.
 */
public interface PriceContainer {
    public static final BinaryOperator<BigDecimal> includedVatExtractor = MonetaryUtil::extractVAT;
    public static final BinaryOperator<BigDecimal> notIncludedVatCalculator = MonetaryUtil::calcVat;

    public int getSrcPriceCts();

    @JsonIgnore
    default public Optional<PromoCodeDiscount> getDiscount() {
        return Optional.empty();
    }

    public String getCurrencyCode();

    @JsonIgnore
    public Optional<BigDecimal> getOptionalVatPercentage();

    @JsonIgnore
    default public BigDecimal getVatPercentageOrZero() {
        return this.getOptionalVatPercentage().orElse(BigDecimal.ZERO);
    }

    public VatStatus getVatStatus();

    default public BigDecimal getFinalPrice() {
        VatStatus vatStatus = this.getVatStatus();
        if (this.getSrcPriceCts() == 0 || vatStatus == null) {
            return BigDecimal.ZERO;
        }
        BigDecimal price = MonetaryUtil.centsToUnit((int)this.getSrcPriceCts(), (String)this.getCurrencyCode());
        BigDecimal discountedPrice = price.subtract(this.getAppliedDiscount());
        return switch (1.$SwitchMap$alfio$model$PriceContainer$VatStatus[vatStatus.ordinal()]) {
            case 1, 2 -> discountedPrice;
            case 3 -> discountedPrice.subtract(this.getVAT());
            default -> discountedPrice.add(this.getVAT());
        };
    }

    default public BigDecimal getTaxablePrice() {
        return MonetaryUtil.centsToUnit((int)this.getSrcPriceCts(), (String)this.getCurrencyCode()).subtract(this.getAppliedDiscount());
    }

    @JsonIgnore
    default public BigDecimal getVAT() {
        return PriceContainer.getVAT((BigDecimal)this.getTaxablePrice(), (VatStatus)this.getVatStatus(), (BigDecimal)this.getVatPercentageOrZero());
    }

    @JsonIgnore
    default public BigDecimal getAppliedDiscount() {
        return this.getDiscount().filter(discount -> discount.getDiscountType() != PromoCodeDiscount.DiscountType.FIXED_AMOUNT_RESERVATION && discount.getCodeType() != PromoCodeDiscount.CodeType.ACCESS).map(discount -> {
            String currencyCode = this.getCurrencyCode();
            BigDecimal price = MonetaryUtil.centsToUnit((int)this.getSrcPriceCts(), (String)currencyCode);
            if (discount.getFixedAmount()) {
                return MonetaryUtil.centsToUnit((int)Math.min(this.getSrcPriceCts(), discount.getDiscountAmount()), (String)currencyCode);
            }
            return MonetaryUtil.fixScale((BigDecimal)price.multiply(new BigDecimal(discount.getDiscountAmount()).divide(MonetaryUtil.HUNDRED, 2, RoundingMode.UNNECESSARY)), (String)currencyCode);
        }).orElse(BigDecimal.ZERO);
    }

    default public BigDecimal getNetPrice() {
        VatStatus vatStatus = this.getVatStatus();
        String currencyCode = this.getCurrencyCode();
        if (vatStatus == VatStatus.NOT_INCLUDED_EXEMPT || vatStatus == VatStatus.CUSTOM_NOT_INCLUDED_EXEMPT) {
            return MonetaryUtil.centsToUnit((int)this.getSrcPriceCts(), (String)currencyCode);
        }
        if (vatStatus == VatStatus.INCLUDED_EXEMPT || vatStatus == VatStatus.CUSTOM_INCLUDED_EXEMPT) {
            BigDecimal rawVat = vatStatus.extractRawVAT(MonetaryUtil.centsToUnit((int)this.getSrcPriceCts(), (String)this.getCurrencyCode()), this.getVatPercentageOrZero());
            return MonetaryUtil.centsToUnit((int)this.getSrcPriceCts(), (String)currencyCode).add(rawVat);
        }
        if (vatStatus == VatStatus.INCLUDED || vatStatus == VatStatus.INCLUDED_NOT_CHARGED) {
            BigDecimal rawVat = vatStatus.extractRawVAT(MonetaryUtil.centsToUnit((int)this.getSrcPriceCts(), (String)this.getCurrencyCode()), this.getVatPercentageOrZero());
            return MonetaryUtil.centsToUnit((int)this.getSrcPriceCts(), (String)currencyCode).subtract(rawVat);
        }
        return MonetaryUtil.centsToUnit((int)this.getSrcPriceCts(), (String)currencyCode);
    }

    public static BigDecimal getVAT(BigDecimal price, VatStatus vatStatus, BigDecimal vatPercentage) {
        return vatStatus.extractVat(price, vatPercentage);
    }
}

