/*
 * Decompiled with CFR 0.152.
 */
package alfio.model;

import alfio.model.PromoCodeDiscount;
import alfio.util.Json;
import alfio.util.MonetaryUtil;
import ch.digitalfondue.npjt.ConstructorAnnotationRowMapper;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class PromoCodeDiscount {
    private final int id;
    private final String promoCode;
    private final Integer eventId;
    private final Integer organizationId;
    private final ZonedDateTime utcStart;
    private final ZonedDateTime utcEnd;
    private final int discountAmount;
    private final DiscountType discountType;
    private final Set<Integer> categories;
    private final Integer maxUsage;
    private final String description;
    private final String emailReference;
    private final CodeType codeType;
    private final Integer hiddenCategoryId;
    private final String currencyCode;

    public PromoCodeDiscount(@ConstructorAnnotationRowMapper.Column(value="id") int id, @ConstructorAnnotationRowMapper.Column(value="promo_code") String promoCode, @ConstructorAnnotationRowMapper.Column(value="event_id_fk") Integer eventId, @ConstructorAnnotationRowMapper.Column(value="organization_id_fk") Integer organizationId, @ConstructorAnnotationRowMapper.Column(value="valid_from") ZonedDateTime utcStart, @ConstructorAnnotationRowMapper.Column(value="valid_to") ZonedDateTime utcEnd, @ConstructorAnnotationRowMapper.Column(value="discount_amount") int discountAmount, @ConstructorAnnotationRowMapper.Column(value="discount_type") DiscountType discountType, @ConstructorAnnotationRowMapper.Column(value="categories") String categories, @ConstructorAnnotationRowMapper.Column(value="max_usage") Integer maxUsage, @ConstructorAnnotationRowMapper.Column(value="description") String description, @ConstructorAnnotationRowMapper.Column(value="email_reference") String emailReference, @ConstructorAnnotationRowMapper.Column(value="code_type") CodeType codeType, @ConstructorAnnotationRowMapper.Column(value="hidden_category_id") Integer hiddenCategoryId, @ConstructorAnnotationRowMapper.Column(value="currency_code") String currencyCode) {
        List categoriesId;
        this.id = id;
        this.promoCode = promoCode;
        this.eventId = eventId;
        this.organizationId = organizationId;
        this.utcStart = utcStart;
        this.utcEnd = utcEnd;
        this.discountAmount = discountAmount;
        this.discountType = discountType;
        this.maxUsage = maxUsage;
        this.categories = categories != null ? ((categoriesId = (List)Json.GSON.fromJson(categories, new /* Unavailable Anonymous Inner Class!! */.getType())) == null ? Collections.emptySet() : new TreeSet(categoriesId)) : Collections.emptySet();
        this.description = description;
        this.emailReference = emailReference;
        this.codeType = codeType;
        this.hiddenCategoryId = hiddenCategoryId;
        this.currencyCode = currencyCode;
    }

    public boolean isCurrentlyValid(ZoneId eventZoneId, ZonedDateTime now) {
        return this.utcStart.withZoneSameInstant(eventZoneId).isBefore(now) && this.utcEnd.withZoneSameInstant(eventZoneId).isAfter(now);
    }

    public boolean isExpired(ZoneId eventZoneId, ZonedDateTime now) {
        return now.isAfter(this.utcEnd.withZoneSameInstant(eventZoneId));
    }

    public boolean getFixedAmount() {
        return DiscountType.FIXED_AMOUNT == this.discountType || DiscountType.FIXED_AMOUNT_RESERVATION == this.discountType;
    }

    public static Set<Integer> categoriesOrNull(PromoCodeDiscount code) {
        if (code.codeType == CodeType.DYNAMIC) {
            return null;
        }
        if (code.codeType == CodeType.DISCOUNT) {
            Set categories = code.getCategories();
            return CollectionUtils.isEmpty((Collection)categories) ? null : categories;
        }
        return Set.of(code.hiddenCategoryId);
    }

    public boolean isDynamic() {
        return this.codeType == CodeType.DYNAMIC;
    }

    public boolean hasCurrencyCode() {
        return StringUtils.length((CharSequence)this.currencyCode) == 3;
    }

    public static String format(PromoCodeDiscount discount, String eventCurrencyCode) {
        if (discount.getDiscountType() == DiscountType.PERCENTAGE) {
            return Integer.toString(discount.getDiscountAmount());
        }
        return MonetaryUtil.formatCents((int)discount.getDiscountAmount(), (String)eventCurrencyCode);
    }

    public static boolean supportsCurrencyCode(CodeType codeType, DiscountType discountType) {
        return codeType == CodeType.DISCOUNT && discountType != DiscountType.PERCENTAGE;
    }

    @Generated
    public int getId() {
        return this.id;
    }

    @Generated
    public String getPromoCode() {
        return this.promoCode;
    }

    @Generated
    public Integer getEventId() {
        return this.eventId;
    }

    @Generated
    public Integer getOrganizationId() {
        return this.organizationId;
    }

    @Generated
    public ZonedDateTime getUtcStart() {
        return this.utcStart;
    }

    @Generated
    public ZonedDateTime getUtcEnd() {
        return this.utcEnd;
    }

    @Generated
    public int getDiscountAmount() {
        return this.discountAmount;
    }

    @Generated
    public DiscountType getDiscountType() {
        return this.discountType;
    }

    @Generated
    public Set<Integer> getCategories() {
        return this.categories;
    }

    @Generated
    public Integer getMaxUsage() {
        return this.maxUsage;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getEmailReference() {
        return this.emailReference;
    }

    @Generated
    public CodeType getCodeType() {
        return this.codeType;
    }

    @Generated
    public Integer getHiddenCategoryId() {
        return this.hiddenCategoryId;
    }

    @Generated
    public String getCurrencyCode() {
        return this.currencyCode;
    }
}

