/*
 * Decompiled with CFR 0.152.
 */
package alfio.model;

import alfio.model.Configurable;
import alfio.model.Event;
import alfio.model.LocalizedContent;
import alfio.model.PriceContainer;
import alfio.model.PurchaseContext;
import alfio.model.TimeZoneInfo;
import alfio.model.transaction.PaymentProxy;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public interface PurchaseContext
extends Configurable,
TimeZoneInfo,
LocalizedContent {
    public Map<String, String> getTitle();

    public BigDecimal getVat();

    public PriceContainer.VatStatus getVatStatus();

    public String getCurrency();

    public List<PaymentProxy> getAllowedPaymentProxies();

    public String getPrivacyPolicyLinkOrNull();

    public String getPrivacyPolicyUrl();

    public String getTermsAndConditionsUrl();

    public int getOrganizationId();

    public PurchaseContextType getType();

    public String getPublicIdentifier();

    public String getFileBlobId();

    public boolean isFreeOfCharge();

    public String getDisplayName();

    public Optional<Event> event();

    public ZonedDateTime getBegin();

    public String getPrivateKey();

    default public boolean mustUseFirstAndLastName() {
        return true;
    }

    default public boolean getFileBlobIdIsPresent() {
        return true;
    }

    default public boolean ofType(PurchaseContextType purchaseContextType) {
        return this.getType() == purchaseContextType;
    }
}

