/*
 * Decompiled with CFR 0.152.
 */
package alfio.model;

import alfio.model.PurchaseContextFieldConfiguration;
import alfio.util.Json;
import ch.digitalfondue.npjt.ConstructorAnnotationRowMapper;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;

public class PurchaseContextFieldConfiguration {
    public static final Set<Context> EVENT_RELATED_CONTEXTS = Set.copyOf(EnumSet.of(Context.ATTENDEE, Context.ADDITIONAL_SERVICE));
    private static final Pattern COLON_SPLITTER = Pattern.compile(":");
    private final long id;
    private final Integer eventId;
    private final UUID subscriptionDescriptorId;
    private final String name;
    private final int order;
    private final String type;
    private final Integer maxLength;
    private final Integer minLength;
    private final boolean required;
    private final boolean editable;
    private final List<String> restrictedValues;
    private final Context context;
    private final Integer additionalServiceId;
    private final List<Integer> categoryIds;
    private final List<String> disabledValues;

    public PurchaseContextFieldConfiguration(@ConstructorAnnotationRowMapper.Column(value="id") int id, @ConstructorAnnotationRowMapper.Column(value="event_id_fk") Integer eventId, @ConstructorAnnotationRowMapper.Column(value="subscription_descriptor_id_fk") UUID subscriptionDescriptorId, @ConstructorAnnotationRowMapper.Column(value="field_name") String name, @ConstructorAnnotationRowMapper.Column(value="field_order") int order, @ConstructorAnnotationRowMapper.Column(value="field_type") String type, @ConstructorAnnotationRowMapper.Column(value="field_maxlength") Integer maxLength, @ConstructorAnnotationRowMapper.Column(value="field_minlength") Integer minLength, @ConstructorAnnotationRowMapper.Column(value="field_required") boolean required, @ConstructorAnnotationRowMapper.Column(value="field_editable") boolean editable, @ConstructorAnnotationRowMapper.Column(value="field_restricted_values") String restrictedValues, @ConstructorAnnotationRowMapper.Column(value="context") Context context, @ConstructorAnnotationRowMapper.Column(value="additional_service_id") Integer additionalServiceId, @ConstructorAnnotationRowMapper.Column(value="ticket_category_ids") String ticketCategoryIds, @ConstructorAnnotationRowMapper.Column(value="field_disabled_values") String disabledValues) {
        this.id = id;
        this.eventId = eventId;
        this.subscriptionDescriptorId = subscriptionDescriptorId;
        this.name = name;
        this.order = order;
        this.type = type;
        this.maxLength = maxLength;
        this.minLength = minLength;
        this.required = required;
        this.editable = editable;
        this.restrictedValues = restrictedValues == null ? Collections.emptyList() : (List)Json.GSON.fromJson(restrictedValues, new /* Unavailable Anonymous Inner Class!! */.getType());
        this.disabledValues = disabledValues == null ? Collections.emptyList() : (List)Json.GSON.fromJson(disabledValues, new /* Unavailable Anonymous Inner Class!! */.getType());
        this.context = context;
        this.additionalServiceId = additionalServiceId;
        this.categoryIds = ticketCategoryIds == null ? Collections.emptyList() : (List)Json.GSON.fromJson(ticketCategoryIds, new /* Unavailable Anonymous Inner Class!! */.getType());
    }

    public boolean isInputField() {
        return this.type.startsWith("input:");
    }

    public boolean isTextareaField() {
        return "textarea".equals(this.type);
    }

    public boolean isCountryField() {
        return "country".equals(this.type);
    }

    public boolean isSelectField() {
        return "select".equals(this.type);
    }

    public boolean isCheckboxField() {
        return "checkbox".equals(this.type);
    }

    public int getCount() {
        if ("checkbox".equals(this.type) && this.restrictedValues != null) {
            return Math.max(this.restrictedValues.size(), 1);
        }
        return 1;
    }

    public boolean isEuVat() {
        return "vat:eu".equals(this.type);
    }

    public boolean isDateOfBirth() {
        return "input:dateOfBirth".equals(this.type);
    }

    public String getInputType() {
        String[] split = COLON_SPLITTER.split(this.type);
        return split.length == 2 ? split[1] : "text";
    }

    public boolean isMaxLengthDefined() {
        return this.maxLength != null;
    }

    public boolean hasDisabledValues() {
        return CollectionUtils.isNotEmpty((Collection)this.disabledValues);
    }

    public boolean isMinLengthDefined() {
        return this.minLength != null;
    }

    public boolean rulesApply(Integer ticketCategoryId) {
        return this.categoryIds.isEmpty() || this.categoryIds.contains(ticketCategoryId);
    }

    public boolean isReadOnly() {
        return !this.editable;
    }

    public boolean isTextField() {
        return this.isInputField() || this.isTextareaField();
    }

    @Generated
    public long getId() {
        return this.id;
    }

    @Generated
    public Integer getEventId() {
        return this.eventId;
    }

    @Generated
    public UUID getSubscriptionDescriptorId() {
        return this.subscriptionDescriptorId;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public Integer getMaxLength() {
        return this.maxLength;
    }

    @Generated
    public Integer getMinLength() {
        return this.minLength;
    }

    @Generated
    public boolean isRequired() {
        return this.required;
    }

    @Generated
    public boolean isEditable() {
        return this.editable;
    }

    @Generated
    public List<String> getRestrictedValues() {
        return this.restrictedValues;
    }

    @Generated
    public Context getContext() {
        return this.context;
    }

    @Generated
    public Integer getAdditionalServiceId() {
        return this.additionalServiceId;
    }

    @Generated
    public List<Integer> getCategoryIds() {
        return this.categoryIds;
    }

    @Generated
    public List<String> getDisabledValues() {
        return this.disabledValues;
    }
}

