/*
 * Decompiled with CFR 0.152.
 */
package alfio.model;

import alfio.model.PriceContainer;
import alfio.model.PurchaseContext;
import alfio.model.ReservationWithPurchaseContext;
import alfio.model.TicketReservation;
import alfio.model.support.JSONData;
import alfio.model.transaction.PaymentProxy;
import alfio.util.Json;
import alfio.util.LocaleUtil;
import alfio.util.MonetaryUtil;
import ch.digitalfondue.npjt.ConstructorAnnotationRowMapper;
import com.fasterxml.jackson.core.type.TypeReference;
import java.math.BigDecimal;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;

public class ReservationWithPurchaseContext
implements PriceContainer {
    private final String id;
    private final ZonedDateTime validity;
    private final TicketReservation.TicketReservationStatus status;
    private final ZonedDateTime purchaseContextStartDate;
    private final ZonedDateTime purchaseContextEndDate;
    private final ZonedDateTime confirmationTs;
    private final ZonedDateTime registrationTs;
    private final PaymentProxy paymentMethod;
    private final String invoiceNumber;
    private final PriceContainer.VatStatus vatStatus;
    private final BigDecimal vatPercentage;
    private final int srcPriceCts;
    private final int finalPriceCts;
    private final int vatCts;
    private final int discountCts;
    private final String currencyCode;
    private final PurchaseContext.PurchaseContextType purchaseContextType;
    private final String purchaseContextPublicIdentifier;
    private final Map<String, String> purchaseContextTitle;
    private final List<PurchaseContextItem> items;

    public ReservationWithPurchaseContext(@ConstructorAnnotationRowMapper.Column(value="tr_id") String id, @ConstructorAnnotationRowMapper.Column(value="tr_validity") ZonedDateTime validity, @ConstructorAnnotationRowMapper.Column(value="tr_status") TicketReservation.TicketReservationStatus status, @ConstructorAnnotationRowMapper.Column(value="tr_confirmation_ts") ZonedDateTime confirmationTs, @ConstructorAnnotationRowMapper.Column(value="tr_registration_ts") ZonedDateTime registrationTs, @ConstructorAnnotationRowMapper.Column(value="tr_payment_method") PaymentProxy paymentMethod, @ConstructorAnnotationRowMapper.Column(value="tr_invoice_number") String invoiceNumber, @ConstructorAnnotationRowMapper.Column(value="tr_vat_status") PriceContainer.VatStatus vatStatus, @ConstructorAnnotationRowMapper.Column(value="tr_used_vat_percent") BigDecimal vatPercentage, @ConstructorAnnotationRowMapper.Column(value="tr_src_price_cts") int srcPriceCts, @ConstructorAnnotationRowMapper.Column(value="tr_final_price_cts") int finalPriceCts, @ConstructorAnnotationRowMapper.Column(value="tr_vat_cts") int vatCts, @ConstructorAnnotationRowMapper.Column(value="tr_discount_cts") int discountCts, @ConstructorAnnotationRowMapper.Column(value="tr_currency_code") String currencyCode, @ConstructorAnnotationRowMapper.Column(value="pc_type") PurchaseContext.PurchaseContextType purchaseContextType, @ConstructorAnnotationRowMapper.Column(value="pc_public_identifier") String purchaseContextPublicIdentifier, @ConstructorAnnotationRowMapper.Column(value="pc_title") @JSONData Map<String, String> purchaseContextTitle, @ConstructorAnnotationRowMapper.Column(value="pc_time_zone") String purchaseContextTimezone, @ConstructorAnnotationRowMapper.Column(value="pc_start_date") ZonedDateTime purchaseContextStartDate, @ConstructorAnnotationRowMapper.Column(value="pc_end_date") ZonedDateTime purchaseContextEndDate, @ConstructorAnnotationRowMapper.Column(value="pc_items") String itemsJson) {
        ZoneId zoneId = ZoneId.of(purchaseContextTimezone);
        this.id = id;
        this.validity = LocaleUtil.atZone((ZonedDateTime)validity, (ZoneId)zoneId);
        this.status = status;
        this.confirmationTs = LocaleUtil.atZone((ZonedDateTime)confirmationTs, (ZoneId)zoneId);
        this.registrationTs = LocaleUtil.atZone((ZonedDateTime)registrationTs, (ZoneId)zoneId);
        this.paymentMethod = paymentMethod;
        this.invoiceNumber = invoiceNumber;
        this.vatStatus = vatStatus;
        this.vatPercentage = vatPercentage;
        this.srcPriceCts = srcPriceCts;
        this.finalPriceCts = finalPriceCts;
        this.vatCts = vatCts;
        this.discountCts = discountCts;
        this.currencyCode = currencyCode;
        this.purchaseContextType = purchaseContextType;
        this.purchaseContextPublicIdentifier = purchaseContextPublicIdentifier;
        this.purchaseContextTitle = purchaseContextTitle;
        this.purchaseContextStartDate = LocaleUtil.atZone((ZonedDateTime)purchaseContextStartDate, (ZoneId)zoneId);
        this.purchaseContextEndDate = LocaleUtil.atZone((ZonedDateTime)purchaseContextEndDate, (ZoneId)zoneId);
        this.items = (List)Json.fromJson((String)itemsJson, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
    }

    public Optional<BigDecimal> getOptionalVatPercentage() {
        return Optional.ofNullable(this.vatPercentage);
    }

    public BigDecimal getFinalPrice() {
        return MonetaryUtil.centsToUnit((int)this.finalPriceCts, (String)this.currencyCode);
    }

    public BigDecimal getVAT() {
        return MonetaryUtil.centsToUnit((int)this.vatCts, (String)this.currencyCode);
    }

    public BigDecimal getAppliedDiscount() {
        return MonetaryUtil.centsToUnit((int)this.discountCts, (String)this.currencyCode);
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public ZonedDateTime getValidity() {
        return this.validity;
    }

    @Generated
    public TicketReservation.TicketReservationStatus getStatus() {
        return this.status;
    }

    @Generated
    public ZonedDateTime getPurchaseContextStartDate() {
        return this.purchaseContextStartDate;
    }

    @Generated
    public ZonedDateTime getPurchaseContextEndDate() {
        return this.purchaseContextEndDate;
    }

    @Generated
    public ZonedDateTime getConfirmationTs() {
        return this.confirmationTs;
    }

    @Generated
    public ZonedDateTime getRegistrationTs() {
        return this.registrationTs;
    }

    @Generated
    public PaymentProxy getPaymentMethod() {
        return this.paymentMethod;
    }

    @Generated
    public String getInvoiceNumber() {
        return this.invoiceNumber;
    }

    @Generated
    public PriceContainer.VatStatus getVatStatus() {
        return this.vatStatus;
    }

    @Generated
    public BigDecimal getVatPercentage() {
        return this.vatPercentage;
    }

    @Generated
    public int getSrcPriceCts() {
        return this.srcPriceCts;
    }

    @Generated
    public int getFinalPriceCts() {
        return this.finalPriceCts;
    }

    @Generated
    public int getVatCts() {
        return this.vatCts;
    }

    @Generated
    public int getDiscountCts() {
        return this.discountCts;
    }

    @Generated
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    @Generated
    public PurchaseContext.PurchaseContextType getPurchaseContextType() {
        return this.purchaseContextType;
    }

    @Generated
    public String getPurchaseContextPublicIdentifier() {
        return this.purchaseContextPublicIdentifier;
    }

    @Generated
    public Map<String, String> getPurchaseContextTitle() {
        return this.purchaseContextTitle;
    }

    @Generated
    public List<PurchaseContextItem> getItems() {
        return this.items;
    }
}

