/*
 * Decompiled with CFR 0.152.
 */
package alfio.model;

import alfio.model.PriceContainer;
import alfio.model.SummaryRow;
import java.beans.ConstructorProperties;
import lombok.Generated;

public class SummaryRow {
    private final String name;
    private final String price;
    private final String priceBeforeVat;
    private final int amount;
    private final String subTotal;
    private final String subTotalBeforeVat;
    private final int originalSubTotal;
    private final SummaryType type;
    private final String taxPercentage;
    private final PriceContainer.VatStatus vatStatus;

    public String getDescriptionForPayment() {
        if (this.name != null) {
            return this.amount + " x " + this.name;
        }
        return "";
    }

    public boolean isDiscount() {
        return this.type == SummaryType.PROMOTION_CODE || this.type == SummaryType.DYNAMIC_DISCOUNT;
    }

    public boolean getTaxDetail() {
        return this.type == SummaryType.TAX_DETAIL;
    }

    @ConstructorProperties(value={"name", "price", "priceBeforeVat", "amount", "subTotal", "subTotalBeforeVat", "originalSubTotal", "type", "taxPercentage", "vatStatus"})
    @Generated
    public SummaryRow(String name, String price, String priceBeforeVat, int amount, String subTotal, String subTotalBeforeVat, int originalSubTotal, SummaryType type, String taxPercentage, PriceContainer.VatStatus vatStatus) {
        this.name = name;
        this.price = price;
        this.priceBeforeVat = priceBeforeVat;
        this.amount = amount;
        this.subTotal = subTotal;
        this.subTotalBeforeVat = subTotalBeforeVat;
        this.originalSubTotal = originalSubTotal;
        this.type = type;
        this.taxPercentage = taxPercentage;
        this.vatStatus = vatStatus;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getPrice() {
        return this.price;
    }

    @Generated
    public String getPriceBeforeVat() {
        return this.priceBeforeVat;
    }

    @Generated
    public int getAmount() {
        return this.amount;
    }

    @Generated
    public String getSubTotal() {
        return this.subTotal;
    }

    @Generated
    public String getSubTotalBeforeVat() {
        return this.subTotalBeforeVat;
    }

    @Generated
    public int getOriginalSubTotal() {
        return this.originalSubTotal;
    }

    @Generated
    public SummaryType getType() {
        return this.type;
    }

    @Generated
    public String getTaxPercentage() {
        return this.taxPercentage;
    }

    @Generated
    public PriceContainer.VatStatus getVatStatus() {
        return this.vatStatus;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SummaryRow)) {
            return false;
        }
        SummaryRow other = (SummaryRow)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getAmount() != other.getAmount()) {
            return false;
        }
        if (this.getOriginalSubTotal() != other.getOriginalSubTotal()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$price = this.getPrice();
        String other$price = other.getPrice();
        if (this$price == null ? other$price != null : !this$price.equals(other$price)) {
            return false;
        }
        String this$priceBeforeVat = this.getPriceBeforeVat();
        String other$priceBeforeVat = other.getPriceBeforeVat();
        if (this$priceBeforeVat == null ? other$priceBeforeVat != null : !this$priceBeforeVat.equals(other$priceBeforeVat)) {
            return false;
        }
        String this$subTotal = this.getSubTotal();
        String other$subTotal = other.getSubTotal();
        if (this$subTotal == null ? other$subTotal != null : !this$subTotal.equals(other$subTotal)) {
            return false;
        }
        String this$subTotalBeforeVat = this.getSubTotalBeforeVat();
        String other$subTotalBeforeVat = other.getSubTotalBeforeVat();
        if (this$subTotalBeforeVat == null ? other$subTotalBeforeVat != null : !this$subTotalBeforeVat.equals(other$subTotalBeforeVat)) {
            return false;
        }
        SummaryType this$type = this.getType();
        SummaryType other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$taxPercentage = this.getTaxPercentage();
        String other$taxPercentage = other.getTaxPercentage();
        if (this$taxPercentage == null ? other$taxPercentage != null : !this$taxPercentage.equals(other$taxPercentage)) {
            return false;
        }
        PriceContainer.VatStatus this$vatStatus = this.getVatStatus();
        PriceContainer.VatStatus other$vatStatus = other.getVatStatus();
        return !(this$vatStatus == null ? other$vatStatus != null : !this$vatStatus.equals(other$vatStatus));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SummaryRow;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getAmount();
        result = result * 59 + this.getOriginalSubTotal();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $price = this.getPrice();
        result = result * 59 + ($price == null ? 43 : $price.hashCode());
        String $priceBeforeVat = this.getPriceBeforeVat();
        result = result * 59 + ($priceBeforeVat == null ? 43 : $priceBeforeVat.hashCode());
        String $subTotal = this.getSubTotal();
        result = result * 59 + ($subTotal == null ? 43 : $subTotal.hashCode());
        String $subTotalBeforeVat = this.getSubTotalBeforeVat();
        result = result * 59 + ($subTotalBeforeVat == null ? 43 : $subTotalBeforeVat.hashCode());
        SummaryType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $taxPercentage = this.getTaxPercentage();
        result = result * 59 + ($taxPercentage == null ? 43 : $taxPercentage.hashCode());
        PriceContainer.VatStatus $vatStatus = this.getVatStatus();
        result = result * 59 + ($vatStatus == null ? 43 : $vatStatus.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SummaryRow(name=" + this.getName() + ", price=" + this.getPrice() + ", priceBeforeVat=" + this.getPriceBeforeVat() + ", amount=" + this.getAmount() + ", subTotal=" + this.getSubTotal() + ", subTotalBeforeVat=" + this.getSubTotalBeforeVat() + ", originalSubTotal=" + this.getOriginalSubTotal() + ", type=" + this.getType() + ", taxPercentage=" + this.getTaxPercentage() + ", vatStatus=" + this.getVatStatus() + ")";
    }
}

