/*
 * Decompiled with CFR 0.152.
 */
package alfio.model;

import alfio.model.PriceContainer;
import alfio.model.Ticket;
import alfio.model.TicketInfoContainer;
import alfio.model.support.Array;
import alfio.util.MonetaryUtil;
import alfio.util.checkin.NameNormalizer;
import ch.digitalfondue.npjt.ConstructorAnnotationRowMapper;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.ZonedDateTime;
import java.util.Base64;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.codec.digest.HmacAlgorithms;
import org.apache.commons.codec.digest.HmacUtils;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class Ticket
implements TicketInfoContainer {
    private static final Set<TicketStatus> SOLD_STATUSES = EnumSet.of(TicketStatus.TO_BE_PAID, TicketStatus.ACQUIRED, TicketStatus.CANCELLED, TicketStatus.CHECKED_IN, TicketStatus.RELEASED);
    private final int id;
    private final String uuid;
    private final UUID publicUuid;
    private final ZonedDateTime creation;
    private final Integer categoryId;
    private final int eventId;
    private final TicketStatus status;
    private final String ticketsReservationId;
    private final String fullName;
    private final String firstName;
    private final String lastName;
    private final String email;
    private final boolean lockedAssignment;
    private final String userLanguage;
    private final int srcPriceCts;
    private final int finalPriceCts;
    private final int vatCts;
    private final int discountCts;
    private final String extReference;
    private final String currencyCode;
    private final List<String> tags;
    private final UUID subscriptionId;
    private final PriceContainer.VatStatus vatStatus;

    public Ticket(@JsonProperty(value="id") @ConstructorAnnotationRowMapper.Column(value="id") int id, @JsonProperty(value="uuid") @ConstructorAnnotationRowMapper.Column(value="uuid") String uuid, @JsonProperty(value="publicUuid") @ConstructorAnnotationRowMapper.Column(value="public_uuid") UUID publicUuid, @JsonProperty(value="creation") @ConstructorAnnotationRowMapper.Column(value="creation") ZonedDateTime creation, @JsonProperty(value="categoryId") @ConstructorAnnotationRowMapper.Column(value="category_id") Integer categoryId, @JsonProperty(value="status") @ConstructorAnnotationRowMapper.Column(value="status") String status, @JsonProperty(value="eventId") @ConstructorAnnotationRowMapper.Column(value="event_id") int eventId, @JsonProperty(value="ticketsReservationId") @ConstructorAnnotationRowMapper.Column(value="tickets_reservation_id") String ticketsReservationId, @JsonProperty(value="fullName") @ConstructorAnnotationRowMapper.Column(value="full_name") String fullName, @JsonProperty(value="firstName") @ConstructorAnnotationRowMapper.Column(value="first_name") String firstName, @JsonProperty(value="lastName") @ConstructorAnnotationRowMapper.Column(value="last_name") String lastName, @JsonProperty(value="email") @ConstructorAnnotationRowMapper.Column(value="email_address") String email, @JsonProperty(value="lockedAssignment") @ConstructorAnnotationRowMapper.Column(value="locked_assignment") boolean lockedAssignment, @JsonProperty(value="userLanguage") @ConstructorAnnotationRowMapper.Column(value="user_language") String userLanguage, @JsonProperty(value="srcPriceCts") @ConstructorAnnotationRowMapper.Column(value="src_price_cts") int srcPriceCts, @JsonProperty(value="finalPriceCts") @ConstructorAnnotationRowMapper.Column(value="final_price_cts") int finalPriceCts, @JsonProperty(value="vatCts") @ConstructorAnnotationRowMapper.Column(value="vat_cts") int vatCts, @JsonProperty(value="discountCts") @ConstructorAnnotationRowMapper.Column(value="discount_cts") int discountCts, @JsonProperty(value="extReference") @ConstructorAnnotationRowMapper.Column(value="ext_reference") String extReference, @JsonProperty(value="currencyCode") @ConstructorAnnotationRowMapper.Column(value="currency_code") String currencyCode, @JsonProperty(value="tags") @ConstructorAnnotationRowMapper.Column(value="tags") @Array List<String> tags, @JsonProperty(value="subscriptionId") @ConstructorAnnotationRowMapper.Column(value="subscription_id_fk") UUID subscriptionId, @JsonProperty(value="vatStatus") @ConstructorAnnotationRowMapper.Column(value="vat_status") PriceContainer.VatStatus vatStatus) {
        this.id = id;
        this.uuid = uuid;
        this.publicUuid = publicUuid;
        this.creation = creation;
        this.categoryId = categoryId;
        this.eventId = eventId;
        this.userLanguage = userLanguage;
        this.status = TicketStatus.valueOf((String)status);
        this.ticketsReservationId = ticketsReservationId;
        this.fullName = Optional.ofNullable(fullName).orElse("");
        this.firstName = firstName;
        this.lastName = lastName;
        this.email = Optional.ofNullable(email).orElse("");
        this.lockedAssignment = lockedAssignment;
        this.srcPriceCts = srcPriceCts;
        this.finalPriceCts = finalPriceCts;
        this.vatCts = vatCts;
        this.discountCts = discountCts;
        this.extReference = extReference;
        this.currencyCode = currencyCode;
        this.tags = tags;
        this.subscriptionId = subscriptionId;
        this.vatStatus = vatStatus;
    }

    public boolean getAssigned() {
        return (StringUtils.isNotBlank((CharSequence)this.fullName) || StringUtils.isNotBlank((CharSequence)this.firstName) && StringUtils.isNotBlank((CharSequence)this.lastName)) && StringUtils.isNotBlank((CharSequence)this.email);
    }

    public boolean getLockedAssignment() {
        return this.lockedAssignment;
    }

    public String ticketCode(String eventKey, boolean caseInsensitive) {
        return this.uuid + "/" + this.hmacTicketInfo(eventKey, caseInsensitive);
    }

    public String hmacTicketInfo(String eventKey, boolean caseInsensitive) {
        return Ticket.generateHmacTicketInfo((String)eventKey, (boolean)caseInsensitive, (String)this.getFullName(), (String)this.email, (String)this.ticketsReservationId, (String)this.uuid);
    }

    public boolean hasBeenSold() {
        return SOLD_STATUSES.contains(this.status);
    }

    public boolean isCheckedIn() {
        return this.status == TicketStatus.CHECKED_IN;
    }

    static String generateHmacTicketInfo(String eventKey, boolean caseInsensitive, String fullName, String email, String ticketsReservationId, String uuid) {
        String attendeeName = fullName;
        String attendeeEmail = email;
        if (caseInsensitive) {
            attendeeName = NameNormalizer.normalize((String)attendeeName);
            attendeeEmail = email.toLowerCase(Locale.ROOT);
        }
        return Ticket.hmacSHA256Base64((String)eventKey, (String)StringUtils.join((Object[])new String[]{ticketsReservationId, uuid, attendeeName, attendeeEmail}, (char)'/'));
    }

    public static String hmacSHA256Base64(String key, String code) {
        return Base64.getEncoder().encodeToString(new HmacUtils(HmacAlgorithms.HMAC_SHA_256, key).hmac(code));
    }

    public String getFullName() {
        return this.firstName != null && this.lastName != null ? this.firstName + " " + this.lastName : this.fullName;
    }

    public String getFormattedFinalPrice() {
        return MonetaryUtil.formatCents((int)this.finalPriceCts, (String)this.currencyCode);
    }

    public String getFormattedNetPrice() {
        return MonetaryUtil.formatCents((int)(this.finalPriceCts - this.vatCts), (String)this.currencyCode);
    }

    public Ticket withVatStatus(PriceContainer.VatStatus newVatStatus) {
        return new Ticket(this.id, this.uuid, this.publicUuid, this.creation, this.categoryId, this.status.name(), this.eventId, this.ticketsReservationId, this.fullName, this.firstName, this.lastName, this.email, this.lockedAssignment, this.userLanguage, this.srcPriceCts, this.finalPriceCts, this.vatCts, this.discountCts, this.extReference, this.currencyCode, this.tags, this.subscriptionId, newVatStatus);
    }

    @Generated
    public int getId() {
        return this.id;
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Generated
    public UUID getPublicUuid() {
        return this.publicUuid;
    }

    @Generated
    public ZonedDateTime getCreation() {
        return this.creation;
    }

    @Generated
    public Integer getCategoryId() {
        return this.categoryId;
    }

    @Generated
    public int getEventId() {
        return this.eventId;
    }

    @Generated
    public TicketStatus getStatus() {
        return this.status;
    }

    @Generated
    public String getTicketsReservationId() {
        return this.ticketsReservationId;
    }

    @Generated
    public String getFirstName() {
        return this.firstName;
    }

    @Generated
    public String getLastName() {
        return this.lastName;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public String getUserLanguage() {
        return this.userLanguage;
    }

    @Generated
    public int getSrcPriceCts() {
        return this.srcPriceCts;
    }

    @Generated
    public int getFinalPriceCts() {
        return this.finalPriceCts;
    }

    @Generated
    public int getVatCts() {
        return this.vatCts;
    }

    @Generated
    public int getDiscountCts() {
        return this.discountCts;
    }

    @Generated
    public String getExtReference() {
        return this.extReference;
    }

    @Generated
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    @Generated
    public List<String> getTags() {
        return this.tags;
    }

    @Generated
    public UUID getSubscriptionId() {
        return this.subscriptionId;
    }

    @Generated
    public PriceContainer.VatStatus getVatStatus() {
        return this.vatStatus;
    }
}

