/*
 * Decompiled with CFR 0.152.
 */
package alfio.model;

import alfio.model.TicketCategory;
import alfio.util.MonetaryUtil;
import ch.digitalfondue.npjt.ConstructorAnnotationRowMapper;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Comparator;
import lombok.Generated;
import org.apache.commons.lang3.builder.CompareToBuilder;

public class TicketCategory {
    public static final Comparator<TicketCategory> COMPARATOR = (tc1, tc2) -> new CompareToBuilder().append((Object)tc1.utcInception, (Object)tc2.utcInception).append((Object)tc1.utcExpiration, (Object)tc2.utcExpiration).toComparison();
    private final int id;
    private final ZonedDateTime utcInception;
    private final ZonedDateTime utcExpiration;
    private final int maxTickets;
    private final String name;
    private final boolean accessRestricted;
    private final Status status;
    private final int eventId;
    private final boolean bounded;
    private final int srcPriceCts;
    private final String code;
    private final ZonedDateTime validCheckInFrom;
    private final ZonedDateTime validCheckInTo;
    private final ZonedDateTime ticketValidityStart;
    private final ZonedDateTime ticketValidityEnd;
    private final String currencyCode;
    private final int ordinal;
    private final TicketCheckInStrategy ticketCheckInStrategy;
    private final TicketAccessType ticketAccessType;

    public TicketCategory(@JsonProperty(value="id") @ConstructorAnnotationRowMapper.Column(value="id") int id, @JsonProperty(value="utcInception") @ConstructorAnnotationRowMapper.Column(value="inception") ZonedDateTime utcInception, @JsonProperty(value="utcExpiration") @ConstructorAnnotationRowMapper.Column(value="expiration") ZonedDateTime utcExpiration, @JsonProperty(value="maxTickets") @ConstructorAnnotationRowMapper.Column(value="max_tickets") int maxTickets, @JsonProperty(value="name") @ConstructorAnnotationRowMapper.Column(value="name") String name, @JsonProperty(value="accessRestricted") @ConstructorAnnotationRowMapper.Column(value="access_restricted") boolean accessRestricted, @JsonProperty(value="status") @ConstructorAnnotationRowMapper.Column(value="tc_status") Status status, @JsonProperty(value="eventId") @ConstructorAnnotationRowMapper.Column(value="event_id") int eventId, @JsonProperty(value="bounded") @ConstructorAnnotationRowMapper.Column(value="bounded") boolean bounded, @JsonProperty(value="srcPriceCts") @ConstructorAnnotationRowMapper.Column(value="src_price_cts") int srcPriceCts, @JsonProperty(value="code") @ConstructorAnnotationRowMapper.Column(value="category_code") String code, @JsonProperty(value="validCheckInFrom") @ConstructorAnnotationRowMapper.Column(value="valid_checkin_from") ZonedDateTime validCheckInFrom, @JsonProperty(value="validCheckInTo") @ConstructorAnnotationRowMapper.Column(value="valid_checkin_to") ZonedDateTime validCheckInTo, @JsonProperty(value="ticketValidityStart") @ConstructorAnnotationRowMapper.Column(value="ticket_validity_start") ZonedDateTime ticketValidityStart, @JsonProperty(value="ticketValidityEnd") @ConstructorAnnotationRowMapper.Column(value="ticket_validity_end") ZonedDateTime ticketValidityEnd, @JsonProperty(value="currencyCode") @ConstructorAnnotationRowMapper.Column(value="currency_code") String currencyCode, @JsonProperty(value="ordinal") @ConstructorAnnotationRowMapper.Column(value="ordinal") Integer ordinal, @JsonProperty(value="ticketCheckInStrategy") @ConstructorAnnotationRowMapper.Column(value="ticket_checkin_strategy") TicketCheckInStrategy ticketCheckInStrategy, @JsonProperty(value="ticketAccessType") @ConstructorAnnotationRowMapper.Column(value="ticket_access_type") TicketAccessType ticketAccessType) {
        this.id = id;
        this.utcInception = utcInception;
        this.utcExpiration = utcExpiration;
        this.maxTickets = maxTickets;
        this.name = name;
        this.accessRestricted = accessRestricted;
        this.status = status;
        this.eventId = eventId;
        this.bounded = bounded;
        this.srcPriceCts = srcPriceCts;
        this.code = code;
        this.validCheckInFrom = validCheckInFrom;
        this.validCheckInTo = validCheckInTo;
        this.ticketValidityStart = ticketValidityStart;
        this.ticketValidityEnd = ticketValidityEnd;
        this.currencyCode = currencyCode;
        this.ordinal = ordinal != null ? ordinal : 0;
        this.ticketCheckInStrategy = ticketCheckInStrategy;
        this.ticketAccessType = ticketAccessType;
    }

    public BigDecimal getPrice() {
        return MonetaryUtil.centsToUnit((int)this.srcPriceCts, (String)this.currencyCode);
    }

    public boolean getFree() {
        return this.srcPriceCts == 0;
    }

    public ZonedDateTime getInception(ZoneId zoneId) {
        return this.utcInception.withZoneSameInstant(zoneId);
    }

    public ZonedDateTime getExpiration(ZoneId zoneId) {
        return this.utcExpiration.withZoneSameInstant(zoneId);
    }

    public ZonedDateTime getValidCheckInFrom(ZoneId zoneId) {
        return this.validCheckInFrom == null ? null : this.validCheckInFrom.withZoneSameInstant(zoneId);
    }

    public ZonedDateTime getValidCheckInTo(ZoneId zoneId) {
        return this.validCheckInTo == null ? null : this.validCheckInTo.withZoneSameInstant(zoneId);
    }

    public ZonedDateTime getTicketValidityStart(ZoneId zoneId) {
        return this.ticketValidityStart == null ? null : this.ticketValidityStart.withZoneSameInstant(zoneId);
    }

    public ZonedDateTime getTicketValidityEnd(ZoneId zoneId) {
        return this.ticketValidityEnd == null ? null : this.ticketValidityEnd.withZoneSameInstant(zoneId);
    }

    public boolean hasValidCheckIn(ZonedDateTime now, ZoneId eventZoneId) {
        return !(this.validCheckInFrom != null && this.getValidCheckInFrom(eventZoneId).isAfter(now) || this.validCheckInTo != null && this.getValidCheckInTo(eventZoneId).isBefore(now));
    }

    @Generated
    public int getId() {
        return this.id;
    }

    @Generated
    public ZonedDateTime getUtcInception() {
        return this.utcInception;
    }

    @Generated
    public ZonedDateTime getUtcExpiration() {
        return this.utcExpiration;
    }

    @Generated
    public int getMaxTickets() {
        return this.maxTickets;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public boolean isAccessRestricted() {
        return this.accessRestricted;
    }

    @Generated
    public Status getStatus() {
        return this.status;
    }

    @Generated
    public int getEventId() {
        return this.eventId;
    }

    @Generated
    public boolean isBounded() {
        return this.bounded;
    }

    @Generated
    public int getSrcPriceCts() {
        return this.srcPriceCts;
    }

    @Generated
    public String getCode() {
        return this.code;
    }

    @Generated
    public ZonedDateTime getValidCheckInFrom() {
        return this.validCheckInFrom;
    }

    @Generated
    public ZonedDateTime getValidCheckInTo() {
        return this.validCheckInTo;
    }

    @Generated
    public ZonedDateTime getTicketValidityStart() {
        return this.ticketValidityStart;
    }

    @Generated
    public ZonedDateTime getTicketValidityEnd() {
        return this.ticketValidityEnd;
    }

    @Generated
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    @Generated
    public int getOrdinal() {
        return this.ordinal;
    }

    @Generated
    public TicketCheckInStrategy getTicketCheckInStrategy() {
        return this.ticketCheckInStrategy;
    }

    @Generated
    public TicketAccessType getTicketAccessType() {
        return this.ticketAccessType;
    }
}

