/*
 * Decompiled with CFR 0.152.
 */
package alfio.model;

import alfio.model.Event;
import alfio.model.EventStatistic;
import alfio.model.PriceContainer;
import alfio.model.SpecialPrice;
import alfio.model.TicketCategory;
import alfio.model.TicketCategoryStatisticView;
import alfio.model.metadata.AlfioMetadata;
import alfio.model.modification.StatisticsContainer;
import alfio.model.modification.TicketWithStatistic;
import alfio.model.system.Configuration;
import alfio.util.ClockProvider;
import alfio.util.MonetaryUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
public class TicketCategoryWithAdditionalInfo
implements StatisticsContainer,
PriceContainer {
    @JsonIgnore
    private final Event event;
    @JsonIgnore
    private final TicketCategory ticketCategory;
    @JsonIgnore
    private final TicketCategoryStatisticView ticketCategoryStatisticView;
    private final Map<String, String> description;
    private final List<SpecialPrice> tokenStatus;
    private final AlfioMetadata metadata;
    @Deprecated
    private final List<TicketWithStatistic> tickets = Collections.emptyList();

    @JsonIgnore
    public Event getEvent() {
        return this.event;
    }

    @JsonIgnore
    public TicketCategory getTicketCategory() {
        return this.ticketCategory;
    }

    @JsonIgnore
    public TicketCategoryStatisticView getTicketCategoryStatisticView() {
        return this.ticketCategoryStatisticView;
    }

    public String getFormattedInception() {
        return this.getInception(this.event.getZoneId()).format(EventStatistic.JSON_DATE_FORMATTER);
    }

    public String getFormattedExpiration() {
        return this.getExpiration(this.event.getZoneId()).format(EventStatistic.JSON_DATE_FORMATTER);
    }

    public String getFormattedValidCheckInFrom() {
        return this.getValidCheckInFrom() != null ? this.getValidCheckInFrom(this.event.getZoneId()).format(EventStatistic.JSON_DATE_FORMATTER) : null;
    }

    public String getFormattedValidCheckInTo() {
        return this.getValidCheckInTo() != null ? this.getValidCheckInTo(this.event.getZoneId()).format(EventStatistic.JSON_DATE_FORMATTER) : null;
    }

    public String getFormattedTicketValidityStart() {
        return this.getTicketValidityStart() != null ? this.getTicketValidityStart(this.event.getZoneId()).format(EventStatistic.JSON_DATE_FORMATTER) : null;
    }

    public String getFormattedTicketValidityEnd() {
        return this.getTicketValidityEnd() != null ? this.getTicketValidityEnd(this.event.getZoneId()).format(EventStatistic.JSON_DATE_FORMATTER) : null;
    }

    private static BigDecimal calcSoldTicketsPercent(TicketCategory ticketCategory, int soldTickets) {
        int maxTickets = Math.max(1, ticketCategory.getMaxTickets());
        return BigDecimal.valueOf(soldTickets).divide(BigDecimal.valueOf(maxTickets), 2, RoundingMode.HALF_UP).multiply(MonetaryUtil.HUNDRED);
    }

    public BigDecimal getSoldTicketsPercent() {
        return TicketCategoryWithAdditionalInfo.calcSoldTicketsPercent((TicketCategory)this.ticketCategory, (int)this.getSoldTickets());
    }

    public BigDecimal getNotSoldTicketsPercent() {
        return MonetaryUtil.HUNDRED.subtract(this.getSoldTicketsPercent());
    }

    public int getNotAllocatedTickets() {
        return 0;
    }

    public int getDynamicAllocation() {
        return 0;
    }

    public int getNotSoldTickets() {
        return this.ticketCategoryStatisticView.getNotSoldTicketsCount();
    }

    public int getSoldTickets() {
        return this.ticketCategoryStatisticView.getSoldTicketsCount();
    }

    public int getCheckedInTickets() {
        return this.ticketCategoryStatisticView.getCheckedInCount();
    }

    public int getPendingTickets() {
        return this.ticketCategoryStatisticView.getPendingCount();
    }

    public int getReleasedTickets() {
        return this.ticketCategoryStatisticView.getReleasedTicketsCount();
    }

    public boolean isExpired() {
        return this.event.now(ClockProvider.clock()).isAfter(this.ticketCategory.getExpiration(this.event.getZoneId()));
    }

    public boolean isContainingOrphans() {
        return this.ticketCategoryStatisticView.isContainsOrphanTickets();
    }

    public boolean isContainingStuckTickets() {
        return this.ticketCategoryStatisticView.isContainsStuckTickets();
    }

    public BigDecimal getActualPrice() {
        return this.getFinalPrice();
    }

    public Optional<BigDecimal> getOptionalVatPercentage() {
        return Optional.ofNullable(this.event.getVat());
    }

    public PriceContainer.VatStatus getVatStatus() {
        return this.event.getVatStatus();
    }

    public List<Configuration> getConfiguration() {
        return this.ticketCategoryStatisticView.getConfiguration();
    }

    @ConstructorProperties(value={"event", "ticketCategory", "ticketCategoryStatisticView", "description", "tokenStatus", "metadata"})
    @Generated
    public TicketCategoryWithAdditionalInfo(Event event, TicketCategory ticketCategory, TicketCategoryStatisticView ticketCategoryStatisticView, Map<String, String> description, List<SpecialPrice> tokenStatus, AlfioMetadata metadata) {
        this.event = event;
        this.ticketCategory = ticketCategory;
        this.ticketCategoryStatisticView = ticketCategoryStatisticView;
        this.description = description;
        this.tokenStatus = tokenStatus;
        this.metadata = metadata;
    }

    @Generated
    public Map<String, String> getDescription() {
        return this.description;
    }

    @Generated
    public List<SpecialPrice> getTokenStatus() {
        return this.tokenStatus;
    }

    @Generated
    public AlfioMetadata getMetadata() {
        return this.metadata;
    }

    @Deprecated
    @Generated
    public List<TicketWithStatistic> getTickets() {
        return this.tickets;
    }

    @Generated
    public BigDecimal getPrice() {
        return this.ticketCategory.getPrice();
    }

    @Generated
    public boolean getFree() {
        return this.ticketCategory.getFree();
    }

    @Generated
    public ZonedDateTime getInception(ZoneId zoneId) {
        return this.ticketCategory.getInception(zoneId);
    }

    @Generated
    public ZonedDateTime getExpiration(ZoneId zoneId) {
        return this.ticketCategory.getExpiration(zoneId);
    }

    @Generated
    public ZonedDateTime getValidCheckInFrom(ZoneId zoneId) {
        return this.ticketCategory.getValidCheckInFrom(zoneId);
    }

    @Generated
    public ZonedDateTime getValidCheckInTo(ZoneId zoneId) {
        return this.ticketCategory.getValidCheckInTo(zoneId);
    }

    @Generated
    public ZonedDateTime getTicketValidityStart(ZoneId zoneId) {
        return this.ticketCategory.getTicketValidityStart(zoneId);
    }

    @Generated
    public ZonedDateTime getTicketValidityEnd(ZoneId zoneId) {
        return this.ticketCategory.getTicketValidityEnd(zoneId);
    }

    @Generated
    public boolean hasValidCheckIn(ZonedDateTime now, ZoneId eventZoneId) {
        return this.ticketCategory.hasValidCheckIn(now, eventZoneId);
    }

    @Generated
    public int getId() {
        return this.ticketCategory.getId();
    }

    @Generated
    public ZonedDateTime getUtcInception() {
        return this.ticketCategory.getUtcInception();
    }

    @Generated
    public ZonedDateTime getUtcExpiration() {
        return this.ticketCategory.getUtcExpiration();
    }

    @Generated
    public int getMaxTickets() {
        return this.ticketCategory.getMaxTickets();
    }

    @Generated
    public String getName() {
        return this.ticketCategory.getName();
    }

    @Generated
    public boolean isAccessRestricted() {
        return this.ticketCategory.isAccessRestricted();
    }

    @Generated
    public TicketCategory.Status getStatus() {
        return this.ticketCategory.getStatus();
    }

    @Generated
    public int getEventId() {
        return this.ticketCategory.getEventId();
    }

    @Generated
    public boolean isBounded() {
        return this.ticketCategory.isBounded();
    }

    @Generated
    public int getSrcPriceCts() {
        return this.ticketCategory.getSrcPriceCts();
    }

    @Generated
    public String getCode() {
        return this.ticketCategory.getCode();
    }

    @Generated
    public ZonedDateTime getValidCheckInFrom() {
        return this.ticketCategory.getValidCheckInFrom();
    }

    @Generated
    public ZonedDateTime getValidCheckInTo() {
        return this.ticketCategory.getValidCheckInTo();
    }

    @Generated
    public ZonedDateTime getTicketValidityStart() {
        return this.ticketCategory.getTicketValidityStart();
    }

    @Generated
    public ZonedDateTime getTicketValidityEnd() {
        return this.ticketCategory.getTicketValidityEnd();
    }

    @Generated
    public String getCurrencyCode() {
        return this.ticketCategory.getCurrencyCode();
    }

    @Generated
    public int getOrdinal() {
        return this.ticketCategory.getOrdinal();
    }

    @Generated
    public TicketCategory.TicketCheckInStrategy getTicketCheckInStrategy() {
        return this.ticketCategory.getTicketCheckInStrategy();
    }

    @Generated
    public TicketCategory.TicketAccessType getTicketAccessType() {
        return this.ticketCategory.getTicketAccessType();
    }
}

