/*
 * Decompiled with CFR 0.152.
 */
package alfio.model;

import alfio.model.PriceContainer;
import alfio.model.TicketReservation;
import alfio.model.transaction.PaymentProxy;
import alfio.util.MonetaryUtil;
import ch.digitalfondue.npjt.ConstructorAnnotationRowMapper;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigDecimal;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class TicketReservation
implements PriceContainer {
    private final String id;
    private final Date validity;
    private final TicketReservationStatus status;
    private final String fullName;
    private final String firstName;
    private final String lastName;
    private final String email;
    private final String billingAddress;
    private final ZonedDateTime confirmationTimestamp;
    private final ZonedDateTime latestReminder;
    private final PaymentProxy paymentMethod;
    private final Boolean reminderSent;
    private final Integer promoCodeDiscountId;
    private final boolean automatic;
    private final String userLanguage;
    private final boolean directAssignmentRequested;
    private final String invoiceNumber;
    @JsonIgnore
    private final String invoiceModel;
    private final PriceContainer.VatStatus vatStatus;
    private final String vatNr;
    private final String vatCountryCode;
    private final boolean invoiceRequested;
    private final BigDecimal usedVatPercent;
    private final Boolean vatIncluded;
    private final ZonedDateTime creationTimestamp;
    private final String customerReference;
    private final ZonedDateTime registrationTimestamp;
    private final int srcPriceCts;
    private final int finalPriceCts;
    private final int vatCts;
    private final int discountCts;
    private final String currencyCode;

    public TicketReservation(@ConstructorAnnotationRowMapper.Column(value="id") String id, @ConstructorAnnotationRowMapper.Column(value="validity") Date validity, @ConstructorAnnotationRowMapper.Column(value="status") TicketReservationStatus status, @ConstructorAnnotationRowMapper.Column(value="full_name") String fullName, @ConstructorAnnotationRowMapper.Column(value="first_name") String firstName, @ConstructorAnnotationRowMapper.Column(value="last_name") String lastName, @ConstructorAnnotationRowMapper.Column(value="email_address") String email, @ConstructorAnnotationRowMapper.Column(value="billing_address") String billingAddress, @ConstructorAnnotationRowMapper.Column(value="confirmation_ts") ZonedDateTime confirmationTimestamp, @ConstructorAnnotationRowMapper.Column(value="latest_reminder_ts") ZonedDateTime latestReminder, @ConstructorAnnotationRowMapper.Column(value="payment_method") PaymentProxy paymentMethod, @ConstructorAnnotationRowMapper.Column(value="offline_payment_reminder_sent") Boolean reminderSent, @ConstructorAnnotationRowMapper.Column(value="promo_code_id_fk") Integer promoCodeDiscountId, @ConstructorAnnotationRowMapper.Column(value="automatic") boolean automatic, @ConstructorAnnotationRowMapper.Column(value="user_language") String userLanguage, @ConstructorAnnotationRowMapper.Column(value="direct_assignment") boolean directAssignmentRequested, @ConstructorAnnotationRowMapper.Column(value="invoice_number") String invoiceNumber, @ConstructorAnnotationRowMapper.Column(value="invoice_model") String invoiceModel, @ConstructorAnnotationRowMapper.Column(value="vat_status") PriceContainer.VatStatus vatStatus, @ConstructorAnnotationRowMapper.Column(value="vat_nr") String vatNr, @ConstructorAnnotationRowMapper.Column(value="vat_country") String vatCountryCode, @ConstructorAnnotationRowMapper.Column(value="invoice_requested") boolean invoiceRequested, @ConstructorAnnotationRowMapper.Column(value="used_vat_percent") BigDecimal usedVatPercent, @ConstructorAnnotationRowMapper.Column(value="vat_included") Boolean vatIncluded, @ConstructorAnnotationRowMapper.Column(value="creation_ts") ZonedDateTime creationTimestamp, @ConstructorAnnotationRowMapper.Column(value="customer_reference") String customerReference, @ConstructorAnnotationRowMapper.Column(value="registration_ts") ZonedDateTime registrationTimestamp, @ConstructorAnnotationRowMapper.Column(value="src_price_cts") Integer srcPriceCts, @ConstructorAnnotationRowMapper.Column(value="final_price_cts") Integer finalPriceCts, @ConstructorAnnotationRowMapper.Column(value="vat_cts") Integer vatCts, @ConstructorAnnotationRowMapper.Column(value="discount_cts") Integer discountCts, @ConstructorAnnotationRowMapper.Column(value="currency_code") String currencyCode) {
        this.id = id;
        this.validity = validity;
        this.status = status;
        this.fullName = fullName;
        this.firstName = firstName;
        this.lastName = lastName;
        this.email = email;
        this.billingAddress = billingAddress;
        this.confirmationTimestamp = confirmationTimestamp;
        this.latestReminder = latestReminder;
        this.paymentMethod = paymentMethod;
        this.reminderSent = reminderSent;
        this.promoCodeDiscountId = promoCodeDiscountId;
        this.automatic = automatic;
        this.userLanguage = userLanguage;
        this.directAssignmentRequested = directAssignmentRequested;
        this.invoiceNumber = invoiceNumber;
        this.invoiceModel = invoiceModel;
        this.vatStatus = vatStatus;
        this.vatNr = vatNr;
        this.vatCountryCode = vatCountryCode;
        this.invoiceRequested = invoiceRequested;
        this.usedVatPercent = usedVatPercent;
        this.vatIncluded = vatIncluded;
        this.creationTimestamp = creationTimestamp;
        this.registrationTimestamp = registrationTimestamp;
        this.customerReference = customerReference;
        this.srcPriceCts = Optional.ofNullable(srcPriceCts).orElse(0);
        this.finalPriceCts = Optional.ofNullable(finalPriceCts).orElse(0);
        this.vatCts = Optional.ofNullable(vatCts).orElse(0);
        this.discountCts = Optional.ofNullable(discountCts).orElse(0);
        this.currencyCode = currencyCode;
    }

    public boolean isStuck() {
        return this.status == TicketReservationStatus.STUCK;
    }

    public boolean isReminderSent() {
        return Optional.ofNullable(this.reminderSent).orElse(false);
    }

    public boolean getHasBillingAddress() {
        return StringUtils.isNotBlank((CharSequence)this.billingAddress);
    }

    public Optional<ZonedDateTime> latestNotificationTimestamp(ZoneId zoneId) {
        return Optional.ofNullable(this.latestReminder).map(d -> d.withZoneSameInstant(zoneId));
    }

    public String getFullName() {
        return this.firstName != null && this.lastName != null ? this.firstName + " " + this.lastName : this.fullName;
    }

    public boolean getHasInvoiceNumber() {
        return this.invoiceNumber != null;
    }

    public boolean getHasInvoiceOrReceiptDocument() {
        return this.invoiceModel != null;
    }

    public boolean getHasBeenPaid() {
        return this.status == TicketReservationStatus.COMPLETE && !EnumSet.of(PaymentProxy.NONE, PaymentProxy.ADMIN).contains(this.paymentMethod);
    }

    public boolean getHasVatNumber() {
        return StringUtils.isNotEmpty((CharSequence)this.vatNr);
    }

    public List<String> getLineSplittedBillingAddress() {
        if (this.billingAddress == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(StringUtils.split((String)this.billingAddress, (char)'\n'));
    }

    public boolean isCancelled() {
        return this.status == TicketReservationStatus.CANCELLED;
    }

    public String getPaidAmount() {
        if (this.finalPriceCts > 0) {
            return MonetaryUtil.formatCents((int)this.finalPriceCts, (String)this.currencyCode);
        }
        return null;
    }

    public Optional<BigDecimal> getOptionalVatPercentage() {
        return Optional.ofNullable(this.usedVatPercent);
    }

    public boolean isPendingOfflinePayment() {
        return this.status == TicketReservationStatus.OFFLINE_PAYMENT || this.status == TicketReservationStatus.DEFERRED_OFFLINE_PAYMENT;
    }

    public TicketReservation withVatStatus(PriceContainer.VatStatus vatStatus) {
        return new TicketReservation(this.id, this.validity, this.status, this.fullName, this.firstName, this.lastName, this.email, this.billingAddress, this.confirmationTimestamp, this.latestReminder, this.paymentMethod, this.reminderSent, this.promoCodeDiscountId, this.automatic, this.userLanguage, this.directAssignmentRequested, this.invoiceNumber, this.invoiceModel, vatStatus, this.vatNr, this.vatCountryCode, this.invoiceRequested, this.usedVatPercent, this.vatIncluded, this.creationTimestamp, this.customerReference, this.registrationTimestamp, Integer.valueOf(this.srcPriceCts), Integer.valueOf(this.finalPriceCts), Integer.valueOf(this.vatCts), Integer.valueOf(this.discountCts), this.currencyCode);
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public Date getValidity() {
        return this.validity;
    }

    @Generated
    public TicketReservationStatus getStatus() {
        return this.status;
    }

    @Generated
    public String getFirstName() {
        return this.firstName;
    }

    @Generated
    public String getLastName() {
        return this.lastName;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public String getBillingAddress() {
        return this.billingAddress;
    }

    @Generated
    public ZonedDateTime getConfirmationTimestamp() {
        return this.confirmationTimestamp;
    }

    @Generated
    public ZonedDateTime getLatestReminder() {
        return this.latestReminder;
    }

    @Generated
    public PaymentProxy getPaymentMethod() {
        return this.paymentMethod;
    }

    @Generated
    public Boolean getReminderSent() {
        return this.reminderSent;
    }

    @Generated
    public Integer getPromoCodeDiscountId() {
        return this.promoCodeDiscountId;
    }

    @Generated
    public boolean isAutomatic() {
        return this.automatic;
    }

    @Generated
    public String getUserLanguage() {
        return this.userLanguage;
    }

    @Generated
    public boolean isDirectAssignmentRequested() {
        return this.directAssignmentRequested;
    }

    @Generated
    public String getInvoiceNumber() {
        return this.invoiceNumber;
    }

    @Generated
    public String getInvoiceModel() {
        return this.invoiceModel;
    }

    @Generated
    public PriceContainer.VatStatus getVatStatus() {
        return this.vatStatus;
    }

    @Generated
    public String getVatNr() {
        return this.vatNr;
    }

    @Generated
    public String getVatCountryCode() {
        return this.vatCountryCode;
    }

    @Generated
    public boolean isInvoiceRequested() {
        return this.invoiceRequested;
    }

    @Generated
    public BigDecimal getUsedVatPercent() {
        return this.usedVatPercent;
    }

    @Generated
    public Boolean getVatIncluded() {
        return this.vatIncluded;
    }

    @Generated
    public ZonedDateTime getCreationTimestamp() {
        return this.creationTimestamp;
    }

    @Generated
    public String getCustomerReference() {
        return this.customerReference;
    }

    @Generated
    public ZonedDateTime getRegistrationTimestamp() {
        return this.registrationTimestamp;
    }

    @Generated
    public int getSrcPriceCts() {
        return this.srcPriceCts;
    }

    @Generated
    public int getFinalPriceCts() {
        return this.finalPriceCts;
    }

    @Generated
    public int getVatCts() {
        return this.vatCts;
    }

    @Generated
    public int getDiscountCts() {
        return this.discountCts;
    }

    @Generated
    public String getCurrencyCode() {
        return this.currencyCode;
    }
}

