/*
 * Decompiled with CFR 0.152.
 */
package alfio.model;

import alfio.model.BillingDetails;
import alfio.model.TicketReservationInvoicingAdditionalInfo;
import alfio.model.support.JSONData;
import ch.digitalfondue.npjt.ConstructorAnnotationRowMapper;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;

public class TicketReservationAdditionalInfo {
    private final String billingAddressCompany;
    private final String billingAddressLine1;
    private final String billingAddressLine2;
    private final String billingAddressZip;
    private final String billingAddressCity;
    private final String billingAddressState;
    private final String billingAddressCountry;
    private final String vatNr;
    private final Boolean validated;
    private final Boolean skipVatNr;
    private final Boolean addCompanyBillingDetails;
    private final TicketReservationInvoicingAdditionalInfo invoicingAdditionalInfo;

    public TicketReservationAdditionalInfo(@ConstructorAnnotationRowMapper.Column(value="billing_address_company") String billingAddressCompany, @ConstructorAnnotationRowMapper.Column(value="billing_address_line1") String billingAddressLine1, @ConstructorAnnotationRowMapper.Column(value="billing_address_line2") String billingAddressLine2, @ConstructorAnnotationRowMapper.Column(value="billing_address_zip") String billingAddressZip, @ConstructorAnnotationRowMapper.Column(value="billing_address_city") String billingAddressCity, @ConstructorAnnotationRowMapper.Column(value="billing_address_state") String billingAddressState, @ConstructorAnnotationRowMapper.Column(value="validated_for_overview") Boolean validated, @ConstructorAnnotationRowMapper.Column(value="skip_vat_nr") Boolean skipVatNr, @ConstructorAnnotationRowMapper.Column(value="add_company_billing_details") Boolean addCompanyBillingDetails, @ConstructorAnnotationRowMapper.Column(value="invoicing_additional_information") @JSONData TicketReservationInvoicingAdditionalInfo invoicingAdditionalInformation, @ConstructorAnnotationRowMapper.Column(value="vat_country") String vatCountry, @ConstructorAnnotationRowMapper.Column(value="vat_nr") String vatNr) {
        this.billingAddressCompany = billingAddressCompany;
        this.billingAddressLine1 = billingAddressLine1;
        this.billingAddressLine2 = billingAddressLine2;
        this.billingAddressZip = billingAddressZip;
        this.billingAddressCity = billingAddressCity;
        this.billingAddressState = billingAddressState;
        this.addCompanyBillingDetails = addCompanyBillingDetails;
        this.validated = validated;
        this.skipVatNr = skipVatNr;
        this.invoicingAdditionalInfo = Objects.requireNonNullElseGet(invoicingAdditionalInformation, () -> new TicketReservationInvoicingAdditionalInfo(null));
        this.billingAddressCountry = vatCountry;
        this.vatNr = vatNr;
    }

    public boolean hasBeenValidated() {
        return Optional.ofNullable(this.validated).orElse(false);
    }

    public boolean hasSkipVatNr() {
        return Optional.ofNullable(this.skipVatNr).orElse(false);
    }

    public BillingDetails getBillingDetails() {
        return new BillingDetails(this.billingAddressCompany, this.billingAddressLine1, this.billingAddressLine2, this.billingAddressZip, this.billingAddressCity, this.billingAddressState, this.billingAddressCountry, this.vatNr, this.invoicingAdditionalInfo);
    }

    @Generated
    public String getBillingAddressCompany() {
        return this.billingAddressCompany;
    }

    @Generated
    public String getBillingAddressLine1() {
        return this.billingAddressLine1;
    }

    @Generated
    public String getBillingAddressLine2() {
        return this.billingAddressLine2;
    }

    @Generated
    public String getBillingAddressZip() {
        return this.billingAddressZip;
    }

    @Generated
    public String getBillingAddressCity() {
        return this.billingAddressCity;
    }

    @Generated
    public String getBillingAddressState() {
        return this.billingAddressState;
    }

    @Generated
    public String getBillingAddressCountry() {
        return this.billingAddressCountry;
    }

    @Generated
    public String getVatNr() {
        return this.vatNr;
    }

    @Generated
    public Boolean getValidated() {
        return this.validated;
    }

    @Generated
    public Boolean getSkipVatNr() {
        return this.skipVatNr;
    }

    @Generated
    public Boolean getAddCompanyBillingDetails() {
        return this.addCompanyBillingDetails;
    }

    @Generated
    public TicketReservationInvoicingAdditionalInfo getInvoicingAdditionalInfo() {
        return this.invoicingAdditionalInfo;
    }
}

