/*
 * Decompiled with CFR 0.152.
 */
package alfio.model;

import alfio.model.PriceContainer;
import alfio.model.TicketReservation;
import alfio.model.transaction.PaymentProxy;
import ch.digitalfondue.npjt.ConstructorAnnotationRowMapper;
import java.math.BigDecimal;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

public class TicketReservationWithEventIdentifier {
    private final TicketReservation reservation;
    private final String eventPublicIdentifier;

    public TicketReservationWithEventIdentifier(@ConstructorAnnotationRowMapper.Column(value="id") String id, @ConstructorAnnotationRowMapper.Column(value="validity") Date validity, @ConstructorAnnotationRowMapper.Column(value="status") TicketReservation.TicketReservationStatus status, @ConstructorAnnotationRowMapper.Column(value="full_name") String fullName, @ConstructorAnnotationRowMapper.Column(value="first_name") String firstName, @ConstructorAnnotationRowMapper.Column(value="last_name") String lastName, @ConstructorAnnotationRowMapper.Column(value="email_address") String email, @ConstructorAnnotationRowMapper.Column(value="billing_address") String billingAddress, @ConstructorAnnotationRowMapper.Column(value="confirmation_ts") ZonedDateTime confirmationTimestamp, @ConstructorAnnotationRowMapper.Column(value="latest_reminder_ts") ZonedDateTime latestReminder, @ConstructorAnnotationRowMapper.Column(value="payment_method") PaymentProxy paymentMethod, @ConstructorAnnotationRowMapper.Column(value="offline_payment_reminder_sent") Boolean reminderSent, @ConstructorAnnotationRowMapper.Column(value="promo_code_id_fk") Integer promoCodeDiscountId, @ConstructorAnnotationRowMapper.Column(value="automatic") boolean automatic, @ConstructorAnnotationRowMapper.Column(value="user_language") String userLanguage, @ConstructorAnnotationRowMapper.Column(value="direct_assignment") boolean directAssignmentRequested, @ConstructorAnnotationRowMapper.Column(value="invoice_number") String invoiceNumber, @ConstructorAnnotationRowMapper.Column(value="invoice_model") String invoiceModel, @ConstructorAnnotationRowMapper.Column(value="vat_status") PriceContainer.VatStatus vatStatus, @ConstructorAnnotationRowMapper.Column(value="vat_nr") String vatNr, @ConstructorAnnotationRowMapper.Column(value="vat_country") String vatCountryCode, @ConstructorAnnotationRowMapper.Column(value="invoice_requested") boolean invoiceRequested, @ConstructorAnnotationRowMapper.Column(value="used_vat_percent") BigDecimal usedVatPercent, @ConstructorAnnotationRowMapper.Column(value="vat_included") Boolean vatIncluded, @ConstructorAnnotationRowMapper.Column(value="creation_ts") ZonedDateTime creationTimestamp, @ConstructorAnnotationRowMapper.Column(value="customer_reference") String customerReference, @ConstructorAnnotationRowMapper.Column(value="registration_ts") ZonedDateTime registrationTimestamp, @ConstructorAnnotationRowMapper.Column(value="src_price_cts") Integer srcPriceCts, @ConstructorAnnotationRowMapper.Column(value="final_price_cts") Integer finalPriceCts, @ConstructorAnnotationRowMapper.Column(value="vat_cts") Integer vatCts, @ConstructorAnnotationRowMapper.Column(value="discount_cts") Integer discountCts, @ConstructorAnnotationRowMapper.Column(value="currency_code") String currencyCode, @ConstructorAnnotationRowMapper.Column(value="short_name") String eventPublicIdentifier) {
        this.eventPublicIdentifier = eventPublicIdentifier;
        this.reservation = new TicketReservation(id, validity, status, fullName, firstName, lastName, email, billingAddress, confirmationTimestamp, latestReminder, paymentMethod, reminderSent, promoCodeDiscountId, automatic, userLanguage, directAssignmentRequested, invoiceNumber, invoiceModel, vatStatus, vatNr, vatCountryCode, invoiceRequested, usedVatPercent, vatIncluded, creationTimestamp, customerReference, registrationTimestamp, srcPriceCts, finalPriceCts, vatCts, discountCts, currencyCode);
    }

    public String getEventPublicIdentifier() {
        return this.eventPublicIdentifier;
    }

    public int getFinalPriceCts() {
        return this.reservation.getFinalPriceCts();
    }

    public String getPaidAmount() {
        return this.reservation.getPaidAmount();
    }

    public String getCurrencyCode() {
        return this.reservation.getCurrencyCode();
    }

    @Generated
    public boolean isStuck() {
        return this.reservation.isStuck();
    }

    @Generated
    public boolean isReminderSent() {
        return this.reservation.isReminderSent();
    }

    @Generated
    public boolean getHasBillingAddress() {
        return this.reservation.getHasBillingAddress();
    }

    @Generated
    public Optional<ZonedDateTime> latestNotificationTimestamp(ZoneId zoneId) {
        return this.reservation.latestNotificationTimestamp(zoneId);
    }

    @Generated
    public String getFullName() {
        return this.reservation.getFullName();
    }

    @Generated
    public boolean getHasInvoiceNumber() {
        return this.reservation.getHasInvoiceNumber();
    }

    @Generated
    public boolean getHasInvoiceOrReceiptDocument() {
        return this.reservation.getHasInvoiceOrReceiptDocument();
    }

    @Generated
    public boolean getHasBeenPaid() {
        return this.reservation.getHasBeenPaid();
    }

    @Generated
    public boolean getHasVatNumber() {
        return this.reservation.getHasVatNumber();
    }

    @Generated
    public List<String> getLineSplittedBillingAddress() {
        return this.reservation.getLineSplittedBillingAddress();
    }

    @Generated
    public boolean isCancelled() {
        return this.reservation.isCancelled();
    }

    @Generated
    public boolean isPendingOfflinePayment() {
        return this.reservation.isPendingOfflinePayment();
    }

    @Generated
    public TicketReservation withVatStatus(PriceContainer.VatStatus vatStatus) {
        return this.reservation.withVatStatus(vatStatus);
    }

    @Generated
    public String getId() {
        return this.reservation.getId();
    }

    @Generated
    public Date getValidity() {
        return this.reservation.getValidity();
    }

    @Generated
    public TicketReservation.TicketReservationStatus getStatus() {
        return this.reservation.getStatus();
    }

    @Generated
    public String getFirstName() {
        return this.reservation.getFirstName();
    }

    @Generated
    public String getLastName() {
        return this.reservation.getLastName();
    }

    @Generated
    public String getEmail() {
        return this.reservation.getEmail();
    }

    @Generated
    public String getBillingAddress() {
        return this.reservation.getBillingAddress();
    }

    @Generated
    public ZonedDateTime getConfirmationTimestamp() {
        return this.reservation.getConfirmationTimestamp();
    }

    @Generated
    public ZonedDateTime getLatestReminder() {
        return this.reservation.getLatestReminder();
    }

    @Generated
    public PaymentProxy getPaymentMethod() {
        return this.reservation.getPaymentMethod();
    }

    @Generated
    public Boolean getReminderSent() {
        return this.reservation.getReminderSent();
    }

    @Generated
    public Integer getPromoCodeDiscountId() {
        return this.reservation.getPromoCodeDiscountId();
    }

    @Generated
    public boolean isAutomatic() {
        return this.reservation.isAutomatic();
    }

    @Generated
    public String getUserLanguage() {
        return this.reservation.getUserLanguage();
    }

    @Generated
    public boolean isDirectAssignmentRequested() {
        return this.reservation.isDirectAssignmentRequested();
    }

    @Generated
    public String getInvoiceNumber() {
        return this.reservation.getInvoiceNumber();
    }

    @Generated
    public String getInvoiceModel() {
        return this.reservation.getInvoiceModel();
    }

    @Generated
    public String getVatNr() {
        return this.reservation.getVatNr();
    }

    @Generated
    public String getVatCountryCode() {
        return this.reservation.getVatCountryCode();
    }

    @Generated
    public boolean isInvoiceRequested() {
        return this.reservation.isInvoiceRequested();
    }

    @Generated
    public BigDecimal getUsedVatPercent() {
        return this.reservation.getUsedVatPercent();
    }

    @Generated
    public Boolean getVatIncluded() {
        return this.reservation.getVatIncluded();
    }

    @Generated
    public ZonedDateTime getCreationTimestamp() {
        return this.reservation.getCreationTimestamp();
    }

    @Generated
    public String getCustomerReference() {
        return this.reservation.getCustomerReference();
    }

    @Generated
    public ZonedDateTime getRegistrationTimestamp() {
        return this.reservation.getRegistrationTimestamp();
    }

    @Generated
    public int getVatCts() {
        return this.reservation.getVatCts();
    }

    @Generated
    public int getDiscountCts() {
        return this.reservation.getDiscountCts();
    }
}

