/*
 * Decompiled with CFR 0.152.
 */
package alfio.model;

import alfio.model.Ticket;
import alfio.model.TicketCategory;
import alfio.model.TicketInfoContainer;
import com.fasterxml.jackson.annotation.JsonIgnore;

public record TicketWithCategory(@JsonIgnore Ticket ticket, @JsonIgnore TicketCategory category) implements TicketInfoContainer
{
    @JsonIgnore
    private final Ticket ticket;
    @JsonIgnore
    private final TicketCategory category;

    public TicketWithCategory(Ticket ticket, TicketCategory category) {
        this.ticket = ticket;
        this.category = category;
    }

    public String getCategoryName() {
        return this.category != null ? this.category.getName() : null;
    }

    public boolean getAssigned() {
        return this.ticket.getAssigned();
    }

    public boolean isCheckedIn() {
        return this.ticket.isCheckedIn();
    }

    public int getId() {
        return this.ticket.getId();
    }

    public String getUuid() {
        return this.ticket.getUuid();
    }

    public int getEventId() {
        return this.ticket.getEventId();
    }

    public String getTicketsReservationId() {
        return this.ticket.getTicketsReservationId();
    }

    public String getFirstName() {
        return this.ticket.getFirstName();
    }

    public String getLastName() {
        return this.ticket.getLastName();
    }

    public String getEmail() {
        return this.ticket.getEmail();
    }

    public String getUserLanguage() {
        return this.ticket.getUserLanguage();
    }

    public Integer getCategoryId() {
        return this.ticket.getCategoryId();
    }

    public String getFullName() {
        return this.ticket.getFullName();
    }

    public String getFormattedFinalPrice() {
        return this.ticket.getFormattedFinalPrice();
    }

    public String getFormattedNetPrice() {
        return this.ticket.getFormattedNetPrice();
    }

    @JsonIgnore
    public Ticket ticket() {
        return this.ticket;
    }

    @JsonIgnore
    public TicketCategory category() {
        return this.category;
    }
}

