/*
 * Decompiled with CFR 0.152.
 */
package alfio.model;

import alfio.model.PriceContainer;
import alfio.model.Ticket;
import alfio.model.metadata.TicketMetadataContainer;
import alfio.model.support.Array;
import alfio.model.support.JSONData;
import ch.digitalfondue.npjt.ConstructorAnnotationRowMapper;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

public class TicketWithMetadataAttributes {
    private final Ticket ticket;
    private final TicketMetadataContainer ticketMetadataContainer;

    public TicketWithMetadataAttributes(@ConstructorAnnotationRowMapper.Column(value="id") int id, @ConstructorAnnotationRowMapper.Column(value="uuid") String uuid, @ConstructorAnnotationRowMapper.Column(value="public_uuid") UUID publicUuid, @ConstructorAnnotationRowMapper.Column(value="creation") ZonedDateTime creation, @ConstructorAnnotationRowMapper.Column(value="category_id") Integer categoryId, @ConstructorAnnotationRowMapper.Column(value="status") String status, @ConstructorAnnotationRowMapper.Column(value="event_id") int eventId, @ConstructorAnnotationRowMapper.Column(value="tickets_reservation_id") String ticketsReservationId, @ConstructorAnnotationRowMapper.Column(value="full_name") String fullName, @ConstructorAnnotationRowMapper.Column(value="first_name") String firstName, @ConstructorAnnotationRowMapper.Column(value="last_name") String lastName, @ConstructorAnnotationRowMapper.Column(value="email_address") String email, @ConstructorAnnotationRowMapper.Column(value="locked_assignment") boolean lockedAssignment, @ConstructorAnnotationRowMapper.Column(value="user_language") String userLanguage, @ConstructorAnnotationRowMapper.Column(value="src_price_cts") int srcPriceCts, @ConstructorAnnotationRowMapper.Column(value="final_price_cts") int finalPriceCts, @ConstructorAnnotationRowMapper.Column(value="vat_cts") int vatCts, @ConstructorAnnotationRowMapper.Column(value="discount_cts") int discountCts, @ConstructorAnnotationRowMapper.Column(value="ext_reference") String extReference, @ConstructorAnnotationRowMapper.Column(value="currency_code") String currencyCode, @ConstructorAnnotationRowMapper.Column(value="tags") @Array List<String> tags, @ConstructorAnnotationRowMapper.Column(value="subscription_id_fk") UUID subscriptionId, @ConstructorAnnotationRowMapper.Column(value="vat_status") PriceContainer.VatStatus vatStatus, @ConstructorAnnotationRowMapper.Column(value="metadata") @JSONData TicketMetadataContainer ticketMetadataContainer) {
        this(new Ticket(id, uuid, publicUuid, creation, categoryId, status, eventId, ticketsReservationId, fullName, firstName, lastName, email, lockedAssignment, userLanguage, srcPriceCts, finalPriceCts, vatCts, discountCts, extReference, currencyCode, tags, subscriptionId, vatStatus), ticketMetadataContainer);
    }

    private TicketWithMetadataAttributes(Ticket ticket, TicketMetadataContainer ticketMetadataContainer) {
        this.ticket = ticket;
        this.ticketMetadataContainer = Objects.requireNonNullElseGet(ticketMetadataContainer, TicketMetadataContainer::empty);
    }

    public Map<String, String> getAttributes() {
        return this.ticketMetadataContainer.getMetadataForKey("general").flatMap(tm -> Optional.ofNullable(tm.getAttributes())).orElse(Map.of());
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    @JsonIgnore
    public TicketMetadataContainer getMetadata() {
        return this.ticketMetadataContainer;
    }

    public static TicketWithMetadataAttributes build(Ticket ticket, TicketMetadataContainer ticketMetadataContainer) {
        return new TicketWithMetadataAttributes(ticket, ticketMetadataContainer);
    }
}

