/*
 * Decompiled with CFR 0.152.
 */
package alfio.model.api.v1.admin;

import alfio.model.api.v1.admin.AdditionalInfoRequest;
import alfio.model.api.v1.admin.DescriptionRequest;
import alfio.model.api.v1.admin.EventCreationRequest;
import alfio.model.modification.AdditionalFieldRequest;
import alfio.model.modification.EventModification;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

/*
 * Exception performing whole class analysis ignored.
 */
public class AdditionalInfoRequest {
    private Integer ordinal;
    private String name;
    private AdditionalInfoType type;
    private Boolean required;
    private List<DescriptionRequest> label;
    private List<DescriptionRequest> placeholder;
    private List<RestrictedValueRequest> restrictedValues;
    private ContentLengthRequest contentLength;
    public static final Set<String> WITH_RESTRICTED_VALUES = Set.of(AdditionalInfoType.LIST_BOX.code, AdditionalInfoType.CHECKBOX.code, AdditionalInfoType.RADIO.code);

    public boolean isValid() {
        return StringUtils.isNotBlank((CharSequence)this.name) && this.type != null && CollectionUtils.isNotEmpty((Collection)this.label) && this.label.stream().allMatch(DescriptionRequest::isValid);
    }

    public AdditionalFieldRequest toAdditionalField(int ordinal) {
        int position = this.ordinal != null ? this.ordinal : ordinal;
        String code = this.type != null ? this.type.code : AdditionalInfoType.GENERIC_TEXT.code;
        Integer minLength = this.contentLength != null ? this.contentLength.min : null;
        Integer maxLength = this.contentLength != null ? this.contentLength.max : null;
        List restrictedValueList = null;
        if (!ObjectUtils.isEmpty((Object)this.restrictedValues)) {
            restrictedValueList = this.restrictedValues.stream().map(rv -> new EventModification.RestrictedValue(rv.getValue(), rv.getEnabled())).collect(Collectors.toList());
        }
        return new AdditionalFieldRequest(position, null, this.name, code, Boolean.TRUE.equals(this.required), false, minLength, maxLength, restrictedValueList, AdditionalInfoRequest.toDescriptionMap((List)EventCreationRequest.orEmpty((List)this.label), (List)EventCreationRequest.orEmpty((List)this.placeholder), (List)EventCreationRequest.orEmpty((List)this.restrictedValues)), null, null);
    }

    private static Map<String, EventModification.Description> toDescriptionMap(List<DescriptionRequest> label, List<DescriptionRequest> placeholder, List<RestrictedValueRequest> restrictedValues) {
        Map<String, String> labelsByLang = label.stream().collect(Collectors.toMap(DescriptionRequest::getLang, DescriptionRequest::getBody));
        Map<String, String> placeholdersByLang = placeholder.stream().collect(Collectors.toMap(DescriptionRequest::getLang, DescriptionRequest::getBody));
        Map<String, List<Triple>> valuesByLang = restrictedValues.stream().flatMap(rv -> rv.getDescriptions().stream().map(rvd -> Triple.of((Object)rvd.getLang(), (Object)rv.getValue(), (Object)rvd.getBody()))).collect(Collectors.groupingBy(Triple::getLeft));
        HashSet<String> keys = new HashSet<String>(labelsByLang.keySet());
        keys.addAll(placeholdersByLang.keySet());
        keys.addAll(valuesByLang.keySet());
        return keys.stream().map(lang -> {
            Map<String, String> rvsMap = valuesByLang.getOrDefault(lang, Collections.emptyList()).stream().collect(Collectors.toMap(Triple::getMiddle, Triple::getRight));
            return Pair.of((Object)lang, (Object)new EventModification.Description((String)labelsByLang.get(lang), (String)placeholdersByLang.get(lang), rvsMap));
        }).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
    }

    @Generated
    public Integer getOrdinal() {
        return this.ordinal;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public AdditionalInfoType getType() {
        return this.type;
    }

    @Generated
    public Boolean getRequired() {
        return this.required;
    }

    @Generated
    public List<DescriptionRequest> getLabel() {
        return this.label;
    }

    @Generated
    public List<DescriptionRequest> getPlaceholder() {
        return this.placeholder;
    }

    @Generated
    public List<RestrictedValueRequest> getRestrictedValues() {
        return this.restrictedValues;
    }

    @Generated
    public ContentLengthRequest getContentLength() {
        return this.contentLength;
    }

    @ConstructorProperties(value={"ordinal", "name", "type", "required", "label", "placeholder", "restrictedValues", "contentLength"})
    @Generated
    public AdditionalInfoRequest(Integer ordinal, String name, AdditionalInfoType type, Boolean required, List<DescriptionRequest> label, List<DescriptionRequest> placeholder, List<RestrictedValueRequest> restrictedValues, ContentLengthRequest contentLength) {
        this.ordinal = ordinal;
        this.name = name;
        this.type = type;
        this.required = required;
        this.label = label;
        this.placeholder = placeholder;
        this.restrictedValues = restrictedValues;
        this.contentLength = contentLength;
    }
}

