/*
 * Decompiled with CFR 0.152.
 */
package alfio.model.api.v1.admin;

import alfio.model.ContentLanguage;
import alfio.model.Event;
import alfio.model.EventWithAdditionalInfo;
import alfio.model.TicketCategoryWithAdditionalInfo;
import alfio.model.api.v1.admin.AdditionalInfoRequest;
import alfio.model.api.v1.admin.DescriptionRequest;
import alfio.model.api.v1.admin.EventCreationRequest;
import alfio.model.metadata.AlfioMetadata;
import alfio.model.modification.AdditionalFieldRequest;
import alfio.model.modification.DateTimeModification;
import alfio.model.modification.EventModification;
import alfio.model.modification.TicketCategoryModification;
import alfio.model.modification.support.LocationDescriptor;
import alfio.model.user.Organization;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class EventCreationRequest {
    private String title;
    private String slug;
    private List<DescriptionRequest> description;
    private Event.EventFormat format;
    private LocationRequest location;
    private String timezone;
    private LocalDateTime startDate;
    private LocalDateTime endDate;
    private String websiteUrl;
    private String termsAndConditionsUrl;
    private String privacyPolicyUrl;
    private String imageUrl;
    private TicketRequest tickets;
    private List<ExtensionSetting> extensionSettings;
    private List<AdditionalInfoRequest> additionalInfo;

    public EventModification toEventModification(Organization organization, UnaryOperator<String> slugGenerator, String imageRef) {
        String slug = this.slug;
        if (StringUtils.isBlank((CharSequence)slug)) {
            slug = (String)slugGenerator.apply(this.title);
        }
        int locales = this.description.stream().map(x -> ContentLanguage.ALL_LANGUAGES.stream().filter(l -> l.getLanguage().equals(x.getLang())).findFirst()).flatMap(Optional::stream).mapToInt(ContentLanguage::getValue).reduce(0, (x, y) -> x | y);
        return new EventModification(null, Objects.requireNonNullElse(this.format, Event.EventFormat.IN_PERSON), this.websiteUrl, null, this.termsAndConditionsUrl, StringUtils.trimToNull((String)this.privacyPolicyUrl), null, imageRef, slug, this.title, organization.getId(), this.location.getFullAddress(), this.location.getCoordinate().getLatitude(), this.location.getCoordinate().getLongitude(), this.timezone, this.description.stream().collect(Collectors.toMap(DescriptionRequest::getLang, DescriptionRequest::getBody)), new DateTimeModification(this.startDate.toLocalDate(), this.startDate.toLocalTime()), new DateTimeModification(this.endDate.toLocalDate(), this.endDate.toLocalTime()), Boolean.TRUE.equals(this.tickets.freeOfCharge) ? BigDecimal.ZERO : this.tickets.categories.stream().map(x -> x.price).max(BigDecimal::compareTo).orElse(BigDecimal.ONE).max(BigDecimal.ONE), this.tickets.currency, this.tickets.max, this.tickets.taxPercentage, this.tickets.taxIncludedInPrice.booleanValue(), this.tickets.paymentMethods, this.getTicketCategoryModificationList(), this.tickets.freeOfCharge.booleanValue(), new LocationDescriptor(this.timezone, this.location.getCoordinate().getLatitude(), this.location.getCoordinate().getLongitude(), null), locales, EventCreationRequest.toAdditionalFields((List)EventCreationRequest.orEmpty((List)this.additionalInfo)), Collections.emptyList(), AlfioMetadata.empty(), List.of());
    }

    private List<TicketCategoryModification> getTicketCategoryModificationList() {
        ArrayList<TicketCategoryModification> result = new ArrayList<TicketCategoryModification>();
        for (int c = 0; c < this.tickets.categories.size(); ++c) {
            result.add(((CategoryRequest)this.tickets.categories.get(c)).toNewTicketCategoryModification(c + 1));
        }
        return List.copyOf(result);
    }

    private static <T> T first(T value, T other) {
        return Optional.ofNullable(value).orElse(other);
    }

    public EventModification toEventModificationUpdate(EventWithAdditionalInfo original, Organization organization, String imageRef) {
        int locales = original.getLocales();
        if (this.description != null) {
            locales = this.description.stream().map(x -> ContentLanguage.ALL_LANGUAGES.stream().filter(l -> l.getLanguage().equals(x.getLang())).findFirst()).flatMap(Optional::stream).mapToInt(ContentLanguage::getValue).reduce(0, (x, y) -> x | y);
        }
        return new EventModification(Integer.valueOf(original.getId()), original.getFormat(), (String)EventCreationRequest.first((Object)this.websiteUrl, (Object)original.getWebsiteUrl()), null, (String)EventCreationRequest.first((Object)this.termsAndConditionsUrl, (Object)original.getWebsiteUrl()), (String)EventCreationRequest.first((Object)this.privacyPolicyUrl, (Object)original.getPrivacyPolicyUrl()), null, (String)EventCreationRequest.first((Object)imageRef, (Object)original.getFileBlobId()), original.getShortName(), (String)EventCreationRequest.first((Object)this.title, (Object)original.getDisplayName()), organization.getId(), this.location != null ? (String)EventCreationRequest.first((Object)this.location.getFullAddress(), (Object)original.getLocation()) : original.getLocation(), this.location != null && this.location.getCoordinate() != null ? this.location.getCoordinate().getLatitude() : original.getLatitude(), this.location != null && this.location.getCoordinate() != null ? this.location.getCoordinate().getLongitude() : original.getLongitude(), (String)EventCreationRequest.first((Object)this.timezone, (Object)original.getTimeZone()), this.description != null ? this.description.stream().collect(Collectors.toMap(DescriptionRequest::getLang, DescriptionRequest::getBody)) : null, this.startDate != null ? new DateTimeModification(this.startDate.toLocalDate(), this.startDate.toLocalTime()) : new DateTimeModification(original.getBegin().toLocalDate(), original.getEnd().toLocalTime()), this.endDate != null ? new DateTimeModification(this.endDate.toLocalDate(), this.endDate.toLocalTime()) : new DateTimeModification(original.getEnd().toLocalDate(), original.getEnd().toLocalTime()), this.tickets != null && this.tickets.categories != null ? this.tickets.categories.stream().map(x -> x.price).max(BigDecimal::compareTo).orElse(BigDecimal.ZERO).max(original.getRegularPrice()) : original.getRegularPrice(), this.tickets != null ? (String)EventCreationRequest.first((Object)this.tickets.currency, (Object)original.getCurrency()) : original.getCurrency(), Integer.valueOf(this.tickets != null ? this.tickets.max.intValue() : original.getAvailableSeats()), this.tickets != null ? (BigDecimal)EventCreationRequest.first((Object)this.tickets.taxPercentage, (Object)original.getVat()) : original.getVat(), this.tickets != null ? ((Boolean)EventCreationRequest.first((Object)this.tickets.taxIncludedInPrice, (Object)original.isVatIncluded())).booleanValue() : original.isVatIncluded(), this.tickets != null ? (List)EventCreationRequest.first((Object)this.tickets.paymentMethods, (Object)original.getAllowedPaymentProxies()) : original.getAllowedPaymentProxies(), this.tickets != null && this.tickets.categories != null ? this.createFromExistingCategories(original) : null, this.tickets != null ? ((Boolean)EventCreationRequest.first((Object)this.tickets.freeOfCharge, (Object)original.isFreeOfCharge())).booleanValue() : original.isFreeOfCharge(), null, locales, EventCreationRequest.toAdditionalFields((List)EventCreationRequest.orEmpty((List)this.additionalInfo)), Collections.emptyList(), AlfioMetadata.empty(), List.of());
    }

    private List<TicketCategoryModification> createFromExistingCategories(EventWithAdditionalInfo event) {
        ArrayList<TicketCategoryModification> result = new ArrayList<TicketCategoryModification>(this.tickets.categories.size());
        for (int c = 0; c < this.tickets.categories.size(); ++c) {
            CategoryRequest categoryRequest = (CategoryRequest)this.tickets.categories.get(c);
            Optional existing = EventCreationRequest.findExistingCategory((List)event.getTicketCategories(), (String)categoryRequest.getName(), (Integer)categoryRequest.getId());
            if (existing.isPresent()) {
                TicketCategoryWithAdditionalInfo category = (TicketCategoryWithAdditionalInfo)existing.get();
                result.add(categoryRequest.toExistingTicketCategoryModification(Integer.valueOf(category.getId()), category.getOrdinal()));
                continue;
            }
            result.add(categoryRequest.toNewTicketCategoryModification(c + 1));
        }
        return List.copyOf(result);
    }

    public static Optional<TicketCategoryWithAdditionalInfo> findExistingCategory(List<TicketCategoryWithAdditionalInfo> categories, String name, Integer id) {
        return categories.stream().filter(oc -> id != null ? id.intValue() == oc.getId() : oc.getName().equals(name)).findFirst();
    }

    public static <T> List<T> orEmpty(List<T> input) {
        return CollectionUtils.isEmpty(input) ? Collections.emptyList() : input;
    }

    private static List<AdditionalFieldRequest> toAdditionalFields(List<AdditionalInfoRequest> additionalInfoRequests) {
        if (CollectionUtils.isEmpty(additionalInfoRequests)) {
            return Collections.emptyList();
        }
        AtomicInteger counter = new AtomicInteger(1);
        return additionalInfoRequests.stream().map(air -> air.toAdditionalField(counter.getAndIncrement())).collect(Collectors.toList());
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getSlug() {
        return this.slug;
    }

    @Generated
    public List<DescriptionRequest> getDescription() {
        return this.description;
    }

    @Generated
    public Event.EventFormat getFormat() {
        return this.format;
    }

    @Generated
    public LocationRequest getLocation() {
        return this.location;
    }

    @Generated
    public String getTimezone() {
        return this.timezone;
    }

    @Generated
    public LocalDateTime getStartDate() {
        return this.startDate;
    }

    @Generated
    public LocalDateTime getEndDate() {
        return this.endDate;
    }

    @Generated
    public String getWebsiteUrl() {
        return this.websiteUrl;
    }

    @Generated
    public String getTermsAndConditionsUrl() {
        return this.termsAndConditionsUrl;
    }

    @Generated
    public String getPrivacyPolicyUrl() {
        return this.privacyPolicyUrl;
    }

    @Generated
    public String getImageUrl() {
        return this.imageUrl;
    }

    @Generated
    public TicketRequest getTickets() {
        return this.tickets;
    }

    @Generated
    public List<ExtensionSetting> getExtensionSettings() {
        return this.extensionSettings;
    }

    @Generated
    public List<AdditionalInfoRequest> getAdditionalInfo() {
        return this.additionalInfo;
    }

    @ConstructorProperties(value={"title", "slug", "description", "format", "location", "timezone", "startDate", "endDate", "websiteUrl", "termsAndConditionsUrl", "privacyPolicyUrl", "imageUrl", "tickets", "extensionSettings", "additionalInfo"})
    @Generated
    public EventCreationRequest(String title, String slug, List<DescriptionRequest> description, Event.EventFormat format, LocationRequest location, String timezone, LocalDateTime startDate, LocalDateTime endDate, String websiteUrl, String termsAndConditionsUrl, String privacyPolicyUrl, String imageUrl, TicketRequest tickets, List<ExtensionSetting> extensionSettings, List<AdditionalInfoRequest> additionalInfo) {
        this.title = title;
        this.slug = slug;
        this.description = description;
        this.format = format;
        this.location = location;
        this.timezone = timezone;
        this.startDate = startDate;
        this.endDate = endDate;
        this.websiteUrl = websiteUrl;
        this.termsAndConditionsUrl = termsAndConditionsUrl;
        this.privacyPolicyUrl = privacyPolicyUrl;
        this.imageUrl = imageUrl;
        this.tickets = tickets;
        this.extensionSettings = extensionSettings;
        this.additionalInfo = additionalInfo;
    }
}

