/*
 * Decompiled with CFR 0.152.
 */
package alfio.model.api.v1.admin;

import alfio.model.PriceContainer;
import alfio.model.api.v1.admin.AdditionalInfoRequest;
import alfio.model.api.v1.admin.DescriptionRequest;
import alfio.model.api.v1.admin.subscription.CustomPeriodTerm;
import alfio.model.api.v1.admin.subscription.EntryBasedTerm;
import alfio.model.api.v1.admin.subscription.StandardPeriodTerm;
import alfio.model.api.v1.admin.subscription.SubscriptionTerm;
import alfio.model.modification.AdditionalFieldRequest;
import alfio.model.modification.SubscriptionDescriptorModification;
import alfio.model.result.ErrorCode;
import alfio.model.result.Result;
import alfio.model.subscription.SubscriptionDescriptor;
import alfio.model.transaction.PaymentProxy;
import alfio.util.LocaleUtil;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionDescriptorModificationRequest {
    private static final Logger log = LoggerFactory.getLogger(SubscriptionDescriptorModificationRequest.class);
    public static final String TERM_STANDARD = "standard";
    public static final String TERM_NUM_ENTRIES = "numEntries";
    public static final String TERM_CUSTOM = "custom";
    private final SubscriptionDescriptor.SubscriptionUsageType usageType;
    private final SubscriptionTerm term;
    private final List<DescriptionRequest> title;
    private final List<DescriptionRequest> description;
    private final Integer maxAvailable;
    private final LocalDateTime onSaleFrom;
    private final LocalDateTime onSaleTo;
    private final BigDecimal price;
    private final BigDecimal taxPercentage;
    private final PriceContainer.VatStatus taxPolicy;
    private final String currencyCode;
    private final Boolean isPublic;
    private final String imageUrl;
    private final String termType;
    private final String termsAndConditionsUrl;
    private final String privacyPolicyUrl;
    private final String timezone;
    private final Boolean supportsTicketsGeneration;
    private final List<PaymentProxy> paymentMethods;
    private final List<AdditionalInfoRequest> additionalInfo;

    @JsonCreator
    public SubscriptionDescriptorModificationRequest(@JsonProperty(value="usageType") SubscriptionDescriptor.SubscriptionUsageType usageType, @JsonProperty(value="termType") String termType, @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXTERNAL_PROPERTY, property="termType") @JsonSubTypes(value={@JsonSubTypes.Type(value=StandardPeriodTerm.class, name="standard"), @JsonSubTypes.Type(value=EntryBasedTerm.class, name="numEntries"), @JsonSubTypes.Type(value=CustomPeriodTerm.class, name="custom")}) @JsonProperty(value="term") SubscriptionTerm term, @JsonProperty(value="title") List<DescriptionRequest> title, @JsonProperty(value="description") List<DescriptionRequest> description, @JsonProperty(value="maxAvailable") Integer maxAvailable, @JsonProperty(value="onSaleFrom") LocalDateTime onSaleFrom, @JsonProperty(value="onSaleTo") LocalDateTime onSaleTo, @JsonProperty(value="price") BigDecimal price, @JsonProperty(value="taxPercentage") BigDecimal taxPercentage, @JsonProperty(value="taxPolicy") PriceContainer.VatStatus taxPolicy, @JsonProperty(value="currencyCode") String currencyCode, @JsonProperty(value="isPublic") Boolean isPublic, @JsonProperty(value="imageUrl") String imageUrl, @JsonProperty(value="termsAndConditionsUrl") String termsAndConditionsUrl, @JsonProperty(value="privacyPolicyUrl") String privacyPolicyUrl, @JsonProperty(value="timezone") String timezone, @JsonProperty(value="supportsTicketsGeneration") Boolean supportsTicketsGeneration, @JsonProperty(value="paymentMethods") List<PaymentProxy> paymentMethods, @JsonProperty(value="additionalInfo") List<AdditionalInfoRequest> additionalInfo) {
        this.usageType = usageType;
        this.termType = termType;
        this.term = term;
        this.title = Objects.requireNonNullElse(title, List.of());
        this.description = Objects.requireNonNullElse(description, List.of());
        this.maxAvailable = maxAvailable;
        this.onSaleFrom = onSaleFrom;
        this.onSaleTo = onSaleTo;
        this.price = price;
        this.taxPercentage = taxPercentage;
        this.taxPolicy = taxPolicy;
        this.currencyCode = currencyCode;
        this.isPublic = isPublic;
        this.imageUrl = imageUrl;
        this.termsAndConditionsUrl = termsAndConditionsUrl;
        this.privacyPolicyUrl = privacyPolicyUrl;
        this.timezone = timezone;
        this.supportsTicketsGeneration = supportsTicketsGeneration;
        this.paymentMethods = Objects.requireNonNullElse(paymentMethods, List.of());
        this.additionalInfo = Objects.requireNonNullElse(additionalInfo, List.of());
    }

    public Result<SubscriptionDescriptorModification> toDescriptorModification(UUID id, int organizationId, String fileBlobId) {
        Optional zoneIdOptional = this.getZoneId();
        return new Result.Builder().checkPrecondition(zoneIdOptional::isPresent, ErrorCode.custom((String)"timezone", (String)"Timezone is mandatory")).checkPrecondition(() -> this.usageType != null, ErrorCode.custom((String)"usageType", (String)"UsageType is mandatory")).checkPrecondition(() -> this.term != null && this.term.validate(), ErrorCode.custom((String)"term", (String)"Term is not valid")).build(() -> {
            ZoneId zoneId = (ZoneId)zoneIdOptional.orElseThrow();
            return new SubscriptionDescriptorModification(id, this.title.stream().collect(Collectors.toMap(DescriptionRequest::getLang, DescriptionRequest::getBody)), this.description.stream().collect(Collectors.toMap(DescriptionRequest::getLang, DescriptionRequest::getBody)), Objects.requireNonNullElse(this.maxAvailable, -1), LocaleUtil.atZone((LocalDateTime)this.onSaleFrom, (ZoneId)zoneId), LocaleUtil.atZone((LocalDateTime)this.onSaleTo, (ZoneId)zoneId), this.price, this.taxPercentage, this.taxPolicy, this.currencyCode, Boolean.valueOf(Boolean.TRUE.equals(this.isPublic)), organizationId, Objects.requireNonNullElse(this.term.getNumEntries(), -1), this.getValidityType(), this.term.getTimeUnit(), this.term.getUnits(), LocaleUtil.atZone((LocalDateTime)this.term.getValidityFrom(), (ZoneId)zoneId), LocaleUtil.atZone((LocalDateTime)this.term.getValidityTo(), (ZoneId)zoneId), this.usageType, this.termsAndConditionsUrl, this.privacyPolicyUrl, fileBlobId, this.paymentMethods, zoneId, Boolean.valueOf(Boolean.TRUE.equals(this.supportsTicketsGeneration)));
        });
    }

    public Result<List<AdditionalFieldRequest>> toAdditionalFieldsRequest() {
        return new Result.Builder().checkPrecondition(() -> this.additionalInfo.isEmpty() || this.additionalInfo.stream().allMatch(AdditionalInfoRequest::isValid), ErrorCode.custom((String)"additionalInfo", (String)"Additional info not valid")).build(() -> IntStream.range(0, this.additionalInfo.size()).mapToObj(i -> ((AdditionalInfoRequest)this.additionalInfo.get(i)).toAdditionalField(i + 1)).collect(Collectors.toList()));
    }

    private Optional<ZoneId> getZoneId() {
        if (StringUtils.isEmpty((CharSequence)this.timezone)) {
            return Optional.empty();
        }
        try {
            return Optional.of(ZoneId.of(this.timezone));
        }
        catch (Exception ex) {
            log.warn("Error while parsing timezone", (Throwable)ex);
            return Optional.empty();
        }
    }

    private SubscriptionDescriptor.SubscriptionValidityType getValidityType() {
        if (TERM_STANDARD.equals(this.termType)) {
            return SubscriptionDescriptor.SubscriptionValidityType.STANDARD;
        }
        if (TERM_CUSTOM.equals(this.termType)) {
            return SubscriptionDescriptor.SubscriptionValidityType.CUSTOM;
        }
        if (TERM_NUM_ENTRIES.equals(this.termType)) {
            return SubscriptionDescriptor.SubscriptionValidityType.NOT_SET;
        }
        return null;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }
}

