/*
 * Decompiled with CFR 0.152.
 */
package alfio.model.api.v1.admin;

import alfio.model.api.v1.admin.ReservationAPICreationRequest;
import alfio.model.api.v1.admin.ReservationConfiguration;
import alfio.model.api.v1.admin.ReservationUser;
import alfio.model.api.v1.admin.subscription.Owner;
import alfio.model.api.v1.admin.subscription.SubscriptionConfiguration;
import alfio.model.metadata.SubscriptionMetadata;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.Objects;

public class SubscriptionReservationCreationRequest
implements ReservationAPICreationRequest {
    private final Map<String, String> metadata;
    private final ReservationUser user;
    private final String language;
    private final ReservationConfiguration reservationConfiguration;
    private final SubscriptionConfiguration subscriptionConfiguration;
    private final Owner owner;

    @JsonCreator
    public SubscriptionReservationCreationRequest(@JsonProperty(value="metadata") Map<String, String> metadata, @JsonProperty(value="user") ReservationUser user, @JsonProperty(value="language") String language, @JsonProperty(value="configuration") ReservationConfiguration reservationConfiguration, @JsonProperty(value="subscriptionConfiguration") SubscriptionConfiguration subscriptionConfiguration, @JsonProperty(value="owner") Owner owner) {
        this.metadata = metadata;
        this.user = user;
        this.language = language;
        this.reservationConfiguration = reservationConfiguration;
        this.subscriptionConfiguration = Objects.requireNonNullElseGet(subscriptionConfiguration, SubscriptionConfiguration::defaultConfiguration);
        this.owner = Objects.requireNonNullElseGet(owner, Owner::empty);
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public ReservationUser getUser() {
        return this.user;
    }

    public String getLanguage() {
        return this.language;
    }

    public ReservationConfiguration getReservationConfiguration() {
        return this.reservationConfiguration;
    }

    public SubscriptionConfiguration getSubscriptionConfiguration() {
        return this.subscriptionConfiguration;
    }

    public SubscriptionMetadata getMetadataOrNull() {
        if (this.metadata != null && !this.metadata.isEmpty()) {
            return new SubscriptionMetadata(this.metadata, this.subscriptionConfiguration);
        }
        return null;
    }

    public Owner getSubscriptionOwner() {
        return this.owner;
    }

    public boolean hasAdditionalInfo() {
        return this.getSubscriptionOwner().hasAdditionalInfo();
    }
}

