/*
 * Decompiled with CFR 0.152.
 */
package alfio.model.api.v1.admin.subscription;

import alfio.controller.form.ReadOnlyAdditionalFieldsContainer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.collections4.MapUtils;

public class Owner
implements ReadOnlyAdditionalFieldsContainer {
    private final UUID subscriptionId;
    private final Map<String, List<String>> additional;
    private final String firstName;
    private final String lastName;
    private final String email;
    private final Map<String, String> metadata;

    public Owner(@JsonProperty(value="additional") Map<String, List<String>> additional, @JsonProperty(value="subscriptionId") UUID subscriptionId, @JsonProperty(value="firstName") String firstName, @JsonProperty(value="lastName") String lastName, @JsonProperty(value="email") String email, @JsonProperty(value="metadata") Map<String, String> metadata) {
        this.additional = additional;
        this.subscriptionId = subscriptionId;
        this.firstName = firstName;
        this.lastName = lastName;
        this.email = email;
        this.metadata = Objects.requireNonNullElse(metadata, Map.of());
    }

    public Map<String, List<String>> getAdditional() {
        return this.additional;
    }

    public boolean hasAdditionalInfo() {
        return MapUtils.isNotEmpty((Map)this.additional);
    }

    public UUID getSubscriptionId() {
        return this.subscriptionId;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getEmail() {
        return this.email;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static Owner empty() {
        return new Owner(Map.of(), null, null, null, null, null);
    }
}

