/*
 * Decompiled with CFR 0.152.
 */
package alfio.model.checkin;

import alfio.model.ContentLanguage;
import alfio.model.Event;
import alfio.model.EventAndOrganizationId;
import alfio.model.EventCheckInInfo;
import alfio.model.EventHiddenFieldContainer;
import alfio.model.LocalizedContent;
import alfio.model.metadata.AlfioMetadata;
import alfio.model.support.JSONData;
import alfio.util.EventUtil;
import ch.digitalfondue.npjt.ConstructorAnnotationRowMapper;
import java.math.BigDecimal;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;

public class EventWithCheckInInfo
extends EventAndOrganizationId
implements EventHiddenFieldContainer,
EventCheckInInfo,
LocalizedContent {
    private final Event.EventFormat format;
    private final String shortName;
    private final String displayName;
    private final ZonedDateTime begin;
    private final ZonedDateTime end;
    private final ZoneId zoneId;
    private final String privateKey;
    private final AlfioMetadata metadata;
    private final List<ContentLanguage> contentLanguages;
    private final String version;

    public EventWithCheckInInfo(@ConstructorAnnotationRowMapper.Column(value="id") int id, @ConstructorAnnotationRowMapper.Column(value="format") Event.EventFormat format, @ConstructorAnnotationRowMapper.Column(value="short_name") String shortName, @ConstructorAnnotationRowMapper.Column(value="display_name") String displayName, @ConstructorAnnotationRowMapper.Column(value="start_ts") ZonedDateTime startTs, @ConstructorAnnotationRowMapper.Column(value="end_ts") ZonedDateTime endTs, @ConstructorAnnotationRowMapper.Column(value="time_zone") String timezone, @ConstructorAnnotationRowMapper.Column(value="private_key") String privateKey, @ConstructorAnnotationRowMapper.Column(value="org_id") int organizationId, @ConstructorAnnotationRowMapper.Column(value="metadata") @JSONData AlfioMetadata metadata, @ConstructorAnnotationRowMapper.Column(value="locales") int locales, @ConstructorAnnotationRowMapper.Column(value="version") String version) {
        super(id, organizationId);
        this.zoneId = ZoneId.of(timezone);
        this.format = format;
        this.shortName = shortName;
        this.displayName = displayName;
        this.begin = startTs.withZoneSameInstant(this.zoneId);
        this.end = endTs.withZoneSameInstant(this.zoneId);
        this.privateKey = privateKey;
        this.metadata = metadata;
        this.contentLanguages = ContentLanguage.findAllFor((int)locales);
        this.version = version;
    }

    public boolean isOnline() {
        return this.format == Event.EventFormat.ONLINE;
    }

    public String getPrivateKey() {
        return this.privateKey;
    }

    public Pair<String, String> getLatLong() {
        return Pair.of(null, null);
    }

    public ZoneId getZoneId() {
        return this.zoneId;
    }

    public BigDecimal getVat() {
        return null;
    }

    public List<ContentLanguage> getContentLanguages() {
        return this.contentLanguages;
    }

    public boolean supportsQRCodeCaseInsensitive() {
        return EventUtil.supportsCaseInsensitiveQRCode((String)this.version);
    }

    public boolean supportsLinkedAdditionalServices() {
        return EventUtil.supportsLinkedAdditionalServices((String)this.version);
    }

    public boolean supportsAdditionalServicesOrdinal() {
        return EventUtil.supportsAdditionalItemsOrdinal((String)this.version);
    }

    @Generated
    public Event.EventFormat getFormat() {
        return this.format;
    }

    @Generated
    public String getShortName() {
        return this.shortName;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public ZonedDateTime getBegin() {
        return this.begin;
    }

    @Generated
    public ZonedDateTime getEnd() {
        return this.end;
    }

    @Generated
    public AlfioMetadata getMetadata() {
        return this.metadata;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }
}

