/*
 * Decompiled with CFR 0.152.
 */
package alfio.model.decorator;

import alfio.model.AdditionalService;
import alfio.model.AdditionalServiceItem;
import alfio.model.PriceContainer;
import alfio.model.PromoCodeDiscount;
import alfio.model.PurchaseContext;
import alfio.model.SummaryPriceContainer;
import alfio.util.MonetaryUtil;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Optional;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
public class AdditionalServiceItemPriceContainer
implements SummaryPriceContainer {
    private final AdditionalServiceItem additionalServiceItem;
    private final AdditionalService additionalService;
    private final String currencyCode;
    private final PromoCodeDiscount discount;
    private final PriceContainer.VatStatus eventVatStatus;
    private final BigDecimal eventVatPercentage;

    public int getSrcPriceCts() {
        return Optional.ofNullable(this.additionalServiceItem.getSrcPriceCts()).orElse(0);
    }

    public Optional<PromoCodeDiscount> getDiscount() {
        return Optional.ofNullable(this.discount).filter(d -> d.getDiscountType() != PromoCodeDiscount.DiscountType.FIXED_AMOUNT_RESERVATION);
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public Optional<BigDecimal> getOptionalVatPercentage() {
        if (this.additionalService.vatType() == AdditionalService.VatType.INHERITED) {
            return Optional.ofNullable(this.eventVatPercentage);
        }
        return Optional.empty();
    }

    public PriceContainer.VatStatus getVatStatus() {
        if (this.additionalService.vatType() == AdditionalService.VatType.INHERITED) {
            return this.eventVatStatus;
        }
        return PriceContainer.VatStatus.NONE;
    }

    public BigDecimal getTaxablePrice() {
        if (this.getVatStatus() == PriceContainer.VatStatus.NONE) {
            return BigDecimal.ZERO;
        }
        return MonetaryUtil.centsToUnit((int)this.getSrcPriceCts(), (String)this.getCurrencyCode()).subtract(this.getAppliedDiscount());
    }

    public static AdditionalServiceItemPriceContainer from(AdditionalServiceItem item, AdditionalService additionalService, PurchaseContext purchaseContext, PromoCodeDiscount discount) {
        PromoCodeDiscount discountToApply = AdditionalServiceItemPriceContainer.isDiscountCompatible((PromoCodeDiscount)discount) && additionalService.type() != AdditionalService.AdditionalServiceType.DONATION ? discount : null;
        return new AdditionalServiceItemPriceContainer(item, additionalService, purchaseContext.getCurrency(), discountToApply, purchaseContext.getVatStatus(), purchaseContext.getVat());
    }

    private static boolean isDiscountCompatible(PromoCodeDiscount discount) {
        return discount != null && discount.getCodeType() == PromoCodeDiscount.CodeType.DISCOUNT && discount.getDiscountType() == PromoCodeDiscount.DiscountType.PERCENTAGE;
    }

    @ConstructorProperties(value={"additionalServiceItem", "additionalService", "currencyCode", "discount", "eventVatStatus", "eventVatPercentage"})
    @Generated
    private AdditionalServiceItemPriceContainer(AdditionalServiceItem additionalServiceItem, AdditionalService additionalService, String currencyCode, PromoCodeDiscount discount, PriceContainer.VatStatus eventVatStatus, BigDecimal eventVatPercentage) {
        this.additionalServiceItem = additionalServiceItem;
        this.additionalService = additionalService;
        this.currencyCode = currencyCode;
        this.discount = discount;
        this.eventVatStatus = eventVatStatus;
        this.eventVatPercentage = eventVatPercentage;
    }

    @Generated
    public int getId() {
        return this.additionalServiceItem.getId();
    }

    @Generated
    public String getUuid() {
        return this.additionalServiceItem.getUuid();
    }

    @Generated
    public ZonedDateTime getUtcCreation() {
        return this.additionalServiceItem.getUtcCreation();
    }

    @Generated
    public ZonedDateTime getUtcLastModified() {
        return this.additionalServiceItem.getUtcLastModified();
    }

    @Generated
    public String getTicketsReservationUuid() {
        return this.additionalServiceItem.getTicketsReservationUuid();
    }

    @Generated
    public int getAdditionalServiceId() {
        return this.additionalServiceItem.getAdditionalServiceId();
    }

    @Generated
    public AdditionalServiceItem.AdditionalServiceItemStatus getStatus() {
        return this.additionalServiceItem.getStatus();
    }

    @Generated
    public int getEventId() {
        return this.additionalServiceItem.getEventId();
    }

    @Generated
    public Integer getTicketId() {
        return this.additionalServiceItem.getTicketId();
    }

    @Generated
    public Integer getFinalPriceCts() {
        return this.additionalServiceItem.getFinalPriceCts();
    }

    @Generated
    public Integer getVatCts() {
        return this.additionalServiceItem.getVatCts();
    }

    @Generated
    public Integer getDiscountCts() {
        return this.additionalServiceItem.getDiscountCts();
    }
}

