/*
 * Decompiled with CFR 0.152.
 */
package alfio.model.decorator;

import alfio.model.AdditionalService;
import alfio.model.Event;
import alfio.model.PriceContainer;
import alfio.model.PromoCodeDiscount;
import alfio.util.MonetaryUtil;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.util.Optional;
import lombok.Generated;

public class AdditionalServicePriceContainer
implements PriceContainer {
    private final BigDecimal customAmount;
    private final AdditionalService additionalService;
    private final PromoCodeDiscount promoCodeDiscount;
    private final String currencyCode;
    private final BigDecimal vatPercentage;
    private final PriceContainer.VatStatus vatStatus;

    public int getSrcPriceCts() {
        if (AdditionalService.SupplementPolicy.isMandatoryPercentage((AdditionalService.SupplementPolicy)this.additionalService.supplementPolicy()) && this.customAmount != null) {
            return MonetaryUtil.unitToCents((BigDecimal)this.customAmount, (String)this.currencyCode);
        }
        if (this.additionalService.fixPrice()) {
            return this.additionalService.srcPriceCts();
        }
        return Optional.ofNullable(this.customAmount).map(a -> MonetaryUtil.unitToCents((BigDecimal)a, (String)this.currencyCode)).orElse(0);
    }

    public Optional<PromoCodeDiscount> getDiscount() {
        return Optional.ofNullable(this.promoCodeDiscount).filter(d -> this.additionalService.type() != AdditionalService.AdditionalServiceType.DONATION);
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public Optional<BigDecimal> getOptionalVatPercentage() {
        if (this.additionalService.vatType() == AdditionalService.VatType.INHERITED) {
            return Optional.ofNullable(this.vatPercentage);
        }
        return Optional.empty();
    }

    public PriceContainer.VatStatus getVatStatus() {
        if (this.additionalService.vatType() == AdditionalService.VatType.INHERITED) {
            return this.vatStatus;
        }
        return PriceContainer.VatStatus.NONE;
    }

    public static AdditionalServicePriceContainer from(BigDecimal customAmount, AdditionalService as, Event event, PromoCodeDiscount discount) {
        return new AdditionalServicePriceContainer(customAmount, as, discount, event.getCurrency(), event.getVat(), event.getVatStatus());
    }

    @ConstructorProperties(value={"customAmount", "additionalService", "promoCodeDiscount", "currencyCode", "vatPercentage", "vatStatus"})
    @Generated
    private AdditionalServicePriceContainer(BigDecimal customAmount, AdditionalService additionalService, PromoCodeDiscount promoCodeDiscount, String currencyCode, BigDecimal vatPercentage, PriceContainer.VatStatus vatStatus) {
        this.customAmount = customAmount;
        this.additionalService = additionalService;
        this.promoCodeDiscount = promoCodeDiscount;
        this.currencyCode = currencyCode;
        this.vatPercentage = vatPercentage;
        this.vatStatus = vatStatus;
    }
}

