/*
 * Decompiled with CFR 0.152.
 */
package alfio.model.decorator;

import alfio.model.PriceContainer;
import alfio.model.PromoCodeDiscount;
import alfio.model.PurchaseContext;
import alfio.model.subscription.Subscription;
import java.math.BigDecimal;
import java.util.Optional;

public class SubscriptionPriceContainer
implements PriceContainer {
    private final Subscription subscription;
    private final PurchaseContext purchaseContext;
    private final PromoCodeDiscount promoCodeDiscount;

    public SubscriptionPriceContainer(Subscription s, PurchaseContext purchaseContext, PromoCodeDiscount discount) {
        this.subscription = s;
        this.purchaseContext = purchaseContext;
        this.promoCodeDiscount = discount;
    }

    public static PriceContainer from(Subscription s, PurchaseContext purchaseContext, PromoCodeDiscount discount) {
        return new SubscriptionPriceContainer(s, purchaseContext, discount);
    }

    public int getSrcPriceCts() {
        return this.subscription.getSrcPriceCts();
    }

    public String getCurrencyCode() {
        return this.subscription.getCurrency();
    }

    public Optional<BigDecimal> getOptionalVatPercentage() {
        return Optional.ofNullable(this.purchaseContext.getVat());
    }

    public PriceContainer.VatStatus getVatStatus() {
        return this.purchaseContext.getVatStatus();
    }
}

