/*
 * Decompiled with CFR 0.152.
 */
package alfio.model.decorator;

import alfio.model.PriceContainer;
import alfio.model.PromoCodeDiscount;
import alfio.model.SummaryPriceContainer;
import alfio.model.Ticket;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;

public class TicketPriceContainer
implements SummaryPriceContainer {
    private final Ticket ticket;
    private final PromoCodeDiscount promoCodeDiscount;
    private final BigDecimal vatPercentage;
    private final PriceContainer.VatStatus vatStatus;

    public Optional<PromoCodeDiscount> getDiscount() {
        return Optional.ofNullable(this.promoCodeDiscount).filter(discount -> discount.getDiscountType() != PromoCodeDiscount.DiscountType.FIXED_AMOUNT_RESERVATION && (discount.getCategories().isEmpty() || discount.getCategories().contains(this.getCategoryId())));
    }

    public Optional<BigDecimal> getOptionalVatPercentage() {
        return Optional.ofNullable(this.vatPercentage);
    }

    public PriceContainer.VatStatus getVatStatus() {
        return this.vatStatus;
    }

    public int getSummarySrcPriceCts() {
        if (PriceContainer.VatStatus.isVatExempt((PriceContainer.VatStatus)this.getVatStatus())) {
            return this.getFinalPriceCts();
        }
        return this.getSrcPriceCts();
    }

    public static TicketPriceContainer from(Ticket t, PriceContainer.VatStatus reservationVatStatus, BigDecimal vat, PriceContainer.VatStatus eventVatStatus, PromoCodeDiscount discount) {
        PriceContainer.VatStatus vatStatus = (PriceContainer.VatStatus)ObjectUtils.firstNonNull((Object[])new PriceContainer.VatStatus[]{t.getVatStatus(), reservationVatStatus, eventVatStatus});
        return new TicketPriceContainer(t, discount, vat, vatStatus);
    }

    public BigDecimal getTaxablePrice() {
        if (this.vatStatus != PriceContainer.VatStatus.INCLUDED_EXEMPT && this.vatStatus != PriceContainer.VatStatus.NOT_INCLUDED_EXEMPT && this.vatStatus != PriceContainer.VatStatus.CUSTOM_NOT_INCLUDED_EXEMPT) {
            return super.getTaxablePrice();
        }
        return BigDecimal.ZERO;
    }

    public Integer getFinalPriceCts() {
        return this.ticket.getFinalPriceCts();
    }

    @ConstructorProperties(value={"ticket", "promoCodeDiscount", "vatPercentage", "vatStatus"})
    @Generated
    private TicketPriceContainer(Ticket ticket, PromoCodeDiscount promoCodeDiscount, BigDecimal vatPercentage, PriceContainer.VatStatus vatStatus) {
        this.ticket = ticket;
        this.promoCodeDiscount = promoCodeDiscount;
        this.vatPercentage = vatPercentage;
        this.vatStatus = vatStatus;
    }

    @Generated
    public boolean getAssigned() {
        return this.ticket.getAssigned();
    }

    @Generated
    public boolean getLockedAssignment() {
        return this.ticket.getLockedAssignment();
    }

    @Generated
    public String ticketCode(String eventKey, boolean caseInsensitive) {
        return this.ticket.ticketCode(eventKey, caseInsensitive);
    }

    @Generated
    public String hmacTicketInfo(String eventKey, boolean caseInsensitive) {
        return this.ticket.hmacTicketInfo(eventKey, caseInsensitive);
    }

    @Generated
    public boolean hasBeenSold() {
        return this.ticket.hasBeenSold();
    }

    @Generated
    public boolean isCheckedIn() {
        return this.ticket.isCheckedIn();
    }

    @Generated
    public String getFullName() {
        return this.ticket.getFullName();
    }

    @Generated
    public String getFormattedFinalPrice() {
        return this.ticket.getFormattedFinalPrice();
    }

    @Generated
    public String getFormattedNetPrice() {
        return this.ticket.getFormattedNetPrice();
    }

    @Generated
    public Ticket withVatStatus(PriceContainer.VatStatus newVatStatus) {
        return this.ticket.withVatStatus(newVatStatus);
    }

    @Generated
    public int getId() {
        return this.ticket.getId();
    }

    @Generated
    public String getUuid() {
        return this.ticket.getUuid();
    }

    @Generated
    public UUID getPublicUuid() {
        return this.ticket.getPublicUuid();
    }

    @Generated
    public ZonedDateTime getCreation() {
        return this.ticket.getCreation();
    }

    @Generated
    public Integer getCategoryId() {
        return this.ticket.getCategoryId();
    }

    @Generated
    public int getEventId() {
        return this.ticket.getEventId();
    }

    @Generated
    public Ticket.TicketStatus getStatus() {
        return this.ticket.getStatus();
    }

    @Generated
    public String getTicketsReservationId() {
        return this.ticket.getTicketsReservationId();
    }

    @Generated
    public String getFirstName() {
        return this.ticket.getFirstName();
    }

    @Generated
    public String getLastName() {
        return this.ticket.getLastName();
    }

    @Generated
    public String getEmail() {
        return this.ticket.getEmail();
    }

    @Generated
    public String getUserLanguage() {
        return this.ticket.getUserLanguage();
    }

    @Generated
    public int getSrcPriceCts() {
        return this.ticket.getSrcPriceCts();
    }

    @Generated
    public int getDiscountCts() {
        return this.ticket.getDiscountCts();
    }

    @Generated
    public String getExtReference() {
        return this.ticket.getExtReference();
    }

    @Generated
    public String getCurrencyCode() {
        return this.ticket.getCurrencyCode();
    }

    @Generated
    public List<String> getTags() {
        return this.ticket.getTags();
    }

    @Generated
    public UUID getSubscriptionId() {
        return this.ticket.getSubscriptionId();
    }
}

