/*
 * Decompiled with CFR 0.152.
 */
package alfio.model.metadata;

import alfio.model.LocalizedContent;
import alfio.util.EventUtil;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.LocalDateTime;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;

public class JoinLink {
    private final String link;
    private final LocalDateTime validFrom;
    private final LocalDateTime validTo;
    private final Map<String, String> linkText;

    @JsonCreator
    public JoinLink(@JsonProperty(value="link") String link, @JsonProperty(value="validFrom") LocalDateTime validFrom, @JsonProperty(value="validTo") LocalDateTime validTo, @JsonProperty(value="linkText") Map<String, String> linkText) {
        this.link = link;
        this.validFrom = validFrom;
        this.validTo = validTo;
        this.linkText = Objects.requireNonNullElse(linkText, Map.of());
    }

    public boolean hasLinkText() {
        return !this.linkText.isEmpty();
    }

    public String getLocalizedText(String lang, LocalizedContent fallback) {
        return EventUtil.getLocalizedMessage((Map)this.linkText, (String)lang, (LocalizedContent)fallback);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JoinLink joinLink = (JoinLink)o;
        return Objects.equals(this.link, joinLink.link) && Objects.equals(this.validFrom, joinLink.validFrom) && Objects.equals(this.validTo, joinLink.validTo) && this.linkText.equals(joinLink.linkText);
    }

    public int hashCode() {
        return Objects.hash(this.link, this.validFrom, this.validTo, this.linkText);
    }

    @Generated
    public String getLink() {
        return this.link;
    }

    @Generated
    public LocalDateTime getValidFrom() {
        return this.validFrom;
    }

    @Generated
    public LocalDateTime getValidTo() {
        return this.validTo;
    }

    @Generated
    public Map<String, String> getLinkText() {
        return this.linkText;
    }
}

