/*
 * Decompiled with CFR 0.152.
 */
package alfio.model.metadata;

import alfio.model.LocalizedContent;
import alfio.model.metadata.JoinLink;
import alfio.util.EventUtil;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;

public class TicketMetadata {
    private final JoinLink joinLink;
    private final Map<String, String> linkDescription;
    private final Map<String, String> attributes;

    @JsonCreator
    public TicketMetadata(@JsonProperty(value="joinLink") JoinLink joinLink, @JsonProperty(value="joinMessages") Map<String, String> linkDescription, @JsonProperty(value="attributes") Map<String, String> attributes) {
        this.joinLink = joinLink;
        this.attributes = Objects.requireNonNullElse(attributes, Map.of());
        this.linkDescription = Objects.requireNonNullElse(linkDescription, Map.of());
    }

    public String getLocalizedDescription(String lang, LocalizedContent fallback) {
        return EventUtil.getLocalizedMessage((Map)this.linkDescription, (String)lang, (LocalizedContent)fallback);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TicketMetadata that = (TicketMetadata)o;
        return Objects.equals(this.joinLink, that.joinLink) && this.linkDescription.equals(that.linkDescription) && this.attributes.equals(that.attributes);
    }

    public int hashCode() {
        return Objects.hash(this.joinLink, this.linkDescription, this.attributes);
    }

    public static TicketMetadata empty() {
        return new TicketMetadata(null, null, Map.of());
    }

    public TicketMetadata withAttributes(Map<String, String> attributes) {
        return new TicketMetadata(this.joinLink, Map.copyOf(this.linkDescription), Map.copyOf(attributes));
    }

    public static TicketMetadata copyOf(TicketMetadata src) {
        if (src != null) {
            return new TicketMetadata(src.joinLink, Map.copyOf(src.linkDescription), Map.copyOf(src.attributes));
        }
        return null;
    }

    @Generated
    public JoinLink getJoinLink() {
        return this.joinLink;
    }

    @Generated
    public Map<String, String> getLinkDescription() {
        return this.linkDescription;
    }

    @Generated
    public Map<String, String> getAttributes() {
        return this.attributes;
    }
}

