/*
 * Decompiled with CFR 0.152.
 */
package alfio.model.metadata;

import alfio.manager.support.extension.ExtensionEvent;
import alfio.model.metadata.TicketMetadata;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class TicketMetadataContainer {
    public static final String GENERAL = "general";
    private static final Set<String> ALLOWED_KEYS = Set.of("general", ExtensionEvent.CUSTOM_ONLINE_JOIN_URL.name());
    private final Map<String, TicketMetadata> metadataMap;

    @JsonCreator
    public TicketMetadataContainer(@JsonProperty(value="metadataMap") Map<String, TicketMetadata> metadataMap) {
        this.metadataMap = Objects.requireNonNullElse(metadataMap, new HashMap());
    }

    public Map<String, TicketMetadata> getMetadataMap() {
        return Map.copyOf(this.metadataMap);
    }

    public Optional<TicketMetadata> getMetadataForKey(String key) {
        return Optional.ofNullable((TicketMetadata)this.metadataMap.get(key));
    }

    public boolean putMetadata(String key, TicketMetadata value) {
        if (ALLOWED_KEYS.contains(key)) {
            this.metadataMap.put(key, value);
            return true;
        }
        return false;
    }

    public static TicketMetadataContainer empty() {
        return new TicketMetadataContainer(new HashMap());
    }

    public static TicketMetadataContainer fromMetadata(TicketMetadata metadata) {
        if (metadata != null) {
            HashMap<String, TicketMetadata> map = new HashMap<String, TicketMetadata>();
            map.put(GENERAL, metadata);
            return new TicketMetadataContainer(map);
        }
        return null;
    }

    public static TicketMetadataContainer copyOf(TicketMetadataContainer src) {
        if (src != null) {
            HashMap newMap = new HashMap();
            src.metadataMap.forEach((key, tm) -> newMap.put(key, TicketMetadata.copyOf((TicketMetadata)tm)));
            return new TicketMetadataContainer(newMap);
        }
        return null;
    }
}

