/*
 * Decompiled with CFR 0.152.
 */
package alfio.model.modification;

import alfio.model.modification.AdminReservationModification;
import alfio.model.modification.DateTimeModification;
import alfio.util.Json;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class AdminReservationModification
implements Serializable {
    private final DateTimeModification expiration;
    private final CustomerData customerData;
    private final List<TicketsInfo> ticketsInfo;
    private final String language;
    private final boolean updateContactData;
    private final boolean updateAdvancedBillingOptions;
    private final AdvancedBillingOptions advancedBillingOptions;
    private final Notification notification;
    private final SubscriptionDetails subscriptionDetails;
    private final UUID linkedSubscriptionId;

    @JsonCreator
    public AdminReservationModification(@JsonProperty(value="expiration") DateTimeModification expiration, @JsonProperty(value="customerData") CustomerData customerData, @JsonProperty(value="ticketsInfo") List<TicketsInfo> ticketsInfo, @JsonProperty(value="language") String language, @JsonProperty(value="updateContactData") Boolean updateContactData, @JsonProperty(value="updateAdvancedBillingOptions") Boolean updateAdvancedBillingOptions, @JsonProperty(value="advancedBillingOptions") AdvancedBillingOptions advancedBillingOptions, @JsonProperty(value="notification") Notification notification, @JsonProperty(value="subscriptionDetails") SubscriptionDetails subscriptionDetails, @JsonProperty(value="linkedSubscriptionId") UUID linkedSubscriptionId) {
        this.expiration = expiration;
        this.customerData = customerData;
        this.ticketsInfo = ticketsInfo;
        this.language = language;
        this.updateContactData = Boolean.TRUE.equals(updateContactData);
        this.updateAdvancedBillingOptions = Boolean.TRUE.equals(updateAdvancedBillingOptions);
        this.advancedBillingOptions = advancedBillingOptions;
        this.notification = notification;
        this.subscriptionDetails = subscriptionDetails;
        this.linkedSubscriptionId = linkedSubscriptionId;
    }

    public static String summary(AdminReservationModification src) {
        try {
            List ticketsInfo = src.ticketsInfo.stream().map(ti -> {
                List attendees = ti.getAttendees().stream().map(a -> new Attendee(a.ticketId, AdminReservationModification.placeholderIfNotEmpty((String)a.firstName), AdminReservationModification.placeholderIfNotEmpty((String)a.lastName), AdminReservationModification.placeholderIfNotEmpty((String)a.emailAddress), a.language, Boolean.valueOf(a.reassignmentForbidden), a.reference, a.subscriptionId, Collections.singletonMap("hasAdditionalInfo", Collections.singletonList(String.valueOf(a.additionalInfo.isEmpty()))), Map.of())).collect(Collectors.toList());
                return new TicketsInfo(ti.getCategory(), attendees, ti.isAddSeatsIfNotAvailable(), Boolean.valueOf(ti.isUpdateAttendees()));
            }).collect(Collectors.toList());
            return Json.toJson((Object)new AdminReservationModification(src.expiration, AdminReservationModification.summaryForCustomerData((CustomerData)src.customerData), ticketsInfo, src.getLanguage(), Boolean.valueOf(src.updateContactData), Boolean.valueOf(src.updateAdvancedBillingOptions), src.advancedBillingOptions, src.notification, src.subscriptionDetails, src.linkedSubscriptionId));
        }
        catch (Exception e) {
            return e.toString();
        }
    }

    private static CustomerData summaryForCustomerData(CustomerData in) {
        if (in != null) {
            return new CustomerData(AdminReservationModification.placeholderIfNotEmpty((String)in.firstName), AdminReservationModification.placeholderIfNotEmpty((String)in.lastName), AdminReservationModification.placeholderIfNotEmpty((String)in.emailAddress), AdminReservationModification.placeholderIfNotEmpty((String)in.billingAddress), AdminReservationModification.placeholderIfNotEmpty((String)in.userLanguage), AdminReservationModification.placeholderIfNotEmpty((String)in.customerReference), AdminReservationModification.placeholderIfNotEmpty((String)in.vatNr), AdminReservationModification.placeholderIfNotEmpty((String)in.vatCountryCode), in.invoicingAdditionalInfo);
        }
        return null;
    }

    private static String placeholderIfNotEmpty(String in) {
        return StringUtils.isNotEmpty((CharSequence)in) ? "xxx" : null;
    }

    @Generated
    public DateTimeModification getExpiration() {
        return this.expiration;
    }

    @Generated
    public CustomerData getCustomerData() {
        return this.customerData;
    }

    @Generated
    public List<TicketsInfo> getTicketsInfo() {
        return this.ticketsInfo;
    }

    @Generated
    public String getLanguage() {
        return this.language;
    }

    @Generated
    public boolean isUpdateContactData() {
        return this.updateContactData;
    }

    @Generated
    public boolean isUpdateAdvancedBillingOptions() {
        return this.updateAdvancedBillingOptions;
    }

    @Generated
    public AdvancedBillingOptions getAdvancedBillingOptions() {
        return this.advancedBillingOptions;
    }

    @Generated
    public Notification getNotification() {
        return this.notification;
    }

    @Generated
    public SubscriptionDetails getSubscriptionDetails() {
        return this.subscriptionDetails;
    }

    @Generated
    public UUID getLinkedSubscriptionId() {
        return this.linkedSubscriptionId;
    }
}

