/*
 * Decompiled with CFR 0.152.
 */
package alfio.model.modification;

import alfio.model.CustomerName;
import alfio.model.modification.AttendeeResources;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class AttendeeData {
    private final String firstName;
    private final String lastName;
    private final String email;
    private final Map<String, String> metadata;
    private final Map<String, List<String>> additional;
    private final AttendeeResources resources;

    @JsonCreator
    public AttendeeData(@JsonProperty(value="firstName") String firstName, @JsonProperty(value="lastName") String lastName, @JsonProperty(value="email") String email, @JsonProperty(value="metadata") Map<String, String> metadata, @JsonProperty(value="additional") Map<String, List<String>> additional) {
        this(firstName, lastName, email, metadata, additional, AttendeeResources.empty());
    }

    public AttendeeData(String firstName, String lastName, String email, Map<String, String> metadata, Map<String, List<String>> additional, AttendeeResources resources) {
        this.firstName = firstName;
        this.lastName = lastName;
        this.email = email;
        this.metadata = metadata;
        this.additional = additional;
        this.resources = resources;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getEmail() {
        return this.email;
    }

    public String getFullName() {
        if (this.firstName != null && this.lastName != null) {
            return new CustomerName(null, this.firstName, this.lastName, true).getFullName();
        }
        return null;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public Map<String, List<String>> getAdditional() {
        return this.additional;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public boolean hasAdditionalData() {
        return this.additional != null;
    }

    public boolean hasContactData() {
        return StringUtils.isNotBlank((CharSequence)this.firstName) || StringUtils.isNotBlank((CharSequence)this.lastName) || StringUtils.isNotBlank((CharSequence)this.email);
    }

    public AttendeeResources getResources() {
        return this.resources;
    }

    public static AttendeeData empty() {
        return new AttendeeData(null, null, null, null, null);
    }
}

