/*
 * Decompiled with CFR 0.152.
 */
package alfio.model.modification;

import alfio.manager.system.ConfigurationManager;
import alfio.model.PurchaseContext;
import alfio.model.Ticket;
import alfio.model.system.ConfigurationKeys;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Map;
import org.springframework.web.util.UriTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
public record AttendeeResources(@JsonInclude(value=JsonInclude.Include.NON_NULL) String ticketPdf, @JsonInclude(value=JsonInclude.Include.NON_NULL) String ticketQrCode, @JsonInclude(value=JsonInclude.Include.NON_NULL) String googleWallet, @JsonInclude(value=JsonInclude.Include.NON_NULL) String applePass) {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final String ticketPdf;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final String ticketQrCode;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final String googleWallet;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final String applePass;

    public AttendeeResources(@JsonInclude(value=JsonInclude.Include.NON_NULL) String ticketPdf, @JsonInclude(value=JsonInclude.Include.NON_NULL) String ticketQrCode, @JsonInclude(value=JsonInclude.Include.NON_NULL) String googleWallet, @JsonInclude(value=JsonInclude.Include.NON_NULL) String applePass) {
        this.ticketPdf = ticketPdf;
        this.ticketQrCode = ticketQrCode;
        this.googleWallet = googleWallet;
        this.applePass = applePass;
    }

    public static AttendeeResources empty() {
        return new AttendeeResources(null, null, null, null);
    }

    public static AttendeeResources fromTicket(Ticket ticket, PurchaseContext purchaseContext, Map<ConfigurationKeys, ConfigurationManager.MaybeConfiguration> conf) {
        return AttendeeResources.fromTicket((Ticket)ticket, (PurchaseContext)purchaseContext, conf, (boolean)false);
    }

    public static AttendeeResources fromTicket(Ticket ticket, PurchaseContext purchaseContext, Map<ConfigurationKeys, ConfigurationManager.MaybeConfiguration> conf, boolean allowPendingTickets) {
        if (ticket.getStatus() == Ticket.TicketStatus.PENDING && !allowPendingTickets) {
            return AttendeeResources.empty();
        }
        String baseUrl = conf.get(ConfigurationKeys.BASE_URL).getRequiredValue();
        UriTemplate ticketPdfUriTemplate = new UriTemplate(baseUrl + "/api/v2/public/event/{eventName}/ticket/{ticketIdentifier}/download-ticket");
        UriTemplate walletUriTemplate = new UriTemplate(baseUrl + "/api/wallet/event/{eventName}/v1/version/passes/{uuid}");
        UriTemplate passUriTemplate = new UriTemplate(baseUrl + "/api/pass/event/{eventName}/v1/version/passes/{uuid}");
        UriTemplate qrCodeTemplate = new UriTemplate(baseUrl + "/api/v2/public/event/{eventName}/ticket/{ticketIdentifier}/code.png");
        return new AttendeeResources(AttendeeResources.expandUriTemplate((UriTemplate)ticketPdfUriTemplate, (PurchaseContext)purchaseContext, (Ticket)ticket), AttendeeResources.expandUriTemplate((UriTemplate)qrCodeTemplate, (PurchaseContext)purchaseContext, (Ticket)ticket), AttendeeResources.generateGoogleWalletUrl((UriTemplate)walletUriTemplate, conf, (PurchaseContext)purchaseContext, (Ticket)ticket), AttendeeResources.generatePasskitUrl((UriTemplate)passUriTemplate, conf, (PurchaseContext)purchaseContext, (Ticket)ticket));
    }

    private static String generateGoogleWalletUrl(UriTemplate walletUriTemplate, Map<ConfigurationKeys, ConfigurationManager.MaybeConfiguration> conf, PurchaseContext purchaseContext, Ticket ticket) {
        if (conf.get(ConfigurationKeys.ENABLE_WALLET).getValueAsBooleanOrDefault()) {
            return AttendeeResources.expandUriTemplate((UriTemplate)walletUriTemplate, (PurchaseContext)purchaseContext, (Ticket)ticket);
        }
        return null;
    }

    private static String generatePasskitUrl(UriTemplate passkitUriTemplate, Map<ConfigurationKeys, ConfigurationManager.MaybeConfiguration> conf, PurchaseContext purchaseContext, Ticket ticket) {
        if (conf.get(ConfigurationKeys.ENABLE_PASS).getValueAsBooleanOrDefault()) {
            return AttendeeResources.expandUriTemplate((UriTemplate)passkitUriTemplate, (PurchaseContext)purchaseContext, (Ticket)ticket);
        }
        return null;
    }

    private static String expandUriTemplate(UriTemplate template, PurchaseContext purchaseContext, Ticket ticket) {
        return template.expand(new Object[]{purchaseContext.getPublicIdentifier(), ticket.getPublicUuid().toString()}).toString();
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String ticketPdf() {
        return this.ticketPdf;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String ticketQrCode() {
        return this.ticketQrCode;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String googleWallet() {
        return this.googleWallet;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String applePass() {
        return this.applePass;
    }
}

