/*
 * Decompiled with CFR 0.152.
 */
package alfio.model.modification;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import lombok.Generated;

public class DateTimeModification {
    private final LocalDate date;
    private final LocalTime time;

    public DateTimeModification(@JsonProperty(value="date") LocalDate date, @JsonProperty(value="time") LocalTime time) {
        this.date = date;
        this.time = time;
    }

    public ZonedDateTime toZonedDateTime(ZoneId zoneId) {
        return ZonedDateTime.of(this.date, this.time, zoneId);
    }

    public boolean isBefore(DateTimeModification other) {
        return this.toLocalDateTime().isBefore(other.toLocalDateTime());
    }

    public boolean isAfter(DateTimeModification other) {
        return this.toLocalDateTime().isAfter(other.toLocalDateTime());
    }

    public LocalDateTime toLocalDateTime() {
        return LocalDateTime.of(this.date, this.time);
    }

    public static DateTimeModification fromZonedDateTime(ZonedDateTime zonedDateTime) {
        return zonedDateTime == null ? null : new DateTimeModification(zonedDateTime.toLocalDate(), zonedDateTime.toLocalTime());
    }

    public static ZonedDateTime atZone(DateTimeModification t, ZoneId zoneId) {
        return t == null ? null : t.toZonedDateTime(zoneId);
    }

    @Generated
    public LocalDate getDate() {
        return this.date;
    }

    @Generated
    public LocalTime getTime() {
        return this.time;
    }
}

