/*
 * Decompiled with CFR 0.152.
 */
package alfio.model.modification;

import alfio.model.Event;
import alfio.model.PriceContainer;
import alfio.model.metadata.AlfioMetadata;
import alfio.model.modification.AdditionalFieldRequest;
import alfio.model.modification.DateTimeModification;
import alfio.model.modification.EventModification;
import alfio.model.modification.TicketCategoryModification;
import alfio.model.modification.support.LocationDescriptor;
import alfio.model.transaction.PaymentProxy;
import alfio.util.MonetaryUtil;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;

public class EventModification {
    private final Integer id;
    private final Event.EventFormat format;
    private final String websiteUrl;
    private final String externalUrl;
    private final String termsAndConditionsUrl;
    private final String privacyPolicyUrl;
    private final String imageUrl;
    private final String fileBlobId;
    private final String shortName;
    private final String displayName;
    private final int organizationId;
    private final String location;
    private final String latitude;
    private final String longitude;
    private final String zoneId;
    private final Map<String, String> description;
    private final DateTimeModification begin;
    private final DateTimeModification end;
    private final BigDecimal regularPrice;
    private final String currency;
    private final Integer availableSeats;
    private final BigDecimal vatPercentage;
    private final boolean vatIncluded;
    private final List<PaymentProxy> allowedPaymentProxies;
    private final List<TicketCategoryModification> ticketCategories;
    private final boolean freeOfCharge;
    private final LocationDescriptor locationDescriptor;
    private final int locales;
    private final List<AdditionalFieldRequest> ticketFields;
    private final List<AdditionalService> additionalServices;
    private final AlfioMetadata metadata;
    private final List<UUID> linkedSubscriptions;

    @JsonCreator
    public EventModification(@JsonProperty(value="id") Integer id, @JsonProperty(value="format") Event.EventFormat format, @JsonProperty(value="websiteUrl") String websiteUrl, @JsonProperty(value="external") String externalUrl, @JsonProperty(value="termsAndConditionsUrl") String termsAndConditionsUrl, @JsonProperty(value="privacyPolicyUrl") String privacyPolicyUrl, @JsonProperty(value="imageUrl") String imageUrl, @JsonProperty(value="fileBlobId") String fileBlobId, @JsonProperty(value="shortName") String shortName, @JsonProperty(value="displayName") String displayName, @JsonProperty(value="organizationId") int organizationId, @JsonProperty(value="location") String location, @JsonProperty(value="latitude") String latitude, @JsonProperty(value="longitude") String longitude, @JsonProperty(value="zoneId") String zoneId, @JsonProperty(value="description") Map<String, String> description, @JsonProperty(value="begin") DateTimeModification begin, @JsonProperty(value="end") DateTimeModification end, @JsonProperty(value="regularPrice") BigDecimal regularPrice, @JsonProperty(value="currency") String currency, @JsonProperty(value="availableSeats") Integer availableSeats, @JsonProperty(value="vatPercentage") BigDecimal vatPercentage, @JsonProperty(value="vatIncluded") boolean vatIncluded, @JsonProperty(value="allowedPaymentProxies") List<PaymentProxy> allowedPaymentProxies, @JsonProperty(value="ticketCategories") List<TicketCategoryModification> ticketCategories, @JsonProperty(value="freeOfCharge") boolean freeOfCharge, @JsonProperty(value="geolocation") LocationDescriptor locationDescriptor, @JsonProperty(value="locales") int locales, @JsonProperty(value="ticketFields") List<AdditionalFieldRequest> ticketFields, @JsonProperty(value="additionalServices") List<AdditionalService> additionalServices, @JsonProperty(value="metadata") AlfioMetadata metadata, @JsonProperty(value="linkedSubscriptions") List<UUID> linkedSubscriptions) {
        this.id = id;
        this.format = format;
        this.websiteUrl = websiteUrl;
        this.externalUrl = externalUrl;
        this.termsAndConditionsUrl = termsAndConditionsUrl;
        this.privacyPolicyUrl = privacyPolicyUrl;
        this.imageUrl = imageUrl;
        this.fileBlobId = fileBlobId;
        this.shortName = shortName;
        this.displayName = displayName;
        this.organizationId = organizationId;
        this.location = location;
        this.latitude = latitude;
        this.longitude = longitude;
        this.zoneId = zoneId;
        this.description = description;
        this.begin = begin;
        this.end = end;
        this.regularPrice = regularPrice;
        this.currency = currency;
        this.availableSeats = availableSeats;
        this.vatPercentage = vatPercentage;
        this.vatIncluded = vatIncluded;
        this.locationDescriptor = locationDescriptor;
        this.additionalServices = additionalServices;
        this.allowedPaymentProxies = Optional.ofNullable(allowedPaymentProxies).orElse(Collections.emptyList());
        this.ticketCategories = ticketCategories;
        this.freeOfCharge = freeOfCharge;
        this.locales = locales;
        this.ticketFields = ticketFields;
        this.metadata = metadata;
        this.linkedSubscriptions = linkedSubscriptions;
    }

    public int getPriceInCents() {
        return this.freeOfCharge ? 0 : MonetaryUtil.unitToCents((BigDecimal)this.regularPrice, (String)this.currency);
    }

    public PriceContainer.VatStatus getVatStatus() {
        if (!this.freeOfCharge) {
            return this.vatIncluded ? PriceContainer.VatStatus.INCLUDED : PriceContainer.VatStatus.NOT_INCLUDED;
        }
        return PriceContainer.VatStatus.NONE;
    }

    public LocationDescriptor getGeolocation() {
        return this.locationDescriptor;
    }

    public boolean isOnline() {
        return this.format == Event.EventFormat.ONLINE;
    }

    @Generated
    public Integer getId() {
        return this.id;
    }

    @Generated
    public Event.EventFormat getFormat() {
        return this.format;
    }

    @Generated
    public String getWebsiteUrl() {
        return this.websiteUrl;
    }

    @Generated
    public String getExternalUrl() {
        return this.externalUrl;
    }

    @Generated
    public String getTermsAndConditionsUrl() {
        return this.termsAndConditionsUrl;
    }

    @Generated
    public String getPrivacyPolicyUrl() {
        return this.privacyPolicyUrl;
    }

    @Generated
    public String getImageUrl() {
        return this.imageUrl;
    }

    @Generated
    public String getFileBlobId() {
        return this.fileBlobId;
    }

    @Generated
    public String getShortName() {
        return this.shortName;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public int getOrganizationId() {
        return this.organizationId;
    }

    @Generated
    public String getLocation() {
        return this.location;
    }

    @Generated
    public String getLatitude() {
        return this.latitude;
    }

    @Generated
    public String getLongitude() {
        return this.longitude;
    }

    @Generated
    public String getZoneId() {
        return this.zoneId;
    }

    @Generated
    public Map<String, String> getDescription() {
        return this.description;
    }

    @Generated
    public DateTimeModification getBegin() {
        return this.begin;
    }

    @Generated
    public DateTimeModification getEnd() {
        return this.end;
    }

    @Generated
    public BigDecimal getRegularPrice() {
        return this.regularPrice;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public Integer getAvailableSeats() {
        return this.availableSeats;
    }

    @Generated
    public BigDecimal getVatPercentage() {
        return this.vatPercentage;
    }

    @Generated
    public boolean isVatIncluded() {
        return this.vatIncluded;
    }

    @Generated
    public List<PaymentProxy> getAllowedPaymentProxies() {
        return this.allowedPaymentProxies;
    }

    @Generated
    public List<TicketCategoryModification> getTicketCategories() {
        return this.ticketCategories;
    }

    @Generated
    public boolean isFreeOfCharge() {
        return this.freeOfCharge;
    }

    @Generated
    public LocationDescriptor getLocationDescriptor() {
        return this.locationDescriptor;
    }

    @Generated
    public int getLocales() {
        return this.locales;
    }

    @Generated
    public List<AdditionalFieldRequest> getTicketFields() {
        return this.ticketFields;
    }

    @Generated
    public List<AdditionalService> getAdditionalServices() {
        return this.additionalServices;
    }

    @Generated
    public AlfioMetadata getMetadata() {
        return this.metadata;
    }

    @Generated
    public List<UUID> getLinkedSubscriptions() {
        return this.linkedSubscriptions;
    }
}

