/*
 * Decompiled with CFR 0.152.
 */
package alfio.model.modification;

import alfio.model.modification.PollOptionModification;
import alfio.model.poll.Poll;
import alfio.model.poll.PollWithOptions;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class PollModification {
    private final Long id;
    private final Map<String, String> title;
    private final Map<String, String> description;
    private final int order;
    private final List<PollOptionModification> options;
    private final boolean accessRestricted;
    private final Poll.PollStatus status;

    @JsonCreator
    public PollModification(@JsonProperty(value="id") Long id, @JsonProperty(value="title") Map<String, String> title, @JsonProperty(value="description") Map<String, String> description, @JsonProperty(value="order") Integer order, @JsonProperty(value="options") List<PollOptionModification> options, @JsonProperty(value="accessRestricted") Boolean accessRestricted, @JsonProperty(value="status") Poll.PollStatus status) {
        this.id = id;
        this.title = title;
        this.description = description;
        this.order = Objects.requireNonNullElse(order, 0);
        this.options = options;
        this.accessRestricted = Objects.requireNonNullElse(accessRestricted, false);
        this.status = status;
    }

    public boolean isValid() {
        return this.isValid(null);
    }

    public boolean isValid(Long pollId) {
        return Objects.equals(pollId, this.id) && MapUtils.isNotEmpty((Map)this.title) && CollectionUtils.isNotEmpty((Collection)this.options) && this.options.stream().allMatch(p -> p.isValid(pollId != null && p.getId() != null));
    }

    public static PollModification from(Poll poll) {
        return new PollModification(Long.valueOf(poll.getId()), poll.getTitle(), poll.getDescription(), Integer.valueOf(poll.getOrder()), List.of(), Boolean.valueOf(!poll.getAllowedTags().isEmpty()), poll.getStatus());
    }

    public static PollModification from(PollWithOptions pollWithOptions) {
        Poll poll = pollWithOptions.getPoll();
        return new PollModification(Long.valueOf(poll.getId()), poll.getTitle(), poll.getDescription(), Integer.valueOf(poll.getOrder()), pollWithOptions.getOptions().stream().map(PollOptionModification::from).collect(Collectors.toList()), Boolean.valueOf(!poll.getAllowedTags().isEmpty()), poll.getStatus());
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Map<String, String> getTitle() {
        return this.title;
    }

    @Generated
    public Map<String, String> getDescription() {
        return this.description;
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public List<PollOptionModification> getOptions() {
        return this.options;
    }

    @Generated
    public boolean isAccessRestricted() {
        return this.accessRestricted;
    }

    @Generated
    public Poll.PollStatus getStatus() {
        return this.status;
    }
}

