/*
 * Decompiled with CFR 0.152.
 */
package alfio.model.modification;

import alfio.model.PromoCodeDiscount;
import alfio.model.modification.DateTimeModification;
import alfio.util.MonetaryUtil;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;

public class PromoCodeDiscountModification {
    private final Integer organizationId;
    private final Integer eventId;
    private final String promoCode;
    private final String currencyCode;
    private final DateTimeModification start;
    private final DateTimeModification end;
    private final BigDecimal discountAmount;
    private final PromoCodeDiscount.DiscountType discountType;
    private final List<Integer> categories;
    private final Integer utcOffset;
    private final Integer maxUsage;
    private final String description;
    private final String emailReference;
    private final PromoCodeDiscount.CodeType codeType;
    private final Integer hiddenCategoryId;

    @JsonCreator
    public PromoCodeDiscountModification(@JsonProperty(value="organizationId") Integer organizationId, @JsonProperty(value="eventId") Integer eventId, @JsonProperty(value="promoCode") String promoCode, @JsonProperty(value="start") DateTimeModification start, @JsonProperty(value="end") DateTimeModification end, @JsonProperty(value="discountAmount") BigDecimal discountAmount, @JsonProperty(value="currencyCode") String currencyCode, @JsonProperty(value="discountType") PromoCodeDiscount.DiscountType discountType, @JsonProperty(value="categories") List<Integer> categories, @JsonProperty(value="utcOffset") Integer utcOffset, @JsonProperty(value="maxUsage") Integer maxUsage, @JsonProperty(value="description") String description, @JsonProperty(value="emailReference") String emailReference, @JsonProperty(value="codeType") PromoCodeDiscount.CodeType codeType, @JsonProperty(value="hiddenCategoryId") Integer hiddenCategoryId) {
        this.organizationId = organizationId;
        this.eventId = eventId;
        this.promoCode = promoCode;
        this.start = start;
        this.end = end;
        this.discountAmount = discountAmount;
        this.currencyCode = currencyCode;
        this.discountType = discountType;
        this.categories = Optional.ofNullable(categories).map(l -> l.stream().filter(Objects::nonNull).collect(Collectors.toList())).orElse(Collections.emptyList());
        this.utcOffset = utcOffset;
        this.maxUsage = maxUsage;
        this.description = description;
        this.emailReference = emailReference;
        this.codeType = Optional.ofNullable(codeType).orElse(PromoCodeDiscount.CodeType.DISCOUNT);
        this.hiddenCategoryId = hiddenCategoryId;
    }

    private int getDiscountAsPercent() {
        return Optional.ofNullable(this.discountAmount).map(BigDecimal::intValue).orElse(0);
    }

    private int getDiscountInCents(String currencyCode) {
        return MonetaryUtil.unitToCents((BigDecimal)this.discountAmount, (String)currencyCode);
    }

    public int getDiscountValue() {
        if (this.codeType != PromoCodeDiscount.CodeType.DISCOUNT) {
            return 0;
        }
        if (this.discountType == PromoCodeDiscount.DiscountType.PERCENTAGE) {
            return this.getDiscountAsPercent();
        }
        return this.getDiscountInCents(this.currencyCode);
    }

    @Generated
    public Integer getOrganizationId() {
        return this.organizationId;
    }

    @Generated
    public Integer getEventId() {
        return this.eventId;
    }

    @Generated
    public String getPromoCode() {
        return this.promoCode;
    }

    @Generated
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    @Generated
    public DateTimeModification getStart() {
        return this.start;
    }

    @Generated
    public DateTimeModification getEnd() {
        return this.end;
    }

    @Generated
    public BigDecimal getDiscountAmount() {
        return this.discountAmount;
    }

    @Generated
    public PromoCodeDiscount.DiscountType getDiscountType() {
        return this.discountType;
    }

    @Generated
    public List<Integer> getCategories() {
        return this.categories;
    }

    @Generated
    public Integer getUtcOffset() {
        return this.utcOffset;
    }

    @Generated
    public Integer getMaxUsage() {
        return this.maxUsage;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getEmailReference() {
        return this.emailReference;
    }

    @Generated
    public PromoCodeDiscount.CodeType getCodeType() {
        return this.codeType;
    }

    @Generated
    public Integer getHiddenCategoryId() {
        return this.hiddenCategoryId;
    }
}

