/*
 * Decompiled with CFR 0.152.
 */
package alfio.model.modification;

import alfio.model.EventStatistic;
import alfio.model.PromoCodeDiscount;
import alfio.util.ClockProvider;
import alfio.util.MonetaryUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class PromoCodeDiscountWithFormattedTimeAndAmount {
    @JsonIgnore
    private final PromoCodeDiscount promo;
    @JsonIgnore
    private final ZoneId eventZoneId;
    private final String eventCurrency;

    public PromoCodeDiscountWithFormattedTimeAndAmount(PromoCodeDiscount promo, ZoneId eventZoneId, String eventCurrency) {
        this.promo = promo;
        this.eventZoneId = eventZoneId;
        this.eventCurrency = eventCurrency;
    }

    public boolean isCurrentlyValid() {
        return this.isCurrentlyValid(this.eventZoneId, ZonedDateTime.now(ClockProvider.clock().withZone(this.eventZoneId)));
    }

    public boolean isExpired() {
        return this.isExpired(this.eventZoneId, ZonedDateTime.now(ClockProvider.clock().withZone(this.eventZoneId)));
    }

    public String getFormattedStart() {
        return this.getUtcStart().withZoneSameInstant(this.eventZoneId).format(EventStatistic.JSON_DATE_FORMATTER);
    }

    public String getFormattedEnd() {
        return this.getUtcEnd().withZoneSameInstant(this.eventZoneId).format(EventStatistic.JSON_DATE_FORMATTER);
    }

    public String getFormattedDiscountAmount() {
        String currency = (String)StringUtils.firstNonEmpty((CharSequence[])new String[]{this.eventCurrency, this.promo.getCurrencyCode()});
        if (this.promo.getFixedAmount() && StringUtils.isNotBlank((CharSequence)currency)) {
            return MonetaryUtil.formatCents((int)this.promo.getDiscountAmount(), (String)currency);
        }
        return null;
    }

    @Generated
    public boolean isCurrentlyValid(ZoneId eventZoneId, ZonedDateTime now) {
        return this.promo.isCurrentlyValid(eventZoneId, now);
    }

    @Generated
    public boolean isExpired(ZoneId eventZoneId, ZonedDateTime now) {
        return this.promo.isExpired(eventZoneId, now);
    }

    @Generated
    public boolean getFixedAmount() {
        return this.promo.getFixedAmount();
    }

    @Generated
    public boolean isDynamic() {
        return this.promo.isDynamic();
    }

    @Generated
    public boolean hasCurrencyCode() {
        return this.promo.hasCurrencyCode();
    }

    @Generated
    public int getId() {
        return this.promo.getId();
    }

    @Generated
    public String getPromoCode() {
        return this.promo.getPromoCode();
    }

    @Generated
    public Integer getEventId() {
        return this.promo.getEventId();
    }

    @Generated
    public Integer getOrganizationId() {
        return this.promo.getOrganizationId();
    }

    @Generated
    public ZonedDateTime getUtcStart() {
        return this.promo.getUtcStart();
    }

    @Generated
    public ZonedDateTime getUtcEnd() {
        return this.promo.getUtcEnd();
    }

    @Generated
    public int getDiscountAmount() {
        return this.promo.getDiscountAmount();
    }

    @Generated
    public PromoCodeDiscount.DiscountType getDiscountType() {
        return this.promo.getDiscountType();
    }

    @Generated
    public Set<Integer> getCategories() {
        return this.promo.getCategories();
    }

    @Generated
    public Integer getMaxUsage() {
        return this.promo.getMaxUsage();
    }

    @Generated
    public String getDescription() {
        return this.promo.getDescription();
    }

    @Generated
    public String getEmailReference() {
        return this.promo.getEmailReference();
    }

    @Generated
    public PromoCodeDiscount.CodeType getCodeType() {
        return this.promo.getCodeType();
    }

    @Generated
    public Integer getHiddenCategoryId() {
        return this.promo.getHiddenCategoryId();
    }

    @Generated
    public String getCurrencyCode() {
        return this.promo.getCurrencyCode();
    }
}

