/*
 * Decompiled with CFR 0.152.
 */
package alfio.model.modification;

import alfio.model.PriceContainer;
import alfio.model.modification.DateTimeModification;
import alfio.model.result.ErrorCode;
import alfio.model.result.Result;
import alfio.model.subscription.SubscriptionDescriptor;
import alfio.model.transaction.PaymentProxy;
import alfio.util.MonetaryUtil;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public class SubscriptionDescriptorModification {
    private final UUID id;
    private final Map<String, String> title;
    private final Map<String, String> description;
    private final Integer maxAvailable;
    private final ZonedDateTime onSaleFrom;
    private final ZonedDateTime onSaleTo;
    private final BigDecimal price;
    private final BigDecimal vat;
    private final PriceContainer.VatStatus vatStatus;
    private final String currency;
    private final Boolean isPublic;
    private final int organizationId;
    private final Integer maxEntries;
    private final SubscriptionDescriptor.SubscriptionValidityType validityType;
    private final SubscriptionDescriptor.SubscriptionTimeUnit validityTimeUnit;
    private final Integer validityUnits;
    private final ZonedDateTime validityFrom;
    private final ZonedDateTime validityTo;
    private final SubscriptionDescriptor.SubscriptionUsageType usageType;
    private final String termsAndConditionsUrl;
    private final String privacyPolicyUrl;
    private final String fileBlobId;
    private final List<PaymentProxy> paymentProxies;
    private final ZoneId timeZone;
    private final Boolean supportsTicketsGeneration;

    public SubscriptionDescriptorModification(@JsonProperty(value="id") UUID id, @JsonProperty(value="title") Map<String, String> title, @JsonProperty(value="description") Map<String, String> description, @JsonProperty(value="maxAvailable") Integer maxAvailable, @JsonProperty(value="onSaleFrom") ZonedDateTime onSaleFrom, @JsonProperty(value="onSaleTo") ZonedDateTime onSaleTo, @JsonProperty(value="price") BigDecimal price, @JsonProperty(value="vat") BigDecimal vat, @JsonProperty(value="vatStatus") PriceContainer.VatStatus vatStatus, @JsonProperty(value="currency") String currency, @JsonProperty(value="isPublic") Boolean isPublic, @JsonProperty(value="organizationId") int organizationId, @JsonProperty(value="maxEntries") Integer maxEntries, @JsonProperty(value="validityType") SubscriptionDescriptor.SubscriptionValidityType validityType, @JsonProperty(value="validityTimeUnit") SubscriptionDescriptor.SubscriptionTimeUnit validityTimeUnit, @JsonProperty(value="validityUnits") Integer validityUnits, @JsonProperty(value="validityFrom") ZonedDateTime validityFrom, @JsonProperty(value="validityTo") ZonedDateTime validityTo, @JsonProperty(value="usageType") SubscriptionDescriptor.SubscriptionUsageType usageType, @JsonProperty(value="termsAndConditionsUrl") String termsAndConditionsUrl, @JsonProperty(value="privacyPolicyUrl") String privacyPolicyUrl, @JsonProperty(value="fileBlobId") String fileBlobId, @JsonProperty(value="paymentProxies") List<PaymentProxy> paymentProxies, @JsonProperty(value="timeZone") ZoneId timeZone, @JsonProperty(value="supportsTicketsGeneration") Boolean supportsTicketsGeneration) {
        this.id = id;
        this.title = Objects.requireNonNullElse(title, Map.of());
        this.description = Objects.requireNonNullElse(description, Map.of());
        this.maxAvailable = maxAvailable;
        this.onSaleFrom = onSaleFrom;
        this.onSaleTo = onSaleTo;
        this.price = price;
        this.vat = vat;
        this.vatStatus = vatStatus;
        this.currency = currency;
        this.isPublic = isPublic;
        this.organizationId = organizationId;
        this.maxEntries = maxEntries;
        this.validityType = validityType;
        this.validityTimeUnit = validityTimeUnit;
        this.validityUnits = validityUnits;
        this.validityFrom = validityFrom;
        this.validityTo = validityTo;
        this.usageType = usageType;
        this.termsAndConditionsUrl = termsAndConditionsUrl;
        this.privacyPolicyUrl = privacyPolicyUrl;
        this.fileBlobId = fileBlobId;
        this.paymentProxies = Objects.requireNonNullElse(paymentProxies, List.of());
        this.timeZone = timeZone;
        this.supportsTicketsGeneration = supportsTicketsGeneration;
    }

    public int getPriceCts() {
        return MonetaryUtil.unitToCents((BigDecimal)this.price, (String)this.currency);
    }

    public DateTimeModification getValidityFromModel() {
        return DateTimeModification.fromZonedDateTime((ZonedDateTime)this.validityFrom);
    }

    public DateTimeModification getValidityToModel() {
        return DateTimeModification.fromZonedDateTime((ZonedDateTime)this.validityTo);
    }

    public DateTimeModification getOnSaleFromModel() {
        return DateTimeModification.fromZonedDateTime((ZonedDateTime)this.onSaleFrom);
    }

    public DateTimeModification getOnSaleToModel() {
        return DateTimeModification.fromZonedDateTime((ZonedDateTime)this.onSaleTo);
    }

    public String getPublicIdentifier() {
        return this.getId().toString();
    }

    public static SubscriptionDescriptorModification fromModel(SubscriptionDescriptor subscriptionDescriptor) {
        return new SubscriptionDescriptorModification(subscriptionDescriptor.getId(), subscriptionDescriptor.getTitle(), subscriptionDescriptor.getDescription(), Integer.valueOf(subscriptionDescriptor.getMaxAvailable()), subscriptionDescriptor.getOnSaleFrom(), subscriptionDescriptor.getOnSaleTo(), MonetaryUtil.centsToUnit((int)subscriptionDescriptor.getPrice(), (String)subscriptionDescriptor.getCurrency()), subscriptionDescriptor.getVat(), subscriptionDescriptor.getVatStatus(), subscriptionDescriptor.getCurrency(), Boolean.valueOf(subscriptionDescriptor.isPublic()), subscriptionDescriptor.getOrganizationId(), Integer.valueOf(subscriptionDescriptor.getMaxEntries()), subscriptionDescriptor.getValidityType(), subscriptionDescriptor.getValidityTimeUnit(), subscriptionDescriptor.getValidityUnits(), subscriptionDescriptor.getValidityFrom(), subscriptionDescriptor.getValidityTo(), subscriptionDescriptor.getUsageType(), subscriptionDescriptor.getTermsAndConditionsUrl(), subscriptionDescriptor.getPrivacyPolicyUrl(), subscriptionDescriptor.getFileBlobId(), subscriptionDescriptor.getPaymentProxies(), subscriptionDescriptor.getZoneId(), Boolean.valueOf(subscriptionDescriptor.isSupportsTicketsGeneration()));
    }

    public static Result<SubscriptionDescriptorModification> validate(SubscriptionDescriptorModification input) {
        return new Result.Builder().checkPrecondition(() -> !input.title.isEmpty(), ErrorCode.custom((String)"title", (String)"Title is mandatory")).checkPrecondition(() -> !input.description.isEmpty(), ErrorCode.custom((String)"description", (String)"Description is mandatory")).checkPrecondition(() -> input.title.keySet().equals(input.description.keySet()), ErrorCode.custom((String)"locale-mismatch", (String)"Mismatch between supported translations")).checkPrecondition(() -> StringUtils.isNotBlank((CharSequence)input.termsAndConditionsUrl), ErrorCode.custom((String)"terms", (String)"Terms and Conditions are mandatory")).checkPrecondition(() -> StringUtils.isNotBlank((CharSequence)input.fileBlobId), ErrorCode.custom((String)"logo", (String)"Logo is required")).checkPrecondition(() -> StringUtils.isNotBlank((CharSequence)input.currency) && StringUtils.length((CharSequence)input.currency) == 3, ErrorCode.custom((String)"currency", (String)"Currency Code is required")).checkPrecondition(() -> input.vatStatus != null, ErrorCode.custom((String)"taxPolicy", (String)"Tax Policy is required")).checkPrecondition(() -> input.vat != null, ErrorCode.custom((String)"taxes", (String)"Tax percentage is required")).checkPrecondition(() -> input.onSaleFrom != null, ErrorCode.custom((String)"onSaleFrom", (String)"'On Sale From' is required")).checkPrecondition(() -> input.timeZone != null, ErrorCode.custom((String)"timeZone", (String)"Time Zone is required")).checkPrecondition(() -> !input.paymentProxies.isEmpty(), ErrorCode.custom((String)"paymentMethods", (String)"At least one Payment Method is required")).checkPrecondition(() -> input.price != null, ErrorCode.custom((String)"price", (String)"Price is mandatory")).checkPrecondition(() -> input.usageType != null, ErrorCode.custom((String)"usageType", (String)"UsageType is mandatory")).checkPrecondition(() -> StringUtils.isNotBlank((CharSequence)input.fileBlobId), ErrorCode.custom((String)"logo", (String)"Logo is required")).build(() -> input);
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public Map<String, String> getTitle() {
        return this.title;
    }

    @Generated
    public Map<String, String> getDescription() {
        return this.description;
    }

    @Generated
    public Integer getMaxAvailable() {
        return this.maxAvailable;
    }

    @Generated
    public ZonedDateTime getOnSaleFrom() {
        return this.onSaleFrom;
    }

    @Generated
    public ZonedDateTime getOnSaleTo() {
        return this.onSaleTo;
    }

    @Generated
    public BigDecimal getPrice() {
        return this.price;
    }

    @Generated
    public BigDecimal getVat() {
        return this.vat;
    }

    @Generated
    public PriceContainer.VatStatus getVatStatus() {
        return this.vatStatus;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public Boolean getIsPublic() {
        return this.isPublic;
    }

    @Generated
    public int getOrganizationId() {
        return this.organizationId;
    }

    @Generated
    public Integer getMaxEntries() {
        return this.maxEntries;
    }

    @Generated
    public SubscriptionDescriptor.SubscriptionValidityType getValidityType() {
        return this.validityType;
    }

    @Generated
    public SubscriptionDescriptor.SubscriptionTimeUnit getValidityTimeUnit() {
        return this.validityTimeUnit;
    }

    @Generated
    public Integer getValidityUnits() {
        return this.validityUnits;
    }

    @Generated
    public ZonedDateTime getValidityFrom() {
        return this.validityFrom;
    }

    @Generated
    public ZonedDateTime getValidityTo() {
        return this.validityTo;
    }

    @Generated
    public SubscriptionDescriptor.SubscriptionUsageType getUsageType() {
        return this.usageType;
    }

    @Generated
    public String getTermsAndConditionsUrl() {
        return this.termsAndConditionsUrl;
    }

    @Generated
    public String getPrivacyPolicyUrl() {
        return this.privacyPolicyUrl;
    }

    @Generated
    public String getFileBlobId() {
        return this.fileBlobId;
    }

    @Generated
    public List<PaymentProxy> getPaymentProxies() {
        return this.paymentProxies;
    }

    @Generated
    public ZoneId getTimeZone() {
        return this.timeZone;
    }

    @Generated
    public Boolean getSupportsTicketsGeneration() {
        return this.supportsTicketsGeneration;
    }
}

