/*
 * Decompiled with CFR 0.152.
 */
package alfio.model.modification;

import alfio.model.PriceContainer;
import alfio.model.Ticket;
import alfio.model.TicketReservation;
import alfio.model.transaction.Transaction;
import alfio.util.MonetaryUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import lombok.Generated;
import org.apache.commons.lang3.builder.CompareToBuilder;

public class TicketWithStatistic
implements Comparable<TicketWithStatistic>,
PriceContainer {
    @JsonIgnore
    private final Ticket ticket;
    private final TicketReservation ticketReservation;
    @JsonIgnore
    private final ZoneId zoneId;
    @JsonIgnore
    private final Optional<Transaction> tx;
    private final String promoCodeOrToken;
    @JsonIgnore
    private final Function<ZonedDateTime, LocalDateTime> dateMapper;

    public TicketWithStatistic(Ticket ticket, TicketReservation ticketReservation, ZoneId zoneId, Optional<Transaction> tx, String promoCodeOrToken) {
        this.ticket = ticket;
        this.ticketReservation = ticketReservation;
        this.zoneId = zoneId;
        this.tx = tx;
        this.dateMapper = d -> d.withZoneSameInstant(this.zoneId).toLocalDateTime();
        this.promoCodeOrToken = promoCodeOrToken;
    }

    public boolean isStuck() {
        return this.ticketReservation.isStuck();
    }

    public boolean isPaid() {
        return this.tx.isPresent();
    }

    public boolean isPending() {
        return this.getStatus() == Ticket.TicketStatus.PENDING;
    }

    public Transaction getTransaction() {
        return this.tx.orElse(null);
    }

    public LocalDateTime getTransactionTimestamp() {
        return this.tx.map(Transaction::getTimestamp).map(this.dateMapper).orElse(null);
    }

    public LocalDateTime getTimestamp() {
        return Optional.ofNullable(this.ticketReservation.getConfirmationTimestamp()).map(this.dateMapper).orElse(null);
    }

    @Override
    public int compareTo(TicketWithStatistic o) {
        return new CompareToBuilder().append((Object)this.getTimestamp(), (Object)o.getTimestamp()).toComparison();
    }

    @JsonIgnore
    public Optional<BigDecimal> getOptionalVatPercentage() {
        return Optional.ofNullable(this.ticketReservation.getUsedVatPercent());
    }

    public BigDecimal getAppliedDiscount() {
        return MonetaryUtil.centsToUnit((int)this.ticket.getDiscountCts(), (String)this.ticket.getCurrencyCode());
    }

    public BigDecimal getFinalPrice() {
        return MonetaryUtil.centsToUnit((int)this.ticket.getFinalPriceCts(), (String)this.ticket.getCurrencyCode());
    }

    public BigDecimal getVAT() {
        return MonetaryUtil.centsToUnit((int)this.ticket.getVatCts(), (String)this.ticket.getCurrencyCode());
    }

    public PriceContainer.VatStatus getVatStatus() {
        return this.ticketReservation.getVatStatus();
    }

    @Generated
    public Ticket getTicket() {
        return this.ticket;
    }

    @Generated
    public TicketReservation getTicketReservation() {
        return this.ticketReservation;
    }

    @Generated
    public ZoneId getZoneId() {
        return this.zoneId;
    }

    @Generated
    public Optional<Transaction> getTx() {
        return this.tx;
    }

    @Generated
    public String getPromoCodeOrToken() {
        return this.promoCodeOrToken;
    }

    @Generated
    public Function<ZonedDateTime, LocalDateTime> getDateMapper() {
        return this.dateMapper;
    }

    @Generated
    public boolean getAssigned() {
        return this.getTicket().getAssigned();
    }

    @Generated
    public boolean getLockedAssignment() {
        return this.getTicket().getLockedAssignment();
    }

    @Generated
    public String ticketCode(String eventKey, boolean caseInsensitive) {
        return this.getTicket().ticketCode(eventKey, caseInsensitive);
    }

    @Generated
    public String hmacTicketInfo(String eventKey, boolean caseInsensitive) {
        return this.getTicket().hmacTicketInfo(eventKey, caseInsensitive);
    }

    @Generated
    public boolean hasBeenSold() {
        return this.getTicket().hasBeenSold();
    }

    @Generated
    public boolean isCheckedIn() {
        return this.getTicket().isCheckedIn();
    }

    @Generated
    public String getFullName() {
        return this.getTicket().getFullName();
    }

    @Generated
    public String getFormattedFinalPrice() {
        return this.getTicket().getFormattedFinalPrice();
    }

    @Generated
    public String getFormattedNetPrice() {
        return this.getTicket().getFormattedNetPrice();
    }

    @Generated
    public Ticket withVatStatus(PriceContainer.VatStatus newVatStatus) {
        return this.getTicket().withVatStatus(newVatStatus);
    }

    @Generated
    public int getId() {
        return this.getTicket().getId();
    }

    @Generated
    public String getUuid() {
        return this.getTicket().getUuid();
    }

    @Generated
    public UUID getPublicUuid() {
        return this.getTicket().getPublicUuid();
    }

    @Generated
    public ZonedDateTime getCreation() {
        return this.getTicket().getCreation();
    }

    @Generated
    public Integer getCategoryId() {
        return this.getTicket().getCategoryId();
    }

    @Generated
    public int getEventId() {
        return this.getTicket().getEventId();
    }

    @Generated
    public Ticket.TicketStatus getStatus() {
        return this.getTicket().getStatus();
    }

    @Generated
    public String getTicketsReservationId() {
        return this.getTicket().getTicketsReservationId();
    }

    @Generated
    public String getFirstName() {
        return this.getTicket().getFirstName();
    }

    @Generated
    public String getLastName() {
        return this.getTicket().getLastName();
    }

    @Generated
    public String getEmail() {
        return this.getTicket().getEmail();
    }

    @Generated
    public String getUserLanguage() {
        return this.getTicket().getUserLanguage();
    }

    @Generated
    public int getSrcPriceCts() {
        return this.getTicket().getSrcPriceCts();
    }

    @Generated
    public int getFinalPriceCts() {
        return this.getTicket().getFinalPriceCts();
    }

    @Generated
    public int getVatCts() {
        return this.getTicket().getVatCts();
    }

    @Generated
    public int getDiscountCts() {
        return this.getTicket().getDiscountCts();
    }

    @Generated
    public String getExtReference() {
        return this.getTicket().getExtReference();
    }

    @Generated
    public String getCurrencyCode() {
        return this.getTicket().getCurrencyCode();
    }

    @Generated
    public List<String> getTags() {
        return this.getTicket().getTags();
    }

    @Generated
    public UUID getSubscriptionId() {
        return this.getTicket().getSubscriptionId();
    }
}

