/*
 * Decompiled with CFR 0.152.
 */
package alfio.model.modification;

import alfio.model.user.User;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import lombok.Generated;

public class UserModification {
    private final Integer id;
    private final int organizationId;
    private final String role;
    private final String username;
    private final String firstName;
    private final String lastName;
    private final String emailAddress;
    private final User.Type type;
    private final Long validTo;
    private final String description;

    @JsonCreator
    public UserModification(@JsonProperty(value="id") Integer id, @JsonProperty(value="organizationId") int organizationId, @JsonProperty(value="role") String role, @JsonProperty(value="username") String username, @JsonProperty(value="firstName") String firstName, @JsonProperty(value="lastName") String lastName, @JsonProperty(value="emailAddress") String emailAddress, @JsonProperty(value="type") User.Type type, @JsonProperty(value="validTo") Long validTo, @JsonProperty(value="description") String description) {
        this.id = id;
        this.organizationId = organizationId;
        this.role = role;
        this.username = username;
        this.firstName = firstName;
        this.lastName = lastName;
        this.emailAddress = emailAddress;
        this.type = type;
        this.validTo = validTo;
        this.description = description;
    }

    public ZonedDateTime getValidToAsDateTime() {
        return this.validTo == null ? null : ZonedDateTime.ofInstant(Instant.ofEpochSecond(this.validTo), ZoneId.of("UTC"));
    }

    @Generated
    public Integer getId() {
        return this.id;
    }

    @Generated
    public int getOrganizationId() {
        return this.organizationId;
    }

    @Generated
    public String getRole() {
        return this.role;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getFirstName() {
        return this.firstName;
    }

    @Generated
    public String getLastName() {
        return this.lastName;
    }

    @Generated
    public String getEmailAddress() {
        return this.emailAddress;
    }

    @Generated
    public User.Type getType() {
        return this.type;
    }

    @Generated
    public Long getValidTo() {
        return this.validTo;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

