/*
 * Decompiled with CFR 0.152.
 */
package alfio.model.modification.support;

import alfio.manager.system.ConfigurationManager;
import alfio.model.Event;
import alfio.model.modification.support.LocationDescriptor;
import alfio.model.system.ConfigurationKeys;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.text.StringSubstitutor;

/*
 * Exception performing whole class analysis ignored.
 */
public class LocationDescriptor {
    private final String timeZone;
    private final String latitude;
    private final String longitude;
    private final String mapUrl;

    @JsonCreator
    public LocationDescriptor(@JsonProperty(value="timeZone") String timeZone, @JsonProperty(value="latitude") String latitude, @JsonProperty(value="longitude") String longitude, @JsonProperty(value="mapUrl") String mapUrl) {
        this.timeZone = timeZone;
        this.latitude = latitude;
        this.longitude = longitude;
        this.mapUrl = mapUrl;
    }

    public boolean getHasMapUrl() {
        return StringUtils.isNotBlank((CharSequence)this.mapUrl);
    }

    public static LocationDescriptor fromGeoData(Event.EventFormat format, Pair<String, String> coordinates, TimeZone timeZone, Map<ConfigurationKeys, ConfigurationManager.MaybeConfiguration> geoConf) {
        if (format == Event.EventFormat.ONLINE) {
            return new LocationDescriptor(timeZone.getID(), null, null, null);
        }
        String lat = (String)coordinates.getLeft();
        String lng = (String)coordinates.getRight();
        return new LocationDescriptor(timeZone.getID(), (String)coordinates.getLeft(), (String)coordinates.getRight(), LocationDescriptor.getMapUrl((String)lat, (String)lng, geoConf));
    }

    public static String getMapUrl(String lat, String lng, Map<ConfigurationKeys, ConfigurationManager.MaybeConfiguration> geoConf) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("latitude", lat);
        params.put("longitude", lng);
        ConfigurationKeys.GeoInfoProvider provider = LocationDescriptor.getProvider(geoConf);
        String mapUrl = LocationDescriptor.mapUrl((ConfigurationKeys.GeoInfoProvider)provider);
        LocationDescriptor.fillParams((ConfigurationKeys.GeoInfoProvider)provider, geoConf, params);
        return new StringSubstitutor(params).replace(mapUrl);
    }

    public static ConfigurationKeys.GeoInfoProvider getProvider(Map<ConfigurationKeys, ConfigurationManager.MaybeConfiguration> geoConf) {
        if ((!geoConf.containsKey(ConfigurationKeys.MAPS_PROVIDER) || geoConf.get(ConfigurationKeys.MAPS_PROVIDER).isEmpty()) && geoConf.containsKey(ConfigurationKeys.MAPS_CLIENT_API_KEY) && geoConf.get(ConfigurationKeys.MAPS_CLIENT_API_KEY).isPresent()) {
            return ConfigurationKeys.GeoInfoProvider.GOOGLE;
        }
        if (geoConf.containsKey(ConfigurationKeys.MAPS_PROVIDER) && geoConf.get(ConfigurationKeys.MAPS_PROVIDER).isPresent()) {
            return geoConf.get(ConfigurationKeys.MAPS_PROVIDER).getValue().map(ConfigurationKeys.GeoInfoProvider::valueOf).orElseThrow(IllegalStateException::new);
        }
        return ConfigurationKeys.GeoInfoProvider.NONE;
    }

    private static String mapUrl(ConfigurationKeys.GeoInfoProvider provider) {
        return switch (1.$SwitchMap$alfio$model$system$ConfigurationKeys$GeoInfoProvider[provider.ordinal()]) {
            case 1 -> "https://maps.googleapis.com/maps/api/staticmap?center=${latitude},${longitude}&key=${key}&zoom=16&size=400x400&markers=color:blue%7Clabel:E%7C${latitude},${longitude}";
            case 2 -> "https://image.maps.ls.hereapi.com/mia/1.6/mapview?c=${latitude},${longitude}&z=16&w=400&h=400&poi=${latitude},${longitude}&apikey=${key}";
            default -> "";
        };
    }

    private static void fillParams(ConfigurationKeys.GeoInfoProvider provider, Map<ConfigurationKeys, ConfigurationManager.MaybeConfiguration> geoConf, Map<String, String> params) {
        if (ConfigurationKeys.GeoInfoProvider.GOOGLE == provider) {
            geoConf.get(ConfigurationKeys.MAPS_CLIENT_API_KEY).getValue().ifPresent(key -> params.put("key", (String)key));
        } else if (ConfigurationKeys.GeoInfoProvider.HERE == provider) {
            geoConf.get(ConfigurationKeys.MAPS_HERE_API_KEY).getValue().ifPresent(key -> params.put("key", (String)key));
        }
    }

    @Generated
    public String getTimeZone() {
        return this.timeZone;
    }

    @Generated
    public String getLatitude() {
        return this.latitude;
    }

    @Generated
    public String getLongitude() {
        return this.longitude;
    }

    @Generated
    public String getMapUrl() {
        return this.mapUrl;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LocationDescriptor)) {
            return false;
        }
        LocationDescriptor other = (LocationDescriptor)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$timeZone = this.getTimeZone();
        String other$timeZone = other.getTimeZone();
        if (this$timeZone == null ? other$timeZone != null : !this$timeZone.equals(other$timeZone)) {
            return false;
        }
        String this$latitude = this.getLatitude();
        String other$latitude = other.getLatitude();
        if (this$latitude == null ? other$latitude != null : !this$latitude.equals(other$latitude)) {
            return false;
        }
        String this$longitude = this.getLongitude();
        String other$longitude = other.getLongitude();
        if (this$longitude == null ? other$longitude != null : !this$longitude.equals(other$longitude)) {
            return false;
        }
        String this$mapUrl = this.getMapUrl();
        String other$mapUrl = other.getMapUrl();
        return !(this$mapUrl == null ? other$mapUrl != null : !this$mapUrl.equals(other$mapUrl));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LocationDescriptor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $timeZone = this.getTimeZone();
        result = result * 59 + ($timeZone == null ? 43 : $timeZone.hashCode());
        String $latitude = this.getLatitude();
        result = result * 59 + ($latitude == null ? 43 : $latitude.hashCode());
        String $longitude = this.getLongitude();
        result = result * 59 + ($longitude == null ? 43 : $longitude.hashCode());
        String $mapUrl = this.getMapUrl();
        result = result * 59 + ($mapUrl == null ? 43 : $mapUrl.hashCode());
        return result;
    }
}

