/*
 * Decompiled with CFR 0.152.
 */
package alfio.model.poll;

import alfio.model.poll.PollOptionStatistics;
import alfio.model.poll.PollStatistics;
import alfio.util.MonetaryUtil;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
public class PollStatistics {
    private final int totalVotes;
    private final int allowedParticipants;
    private final List<PollOptionStatistics> countByOption;

    public int getTotalVotes() {
        return this.totalVotes;
    }

    public int getAllowedParticipants() {
        return this.allowedParticipants;
    }

    public String getParticipationPercentage() {
        return PollStatistics.getVotesPercentage((BigDecimal)new BigDecimal(this.allowedParticipants), (int)this.totalVotes);
    }

    public List<StatisticDetail> getOptionStatistics() {
        BigDecimal totalVotes = new BigDecimal(this.totalVotes);
        return this.countByOption.stream().map(o -> {
            String percentage = PollStatistics.getVotesPercentage((BigDecimal)totalVotes, (int)o.getVotes());
            return new StatisticDetail(o.getVotes(), o.getOptionId(), percentage);
        }).collect(Collectors.toList());
    }

    private static String getVotesPercentage(BigDecimal totalVotes, int votes) {
        if (votes == 0) {
            return "0";
        }
        return new BigDecimal(votes).setScale(3, RoundingMode.HALF_UP).divide(totalVotes, RoundingMode.HALF_UP).multiply(MonetaryUtil.HUNDRED).setScale(2, RoundingMode.HALF_UP).toPlainString();
    }

    @ConstructorProperties(value={"totalVotes", "allowedParticipants", "countByOption"})
    @Generated
    public PollStatistics(int totalVotes, int allowedParticipants, List<PollOptionStatistics> countByOption) {
        this.totalVotes = totalVotes;
        this.allowedParticipants = allowedParticipants;
        this.countByOption = countByOption;
    }
}

