/*
 * Decompiled with CFR 0.152.
 */
package alfio.model.result;

import alfio.model.result.ErrorCode;
import alfio.model.result.Result;
import alfio.model.result.ValidationResult;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.validation.ObjectError;

/*
 * Exception performing whole class analysis ignored.
 */
public class Result<T> {
    private final ResultStatus status;
    private final T data;
    private final List<ErrorCode> errors;

    public static <T> Result<T> success(T data) {
        return new Result(ResultStatus.OK, data, Collections.emptyList());
    }

    public static <T> Result<T> validationError(List<ObjectError> errors) {
        return new Result(ResultStatus.VALIDATION_ERROR, null, errors.stream().map(ValidationResult.ErrorDescriptor::fromObjectError).collect(Collectors.toList()));
    }

    public static <T> Result<T> error(List<ErrorCode> errorDescriptors) {
        return new Result(ResultStatus.ERROR, null, errorDescriptors);
    }

    public static <T> Result<T> error(ErrorCode errorDescriptor) {
        return Result.error(Collections.singletonList(errorDescriptor));
    }

    public boolean isSuccess() {
        return this.status == ResultStatus.OK;
    }

    public void ifSuccess(Consumer<T> consumer) {
        if (this.isSuccess()) {
            consumer.accept(this.data);
        }
    }

    public <K> Result<K> map(Function<T, K> mapper) {
        if (this.isSuccess()) {
            return Result.success(mapper.apply(this.data));
        }
        return Result.error((List)this.errors);
    }

    public <K> Result<K> flatMap(Function<T, Result<K>> mapper) {
        if (this.isSuccess()) {
            return Objects.requireNonNull(mapper.apply(this.data), "this method does not allow null values");
        }
        return Result.error((List)this.errors);
    }

    public ErrorCode getFirstErrorOrNull() {
        if (this.isSuccess() || CollectionUtils.size((Object)this.errors) == 0) {
            return null;
        }
        return (ErrorCode)this.errors.get(0);
    }

    public String getFormattedErrors() {
        if (this.isSuccess()) {
            return null;
        }
        return this.getErrors().stream().map(ErrorCode::getDescription).collect(Collectors.joining("\n"));
    }

    public static <T> Result<T> fromNullable(T nullable, ErrorCode justInCase) {
        if (nullable == null) {
            return Result.error((ErrorCode)justInCase);
        }
        return Result.success(nullable);
    }

    @ConstructorProperties(value={"status", "data", "errors"})
    @Generated
    public Result(ResultStatus status, T data, List<ErrorCode> errors) {
        this.status = status;
        this.data = data;
        this.errors = errors;
    }

    @Generated
    public ResultStatus getStatus() {
        return this.status;
    }

    @Generated
    public T getData() {
        return (T)this.data;
    }

    @Generated
    public List<ErrorCode> getErrors() {
        return this.errors;
    }
}

