/*
 * Decompiled with CFR 0.152.
 */
package alfio.model.result;

import alfio.model.result.ValidationResult;
import alfio.model.result.WarningMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ValidationResult {
    private static final ValidationResult SUCCESS = new ValidationResult(Collections.emptyList(), Collections.emptyList());
    private final List<ErrorDescriptor> errorDescriptors;
    private final int errorCount;
    private final List<WarningMessage> warnings;

    private ValidationResult(List<ErrorDescriptor> errorDescriptors, List<WarningMessage> warnings) {
        this.errorDescriptors = errorDescriptors;
        this.errorCount = errorDescriptors.size();
        this.warnings = warnings;
    }

    public List<ErrorDescriptor> getValidationErrors() {
        return this.getErrorDescriptors();
    }

    public static ValidationResult success() {
        return SUCCESS;
    }

    public static ValidationResult failed(List<ErrorDescriptor> errors) {
        return new ValidationResult(errors, List.of());
    }

    public static ValidationResult failed(List<ErrorDescriptor> errors, List<WarningMessage> warnings) {
        return new ValidationResult(errors, warnings);
    }

    public static ValidationResult failed(ErrorDescriptor ... errors) {
        return ValidationResult.failed(Arrays.asList(errors));
    }

    public static ValidationResult of(List<ErrorDescriptor> errors) {
        return errors.isEmpty() ? ValidationResult.success() : ValidationResult.failed(errors);
    }

    public ValidationResult ifSuccess(Operation operation) {
        if (this.errorCount == 0) {
            operation.doIt();
        }
        return this;
    }

    public ValidationResult or(ValidationResult second) {
        if (!this.isSuccess()) {
            ArrayList joined = new ArrayList();
            joined.addAll(this.errorDescriptors);
            joined.addAll(second.getErrorDescriptors());
            ArrayList allWarnings = new ArrayList(this.warnings);
            allWarnings.addAll(second.getWarnings());
            return new ValidationResult(joined, allWarnings);
        }
        return second;
    }

    public boolean isSuccess() {
        return this.errorCount == 0;
    }

    @Generated
    public List<ErrorDescriptor> getErrorDescriptors() {
        return this.errorDescriptors;
    }

    @Generated
    public int getErrorCount() {
        return this.errorCount;
    }

    @Generated
    public List<WarningMessage> getWarnings() {
        return this.warnings;
    }
}

